/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.hard.encryptor;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.hard.encryptor.ECCEncryptor;
import cfca.sadk.lib.crypto.hard.encryptor.Iox;
import cfca.sadk.lib.crypto.hard.encryptor.RSAEncryptor;
import cfca.sadk.lib.crypto.hard.encryptor.SM2Encryptor;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.Cipher;

public abstract class AbsEncryptor {
    final Provider provider;
    final String mType;
    final int sm2EncryptFormatProviderType;

    protected AbsEncryptor(Provider provider, String mType, int sm2EncryptFormatProviderType) throws Exception {
        this.provider = provider;
        this.mType = mType;
        this.sm2EncryptFormatProviderType = sm2EncryptFormatProviderType;
    }

    public abstract String getKeyType();

    public byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws Exception {
        if (key instanceof PublicKey) {
            Cipher cipher = Cipher.getInstance(this.mType, this.provider);
            cipher.init(1, this.formatPublicKey((PublicKey)key));
            return this.formatOutputEncryptData(cipher.doFinal(sourceData));
        }
        return BCSoftLib.INSTANCE().encrypt(mechanism, key, sourceData);
    }

    public byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws Exception {
        if (key instanceof PrivateKey) {
            Cipher cipher = Cipher.getInstance(this.mType, this.provider);
            cipher.init(2, this.formatPrivateKey((PrivateKey)key));
            return cipher.doFinal(this.formatInputEncryptData(encryptData));
        }
        return BCSoftLib.INSTANCE().decrypt(mechanism, key, encryptData);
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws Exception {
        String optName = this.getKeyType() + "Encrypt";
        byte[] data = Iox.read(optName, in);
        byte[] encryptData = this.encrypt(mechanism, key, data);
        Iox.write(optName, out, encryptData);
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream in, OutputStream out) throws Exception {
        String optName = this.getKeyType() + "Decrypt";
        byte[] encryptData = Iox.read(optName, in);
        byte[] decryptData = this.decrypt(mechanism, key, encryptData);
        Iox.write(optName, out, decryptData);
    }

    abstract PrivateKey formatPrivateKey(PrivateKey var1) throws Exception;

    abstract PublicKey formatPublicKey(PublicKey var1) throws Exception;

    abstract byte[] formatInputEncryptData(byte[] var1) throws Exception;

    abstract byte[] formatOutputEncryptData(byte[] var1) throws Exception;

    public static AbsEncryptor createHelper(Provider provider, Mechanism mechanism, int sm2EncryptFormatProviderType) throws Exception {
        if (mechanism == null) {
            throw new IllegalArgumentException("mechanism==null");
        }
        String mType = mechanism.getMechanismType();
        if (mType == null) {
            throw new IllegalArgumentException("mType==null");
        }
        mType = mType.toUpperCase();
        AbsEncryptor encryptor = null;
        if (mType.contains("SM2")) {
            encryptor = new SM2Encryptor(provider, mType, sm2EncryptFormatProviderType);
        } else if (mType.contains("RSA")) {
            encryptor = new RSAEncryptor(provider, mType, -1);
        } else if (mType.contains("EC")) {
            encryptor = new ECCEncryptor(provider, mType, -1);
        }
        return encryptor;
    }
}

