/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.security.external;

import cfca.com.itextpdf.text.pdf.security.BouncyCastleDigest;
import cfca.com.itextpdf.text.pdf.security.DigestAlgorithms;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2HashZValue;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.cert.PdfX509Certificate;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;

public class DoneExternalSessionSignature
implements ExternalSignature {
    private Signature sig;
    private PrivateKey privateKey;
    private String hashAlgorithm;
    private String provider;
    private String encryptionAlgorithm;
    private Certificate[] chain;

    public DoneExternalSessionSignature(PrivateKey privateKey, Certificate[] chain, String encryptionAlgorithm, String hashAlgorithm, String provider) {
        this.privateKey = privateKey;
        this.chain = chain;
        this.provider = provider;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.hashAlgorithm = DigestAlgorithms.getDigest(DigestAlgorithms.getAllowedDigests(hashAlgorithm));
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public byte[] sign(byte[] b) throws GeneralSecurityException {
        String signAlg = this.hashAlgorithm.toLowerCase() + "With" + this.encryptionAlgorithm + "Encryption";
        if (this.privateKey == null) {
            throw new GeneralSecurityException("private key not initialized correctly!");
        }
        byte[] signBytes = null;
        if ("RSA".equals(this.encryptionAlgorithm)) {
            this.sig = this.provider == null ? Signature.getInstance(signAlg) : Signature.getInstance(signAlg, this.provider);
            this.sig.initSign(this.privateKey);
            this.sig.update(b);
            signBytes = this.sig.sign();
        } else if ("SM2".equals(this.encryptionAlgorithm)) {
            try {
                MessageDigest messageDigest = new BouncyCastleDigest().getMessageDigest(this.hashAlgorithm);
                byte[] userId = "1234567812345678".getBytes("UTF8");
                PdfX509Certificate pdfX509Certificate = (PdfX509Certificate)this.chain[0];
                X509Cert x509Cert = pdfX509Certificate.getX509Cert();
                SM2PublicKey sm2PublicKey = (SM2PublicKey)x509Cert.getPublicKey();
                BigInteger pubX = sm2PublicKey.getPubXByInt();
                BigInteger pubY = sm2PublicKey.getPubYByInt();
                byte[] z = SM2HashZValue.getZa((BigInteger)pubX, (BigInteger)pubY, (byte[])userId);
                messageDigest.update(z, 0, z.length);
                messageDigest.update(b);
                byte[] digest = messageDigest.digest();
                Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
                BCSoftLib bclib = new BCSoftLib();
                signBytes = bclib.signByHash(mechanism, this.privateKey, digest);
            }
            catch (PKIException e) {
                throw new GeneralSecurityException(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new GeneralSecurityException("Unsupported encoding!");
            }
        }
        return signBytes;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Certificate[] getCertificateChain() {
        return this.chain;
    }
}

