/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.exception;

import java.util.Locale;
import java.util.ResourceBundle;

public enum TSAErrorCode {
    timestampConfigLoadFailure(0x60000001, "TimestampConfig load failure"),
    serverUrlInvalidMalformedURL(0x60000010, "serverUrl invalid malformedURL"),
    sslProtocolInvalid(0x60000011, "ssl protocol invalid"),
    serverUrlHTTPSRequireSSLContext(1610612754, "serverUrl https require SSLContext"),
    serverUrlHTTPAddBasicAuthFailure(1610612755, "serverUrl add basic authorization failure"),
    serverUrlSendReceivedHTTPFailure(1610612769, "serverUrl http message send/received failure"),
    serverUrlRecvInvalidPacket(0x60000026, "serverUrl http message receive invalid tsa"),
    httpsSSLTrustManagerFilePathMissing(0x60000050, "https trustManager init failure with jksTrustFilePath missing"),
    httpsSSLTrustManagerFilePasswordMissing(1610612818, "https trustManager init failure with jksTrustStoreFilePassword missing"),
    businessTrustCertFileInvalid(1610612859, "businessTrust invalid trustCertFile"),
    timestampClientMissingPolicyMode(0x60001000, "TimestampHelper missing parameter@PolicyMode"),
    timestampClientMissingConfig(0x60001001, "TimestampClient missing parameter@timestampConfig"),
    timestampClientMissingHashAlgorithm(1610616834, "TimestampClient missing parameter@hashAlgorithm"),
    timestampClientMissingSourceMessage(1610616835, "TimestampClient missing parameter@sourceMessage"),
    timestampClientMissingSourceStream(1610616836, "TimestampClient missing parameter@sourceStream"),
    timestampClientMissingMessageImprint(1610616837, "TimestampClient missing parameter@messageImprint"),
    timestampClientMessageImprintMissingAlgorithm(0x60001006, "TimestampClient messageImprint missing hashAlgorithm"),
    timestampClientMessageImprintMissingHashedMessage(1610616839, "TimestampClient messageImprint missing hashedMessage"),
    timestampClientMessageImprintInvalid(1610616840, "TimestampClient invalid parameter@messageImprint"),
    timestampClientMessageImprintInvalidHashAlgorithm(1610616841, "TimestampClient messageImprint invalid hashAlgorithm"),
    timestampClientMessageImprintMissingSourceData(1610616842, "TimestampClient messageImprint missing sourceData"),
    timestampClientMessageImprintBuildFailure(1610616843, "TimestampClient messageImprint build failure"),
    timestampClientRequestMessageBuildFailure(1610616844, "TimestampClient requestMessage build failure"),
    timestampClientBuildRequestorFailure(1610616845, "TimestampClient requestor build failure"),
    timestampClientResponseNonceMissing(0x60001010, "TimestampClient response without nonce"),
    timestampClientResponseNonceInvalid(0x60001011, "TimestampClient response with invalid nonce"),
    timestampClientResponsePolicyIdInvalid(1610616851, "TimestampClient response with invalid policyId)"),
    timestampClientResponseMessageImprintMissing(1610616852, "TimestampClient response without messageImprint"),
    timestampClientResponseMessageImprintInvalid(1610616853, "TimestampClient response with invalid messageImprint)"),
    timestampClientResponseSignedDataOrSignedCertInvalid(0x60001016, "TimestampClient response with invalid signedData or invalid signedCert"),
    timestampClientRequesterNotSetting(1610616855, "TimestampClient requester not setting"),
    timestampClientResponseFailure(0x6000FFFF, "TimestampClient response failure"),
    timestampTSASignedDataInvalid(0x60002000, "timestamp TSASignedData encode invalid"),
    timestampTSASignedDataMissingStatusInfo(1610620929, "timestamp TSASignedData missing statusInfo"),
    timestampTSASignedDataMissingStatusCode(0x60002002, "timestamp TSASignedData missing statusCode"),
    timestampTSASignedDataUnknownStatusCode(1610620931, "timestamp TSASignedData unknown statusCode"),
    timestampTSASignedDataMissingTimeStampToken(1610620932, "timestamp TSASignedData missing timeStampToken"),
    timestampTSASignedDataContainTimeStampToken(1610620933, "timestamp TSASignedData contain timeStampToken"),
    timestampTSASignedDataMissingFailInfo(0x60002006, "timestamp TSASignedData missing failInfo"),
    timestampTSASignedDataInvalidFailInfo(1610620935, "timestamp TSASignedData invalid failInfo"),
    timestampTSASignedDataPKIFreeTextFailure(1610620936, "timestamp TSASignedData freeText fetch failure"),
    timestampTSASignedDataInvalidContentInfo(1610620937, "timestamp TSASignedData invalid content"),
    timeStampTokenInfoMissingHashAlgorithm(1610625025, "timeStampTokenInfo missing hashAlgorithm"),
    timeStampTokenInfoInvalidHashAlgorithm(1610625026, "timeStampTokenInfo invalid hashAlgorithm"),
    timeStampTokenInfoMissingHashedMessage(0x60003003, "timeStampTokenInfo missing hashedMessage"),
    timeStampTokenInfoInvalidHashedMessage(1610625028, "timeStampTokenInfo invalid hashedMessage"),
    timeStampTokenInfoGenTimeFormatFailure(1610625029, "timeStampTokenInfo genTime format failure"),
    timeStampTokenInfoAccuracyFetchFailure(0x60003006, "timeStampTokenInfo accuracy fetch failure"),
    timeStampTokenInfoExtensionsFetchFailure(1610625031, "timeStampTokenInfo extensions fetch failure"),
    timeStampTokenInfoNonceFetchFailure(1610625032, "timeStampTokenInfo nonce fetch failure"),
    timeStampTokenInfoPolicyFetchFailure(1610625033, "timeStampTokenInfo policy fetch failure"),
    timeStampTokenInfoSerialNumberFetchFailure(1610625034, "timeStampTokenInfo serialNumber fetch failure"),
    timeStampTokenInfoTsaNameFetchFailure(1610625035, "timeStampTokenInfo tsaName fetch failure"),
    timeStampTokenInfoVersionFetchFailure(1610625036, "timeStampTokenInfo version fetch failure"),
    timeStampTokenValidationFailure(0x60004000, "timeStampToken contentInfo object not for a timestamp"),
    timeStampTokenFailureWithTSAException(1610629121, "timeStampToken construct throw TSAException"),
    timeStampTokenFailureWithIllegalArgumentException(1610629122, "timeStampToken construct throw IllegalArgumentException"),
    timeStampTokenFailureWithIOException(1610629123, "timeStampToken construct throw IOException"),
    timeStampTokenFailureWithException(0x60004004, "timeStampToken construct throw Exception"),
    timeStampTokenSourceDataFetchFailure(1610629125, "timeStampToken sourceData fetch failure"),
    timeStampTokenSignedCertFetchFailure(0x60004006, "timeStampToken signedCert fetch failure"),
    timeStampTokenSignedCertMissing(1610629127, "timeStampToken signedCert missing"),
    timeStampTokenSignedCertMoreThanOne(1610629128, "timeStampToken signedCert more than one"),
    timeStampTokenSignedCertFetchCertBytesFailure(1610629129, "timeStampToken signedCert fetch certBytes failure"),
    timeStampTokenSignedCertConvertToX509CertFailure(1610629130, "timeStampToken signedCert convert to X509Cert failure"),
    timeStampTokenSignedTimeMissing(1610629132, "timeStampToken missing signing-time attribute value"),
    timeStampTokenSignedTimeRequiredSingle(1610629134, "timeStampToken signing-time attribute MUST have a single attribute value"),
    timeStampTokenSignedTimeInvalidStructure(1610629135, "timeStampToken signing-time attribute value not a valid 'Time' structure"),
    timeStampTokenSignedDataInvalidSignature(1610633217, "timeStampToken signature not valid"),
    timeStampTokenSignedCertInvalidValidate(1610633218, "timeStampToken signercert validate not valid"),
    timeStampTokenSignedCertInvalidSignature(1610633219, "timeStampToken signercert signature not valid"),
    timeStampTokenSignedCertIsRevoked(1610633220, "timeStampToken signercert is revoked"),
    timestampHelperMissingTimestampConfig(1610641409, "timestampHelper missing timestampConfig"),
    statusHttpError(0x40000000, "TSA response failure with HTTPStatusInfo"),
    statusVerifiedError(0x50000000, "Timestamp verified failure"),
    statusPkiError(0x70000000, "TSA response failure with PKIStatusInfo"),
    UnknownError(-1, "TSA response failure with HTTPStatusInfo");

    public final int errorCode;
    public final String errorInfo;

    private TSAErrorCode(int errorCode, String errorInfo) {
        String info;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("timestampError", Locale.getDefault());
            info = bundle.getString("0x" + Integer.toHexString(errorCode));
        }
        catch (Exception e) {
            info = errorInfo;
        }
        this.errorCode = errorCode;
        this.errorInfo = info;
    }

    final String description() {
        return this.description(0);
    }

    final String description(int subcode) {
        return this.description(0, null);
    }

    public String description(String message) {
        return this.description(0, message);
    }

    public String description(int subcode, String message) {
        String name = super.toString();
        String code = Integer.toHexString(this.errorCode + subcode);
        String desc = null;
        desc = message == null ? String.format("0x%s-%-24s: %s", code, name, this.errorInfo) : String.format("0x%s-%-24s: %s\n\t\t%s", code, name, this.errorInfo, message);
        return desc;
    }
}

