/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.sfntly.table.core;

import cfca.com.google.typography.font.sfntly.data.ReadableFontData;
import cfca.com.google.typography.font.sfntly.data.WritableFontData;
import cfca.com.google.typography.font.sfntly.table.Header;
import cfca.com.google.typography.font.sfntly.table.Table;
import cfca.com.google.typography.font.sfntly.table.TableBasedTableBuilder;

public final class HorizontalHeaderTable
extends Table {
    private HorizontalHeaderTable(Header header, ReadableFontData data) {
        super(header, data);
    }

    public int tableVersion() {
        return this.data.readFixed(Offset.version.offset);
    }

    public int ascender() {
        return this.data.readShort(Offset.Ascender.offset);
    }

    public int descender() {
        return this.data.readShort(Offset.Descender.offset);
    }

    public int lineGap() {
        return this.data.readShort(Offset.LineGap.offset);
    }

    public int advanceWidthMax() {
        return this.data.readUShort(Offset.advanceWidthMax.offset);
    }

    public int minLeftSideBearing() {
        return this.data.readShort(Offset.minLeftSideBearing.offset);
    }

    public int minRightSideBearing() {
        return this.data.readShort(Offset.minRightSideBearing.offset);
    }

    public int xMaxExtent() {
        return this.data.readShort(Offset.xMaxExtent.offset);
    }

    public int caretSlopeRise() {
        return this.data.readShort(Offset.caretSlopeRise.offset);
    }

    public int caretSlopeRun() {
        return this.data.readShort(Offset.caretSlopeRun.offset);
    }

    public int caretOffset() {
        return this.data.readShort(Offset.caretOffset.offset);
    }

    public int metricDataFormat() {
        return this.data.readShort(Offset.metricDataFormat.offset);
    }

    public int numberOfHMetrics() {
        return this.data.readUShort(Offset.numberOfHMetrics.offset);
    }

    public static class Builder
    extends TableBasedTableBuilder<HorizontalHeaderTable> {
        public static Builder createBuilder(Header header, WritableFontData data) {
            return new Builder(header, data);
        }

        protected Builder(Header header, WritableFontData data) {
            super(header, data);
        }

        protected Builder(Header header, ReadableFontData data) {
            super(header, data);
        }

        @Override
        protected HorizontalHeaderTable subBuildTable(ReadableFontData data) {
            return new HorizontalHeaderTable(this.header(), data);
        }

        public int tableVersion() {
            return this.internalReadData().readFixed(Offset.version.offset);
        }

        public void setTableVersion(int version) {
            this.internalWriteData().writeFixed(Offset.version.offset, version);
        }

        public int ascender() {
            return this.internalReadData().readShort(Offset.Ascender.offset);
        }

        public void setAscender(int version) {
            this.internalWriteData().writeShort(Offset.Ascender.offset, version);
        }

        public int descender() {
            return this.internalReadData().readShort(Offset.Descender.offset);
        }

        public void setDescender(int version) {
            this.internalWriteData().writeShort(Offset.Descender.offset, version);
        }

        public int lineGap() {
            return this.internalReadData().readShort(Offset.LineGap.offset);
        }

        public void setLineGap(int version) {
            this.internalWriteData().writeShort(Offset.LineGap.offset, version);
        }

        public int advanceWidthMax() {
            return this.internalReadData().readUShort(Offset.advanceWidthMax.offset);
        }

        public void setAdvanceWidthMax(int version) {
            this.internalWriteData().writeUShort(Offset.advanceWidthMax.offset, version);
        }

        public int minLeftSideBearing() {
            return this.internalReadData().readShort(Offset.minLeftSideBearing.offset);
        }

        public void setMinLeftSideBearing(int version) {
            this.internalWriteData().writeShort(Offset.minLeftSideBearing.offset, version);
        }

        public int minRightSideBearing() {
            return this.internalReadData().readShort(Offset.minRightSideBearing.offset);
        }

        public void setMinRightSideBearing(int version) {
            this.internalWriteData().writeShort(Offset.minRightSideBearing.offset, version);
        }

        public int xMaxExtent() {
            return this.internalReadData().readShort(Offset.xMaxExtent.offset);
        }

        public void setXMaxExtent(int version) {
            this.internalWriteData().writeShort(Offset.xMaxExtent.offset, version);
        }

        public int caretSlopeRise() {
            return this.internalReadData().readUShort(Offset.caretSlopeRise.offset);
        }

        public void setCaretSlopeRise(int version) {
            this.internalWriteData().writeUShort(Offset.caretSlopeRise.offset, version);
        }

        public int caretSlopeRun() {
            return this.internalReadData().readUShort(Offset.caretSlopeRun.offset);
        }

        public void setCaretSlopeRun(int version) {
            this.internalWriteData().writeUShort(Offset.caretSlopeRun.offset, version);
        }

        public int caretOffset() {
            return this.internalReadData().readUShort(Offset.caretOffset.offset);
        }

        public void setCaretOffset(int version) {
            this.internalWriteData().writeUShort(Offset.caretOffset.offset, version);
        }

        public int metricDataFormat() {
            return this.internalReadData().readUShort(Offset.metricDataFormat.offset);
        }

        public void setMetricDataFormat(int version) {
            this.internalWriteData().writeUShort(Offset.metricDataFormat.offset, version);
        }

        public int numberOfHMetrics() {
            return this.internalReadData().readUShort(Offset.numberOfHMetrics.offset);
        }

        public void setNumberOfHMetrics(int version) {
            this.internalWriteData().writeUShort(Offset.numberOfHMetrics.offset, version);
        }
    }

    private static enum Offset {
        version(0),
        Ascender(4),
        Descender(6),
        LineGap(8),
        advanceWidthMax(10),
        minLeftSideBearing(12),
        minRightSideBearing(14),
        xMaxExtent(16),
        caretSlopeRise(18),
        caretSlopeRun(20),
        caretOffset(22),
        metricDataFormat(32),
        numberOfHMetrics(34);

        private final int offset;

        private Offset(int offset) {
            this.offset = offset;
        }
    }
}

