/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.CompressionMethod;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.RandomCookie;
import cfca.sadk.tls.sun.security.ssl.SessionId;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtensions;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.CipherSuite;
import java.io.IOException;

public final class ServerHello
extends HandshakeMessage {
    private final ProtocolVersion serverVersion;
    private final RandomCookie serverRandom;
    private final SessionId sessionId;
    private final CipherSuite cipherSuite;
    private CompressionMethod compressionMethod = new CompressionMethod(0);
    public HelloExtensions extensions = new HelloExtensions();

    public ServerHello(ProtocolVersion serverVersion, RandomCookie serverRandom, SessionId sessionId, CipherSuite cipherSuite, int compressionMethod) {
        this.serverVersion = serverVersion;
        this.serverRandom = serverRandom;
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.compressionMethod.value = compressionMethod;
    }

    public ServerHello(HandshakeInStream in, int messageLength) throws IOException {
        this.serverVersion = ProtocolVersion.decodedFrom(in);
        this.serverRandom = new RandomCookie(in);
        this.sessionId = new SessionId(in);
        this.cipherSuite = CipherSuite.decodedFrom(in);
        this.compressionMethod = new CompressionMethod(in);
        if (this.messageLength() != messageLength) {
            this.extensions = new HelloExtensions();
            this.extensions.decodedFrom(in);
        }
    }

    public final ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public final RandomCookie getServerRandom() {
        return this.serverRandom;
    }

    public final SessionId getSessionId() {
        return this.sessionId;
    }

    public final CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public final CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    @Override
    public int messageType() {
        return 2;
    }

    @Override
    int messageLength() {
        return 38 + this.sessionId.length() + this.extensions.length();
    }

    @Override
    void send(HandshakeOutStream out) throws IOException {
        out.putOpaque(this.serverVersion);
        out.putOpaque(this.serverRandom);
        out.putOpaque(this.sessionId);
        out.putOpaque(this.cipherSuite);
        out.putOpaque(this.compressionMethod);
        out.putOpaque(this.extensions);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** ServerHello, " + this.serverVersion);
        builder.append("\nRandomCookie:  ");
        builder.append(this.serverRandom);
        builder.append("\nSession ID:  ");
        builder.append(this.sessionId);
        builder.append("\nCipher Suite: " + this.cipherSuite);
        builder.append("\nCompression Method: " + this.compressionMethod);
        builder.append(this.extensions);
        builder.append("\n***");
        return builder.toString();
    }
}

