/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client;

import cfca.sadk.algorithm.common.GMObjectIdentifiers;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.crypto.ExtendedDigest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA256Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA384Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA512Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SM3Digest;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.bc.BcDigestProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TSADigestProviderHelper {
    static final Map<String, BcDigestProvider> LOOKUP_DIGEST_TABLE = TSADigestProviderHelper.createDigestTable();
    static final Map<String, Mechanism> LOOKUP_MECHANISM_TABLE = TSADigestProviderHelper.createMechanismTable();
    static final TSADigestProviderHelper INSTANCE = new TSADigestProviderHelper();

    private TSADigestProviderHelper() {
    }

    private static Map<String, BcDigestProvider> createDigestTable() {
        HashMap<String, Object> table = new HashMap<String, Object>(20);
        BcDigestProvider sha1DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA1Digest();
            }
        };
        table.put(OIWObjectIdentifiers.idSHA1.getId(), sha1DigestProvider);
        table.put(OIWObjectIdentifiers.sha1WithRSA.getId(), sha1DigestProvider);
        table.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), sha1DigestProvider);
        BcDigestProvider sha256DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA256Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha256.getId(), sha256DigestProvider);
        table.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), sha256DigestProvider);
        BcDigestProvider sha384DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA384Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha384.getId(), sha384DigestProvider);
        table.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), sha384DigestProvider);
        BcDigestProvider sha512DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SHA512Digest();
            }
        };
        table.put(NISTObjectIdentifiers.id_sha512.getId(), sha512DigestProvider);
        table.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), sha512DigestProvider);
        BcDigestProvider sm3DigestProvider = new BcDigestProvider(){

            public ExtendedDigest get(AlgorithmIdentifier digestAlgorithmIdentifier) {
                return new SM3Digest();
            }
        };
        table.put(GMObjectIdentifiers.sm3.getId(), sm3DigestProvider);
        table.put(GMObjectIdentifiers.sm3WithSM2Encryption.getId(), sm3DigestProvider);
        return Collections.unmodifiableMap(table);
    }

    private static Map<String, Mechanism> createMechanismTable() {
        HashMap<String, Mechanism> table = new HashMap<String, Mechanism>(10);
        table.put(OIWObjectIdentifiers.sha1WithRSA.getId(), new Mechanism("sha1WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId(), new Mechanism("sha1WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId(), new Mechanism("sha256WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha384WithRSAEncryption.getId(), new Mechanism("sha384WithRSAEncryption"));
        table.put(PKCSObjectIdentifiers.sha512WithRSAEncryption.getId(), new Mechanism("sha512WithRSAEncryption"));
        table.put(GMObjectIdentifiers.sm3WithSM2Encryption.getId(), new Mechanism("sm3WithSM2Encryption"));
        return Collections.unmodifiableMap(table);
    }

    static final ExtendedDigest lookup(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest engine = null;
        if (algorithmIdentifier != null) {
            BcDigestProvider extProv = LOOKUP_DIGEST_TABLE.get(algorithmIdentifier.getAlgorithm().getId());
            if (extProv == null) {
                String oid = algorithmIdentifier != null && algorithmIdentifier.getAlgorithm() != null ? algorithmIdentifier.getAlgorithm().getId() : "missing algorithmIdentifier";
                throw new OperatorCreationException("cannot recognise algorithmIdentifier: " + oid);
            }
            engine = extProv.get(algorithmIdentifier);
        }
        return engine;
    }

    static final Mechanism lookupMechanism(AlgorithmIdentifier signatureAlgorithmIdentifier) throws OperatorCreationException {
        Mechanism mechanism = null;
        if (signatureAlgorithmIdentifier != null) {
            mechanism = LOOKUP_MECHANISM_TABLE.get(signatureAlgorithmIdentifier.getAlgorithm().getId());
        }
        if (mechanism == null) {
            String oid = signatureAlgorithmIdentifier != null && signatureAlgorithmIdentifier.getAlgorithm() != null ? signatureAlgorithmIdentifier.getAlgorithm().getId() : "missing signatureAlgorithmIdentifier";
            throw new OperatorCreationException("cannot recognise signatureAlgorithmIdentifier: " + oid);
        }
        return mechanism;
    }
}

