/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import asposewobfuscated.zz9Y;
import asposewobfuscated.zzT7;
import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IWarningCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.OutlineOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.SwfSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XpsSaveOptions;

public abstract class SaveOptions {
    private boolean zzYuJ;
    private boolean zzYuI = true;
    private boolean zzHP;
    private String zzYuH;
    private boolean zzYuG;
    private boolean zzYuF = false;
    private boolean zzYuE = true;
    private int zzYuD = 0;
    private int zzZIk = 0;
    private IWarningCallback zz8h;
    private int zzHx = 0;

    protected SaveOptions() {
    }

    boolean zzZbr() {
        return this.zzYuJ;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZHt() {
        return false;
    }

    boolean zzZIX() {
        return true;
    }

    boolean zzZbq() {
        return this.zzYuI;
    }

    public String getTempFolder() {
        return this.zzYuH;
    }

    public void setTempFolder(String value) {
        this.zzYuH = value;
    }

    public boolean getPrettyFormat() {
        return this.zzHP;
    }

    public void setPrettyFormat(boolean value) {
        this.zzHP = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzYuG;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzYuG = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzYuF;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzYuF = value;
    }

    public boolean getUpdateSdtContent() {
        return this.zzYuE;
    }

    public void setUpdateSdtContent(boolean value) {
        this.zzYuE = value;
    }

    public int getColorMode() {
        return this.zzHx;
    }

    public void setColorMode(int value) {
        this.zzHx = value;
    }

    public int getDmlRenderingMode() {
        return this.zzYuD;
    }

    public void setDmlRenderingMode(int value) {
        this.zzYuD = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZIk;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZIk = value;
    }

    @Deprecated
    public IWarningCallback getWarningCallback() {
        return this.zz8h;
    }

    @Deprecated
    public void setWarningCallback(IWarningCallback value) {
        this.zz8h = value;
    }

    boolean zzZbp() {
        OutlineOptions outlineOptions = this.getOutlineOptions();
        return outlineOptions != null && outlineOptions.getCreateMissingOutlineLevels();
    }

    private OutlineOptions getOutlineOptions() {
        if (this instanceof PdfSaveOptions) {
            return ((PdfSaveOptions)this).getOutlineOptions();
        }
        if (this instanceof SwfSaveOptions) {
            return ((SwfSaveOptions)this).getOutlineOptions();
        }
        if (this instanceof XpsSaveOptions) {
            return ((XpsSaveOptions)this).getOutlineOptions();
        }
        return null;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 43: {
                return new SwfSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 100: 
            case 101: 
            case 102: 
            case 104: {
                return new ImageSaveOptions(saveFormat);
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzJ4(zzT7.zzl(zz9Y.zzXk(fileName))));
    }
}

