/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.extension;

import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.extension.ExtensionType;
import cfca.sadk.tls.sun.security.ssl.extension.HelloExtension;
import cfca.sadk.tls.sun.security.ssl.sec.ECNamedCurve;
import cfca.sadk.tls.util.DataHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLProtocolException;

public final class SupportedEllipticCurvesExtension
extends HelloExtension {
    static final SupportedEllipticCurvesExtension DEFAULT;
    private final int[] curveIds;
    private static final int ARBITRARY_PRIME = 65281;
    private static final int ARBITRARY_CHAR2 = 65282;
    private static final String[] NAMED_CURVE_OID_TABLE;
    private static final Map<String, Integer> curveIndices;

    private SupportedEllipticCurvesExtension(int[] curveIds) {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        this.curveIds = curveIds;
    }

    SupportedEllipticCurvesExtension(HandshakeInStream s, int len) throws IOException {
        super(ExtensionType.EXT_ELLIPTIC_CURVES);
        int k = s.getInt16();
        if ((len & 1) != 0 || k + 2 != len) {
            throw new SSLProtocolException("Invalid " + (Object)((Object)this.type) + " extension");
        }
        this.curveIds = new int[k >> 1];
        for (int i = 0; i < this.curveIds.length; ++i) {
            this.curveIds[i] = s.getInt16();
        }
    }

    boolean contains(int index) {
        for (int curveId : this.curveIds) {
            if (index != curveId) continue;
            return true;
        }
        return false;
    }

    public int[] curveIds() {
        return this.curveIds;
    }

    @Override
    final int length() {
        return 6 + (this.curveIds == null ? 0 : this.curveIds.length << 1);
    }

    @Override
    final byte[] getEncoded() throws IOException {
        byte[] encoded = new byte[this.length()];
        int dataLength = encoded.length - 6;
        DataHelper.write((short)this.type.id, encoded, 0);
        DataHelper.write((short)(dataLength + 2), encoded, 2);
        DataHelper.write((short)dataLength, encoded, 4);
        int offset = 6;
        for (int curveId : this.curveIds) {
            DataHelper.write((short)curveId, encoded, offset);
            offset += 2;
        }
        return encoded;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Extension ").append((Object)this.type);
        builder.append(", curve_names: {");
        boolean first = true;
        for (int curveId : this.curveIds) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            String oid = SupportedEllipticCurvesExtension.getCurveOid(curveId);
            if (oid != null) {
                ECParameterSpec spec = ECNamedCurve.getECParameterSpec(oid);
                if (spec != null) {
                    builder.append(spec.toString().split(" ")[0]);
                    continue;
                }
                builder.append(oid);
                continue;
            }
            if (curveId == 65281) {
                builder.append("arbitrary_explicit_prime_curves");
                continue;
            }
            if (curveId == 65282) {
                builder.append("arbitrary_explicit_char2_curves");
                continue;
            }
            builder.append("unknown curve " + curveId);
        }
        builder.append('}');
        return builder.toString();
    }

    public static boolean isSupported(int index) {
        if (index <= 0 || index >= NAMED_CURVE_OID_TABLE.length) {
            return false;
        }
        return DEFAULT.contains(index);
    }

    public static int getCurveIndex(ECParameterSpec params) {
        String oid = ECNamedCurve.getNamedCurveOid(params);
        if (oid == null) {
            return -1;
        }
        Integer n = curveIndices.get(oid);
        return n == null ? -1 : n;
    }

    public static String getCurveOid(int index) {
        if (index > 0 && index < NAMED_CURVE_OID_TABLE.length) {
            return NAMED_CURVE_OID_TABLE[index];
        }
        return null;
    }

    public static int firstCurveId() {
        return DEFAULT.curveIds()[0];
    }

    static {
        int[] ids = new int[]{23, 1, 3, 19, 21, 6, 7, 9, 10, 24, 11, 12, 25, 13, 14, 15, 16, 17, 2, 18, 4, 5, 20, 8, 22};
        DEFAULT = new SupportedEllipticCurvesExtension(ids);
        NAMED_CURVE_OID_TABLE = new String[]{null, "1.3.132.0.1", "1.3.132.0.2", "1.3.132.0.15", "1.3.132.0.24", "1.3.132.0.25", "1.3.132.0.26", "1.3.132.0.27", "1.3.132.0.3", "1.3.132.0.16", "1.3.132.0.17", "1.3.132.0.36", "1.3.132.0.37", "1.3.132.0.38", "1.3.132.0.39", "1.3.132.0.9", "1.3.132.0.8", "1.3.132.0.30", "1.3.132.0.31", "1.2.840.10045.3.1.1", "1.3.132.0.32", "1.3.132.0.33", "1.3.132.0.10", "1.2.840.10045.3.1.7", "1.3.132.0.34", "1.3.132.0.35"};
        curveIndices = new HashMap<String, Integer>();
        for (int i = 1; i < NAMED_CURVE_OID_TABLE.length; ++i) {
            curveIndices.put(NAMED_CURVE_OID_TABLE[i], i);
        }
    }
}

