/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.styledxmlparser.css;

import cfca.sadk.com.itextpdf.io.util.MessageFormatUtil;
import cfca.sadk.com.itextpdf.styledxmlparser.CssRuleSetComparator;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssDeclaration;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssRuleSet;
import cfca.sadk.com.itextpdf.styledxmlparser.css.CssStatement;
import cfca.sadk.com.itextpdf.styledxmlparser.css.ICssResolver;
import cfca.sadk.com.itextpdf.styledxmlparser.css.media.MediaDeviceDescription;
import cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.IShorthandResolver;
import cfca.sadk.com.itextpdf.styledxmlparser.css.resolve.shorthand.ShorthandResolverFactory;
import cfca.sadk.com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import cfca.sadk.com.itextpdf.styledxmlparser.node.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CssStyleSheet {
    private List<CssStatement> statements = new ArrayList<CssStatement>();

    public void addStatement(CssStatement statement) {
        this.statements.add(statement);
    }

    public void appendCssStyleSheet(CssStyleSheet anotherCssStyleSheet) {
        this.statements.addAll(anotherCssStyleSheet.statements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CssStatement statement : this.statements) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(statement.toString());
        }
        return sb.toString();
    }

    public List<CssStatement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public List<CssDeclaration> getCssDeclarations(INode node, MediaDeviceDescription deviceDescription) {
        List<CssRuleSet> ruleSets = this.getCssRuleSets(node, deviceDescription);
        LinkedHashMap<String, CssDeclaration> declarations = new LinkedHashMap<String, CssDeclaration>();
        for (CssRuleSet ruleSet : ruleSets) {
            CssStyleSheet.populateDeclarationsMap(ruleSet.getNormalDeclarations(), declarations);
        }
        for (CssRuleSet ruleSet : ruleSets) {
            CssStyleSheet.populateDeclarationsMap(ruleSet.getImportantDeclarations(), declarations);
        }
        return new ArrayList<CssDeclaration>(declarations.values());
    }

    public static Map<String, String> extractStylesFromRuleSets(List<CssRuleSet> ruleSets) {
        LinkedHashMap<String, CssDeclaration> declarations = new LinkedHashMap<String, CssDeclaration>();
        for (CssRuleSet ruleSet : ruleSets) {
            CssStyleSheet.populateDeclarationsMap(ruleSet.getNormalDeclarations(), declarations);
        }
        for (CssRuleSet ruleSet : ruleSets) {
            CssStyleSheet.populateDeclarationsMap(ruleSet.getImportantDeclarations(), declarations);
        }
        LinkedHashMap<String, String> stringMap = new LinkedHashMap<String, String>();
        for (Map.Entry entry : declarations.entrySet()) {
            stringMap.put((String)entry.getKey(), ((CssDeclaration)entry.getValue()).getExpression());
        }
        return stringMap;
    }

    private static void populateDeclarationsMap(List<CssDeclaration> declarations, Map<String, CssDeclaration> map) {
        for (CssDeclaration declaration : declarations) {
            IShorthandResolver shorthandResolver = ShorthandResolverFactory.getShorthandResolver(declaration.getProperty());
            if (shorthandResolver == null) {
                CssStyleSheet.putDeclarationInMapIfValid(map, declaration);
                continue;
            }
            List<CssDeclaration> resolvedShorthandProps = shorthandResolver.resolveShorthand(declaration.getExpression());
            for (CssDeclaration resolvedProp : resolvedShorthandProps) {
                CssStyleSheet.putDeclarationInMapIfValid(map, resolvedProp);
            }
        }
    }

    public List<CssRuleSet> getCssRuleSets(INode node, MediaDeviceDescription deviceDescription) {
        ArrayList<CssRuleSet> ruleSets = new ArrayList<CssRuleSet>();
        for (CssStatement statement : this.statements) {
            ruleSets.addAll(statement.getCssRuleSets(node, deviceDescription));
        }
        Collections.sort(ruleSets, new CssRuleSetComparator());
        return ruleSets;
    }

    private static void putDeclarationInMapIfValid(Map<String, CssDeclaration> stylesMap, CssDeclaration cssDeclaration) {
        if (CssDeclarationValidationMaster.checkDeclaration(cssDeclaration)) {
            stylesMap.put(cssDeclaration.getProperty(), cssDeclaration);
        } else {
            Logger logger = LoggerFactory.getLogger(ICssResolver.class);
            logger.warn(MessageFormatUtil.format("Invalid css property declaration: {0}", cssDeclaration));
        }
    }
}

