/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.sadk.ofd.base.exception.SealException;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class SVGUtil {
    public static float[] getSVGPixel(byte[] svgData) throws Exception {
        float[] widthAndHeight = new float[2];
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder bulider = dbf.newDocumentBuilder();
        Document doc = bulider.parse(new ByteArrayInputStream(svgData));
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        NodeList nodes = (NodeList)xpath.evaluate(".//*[name()='svg']", doc, XPathConstants.NODESET);
        NamedNodeMap svgAttr = nodes.item(0).getAttributes();
        String width = svgAttr.getNamedItem("width").getNodeValue();
        String height = svgAttr.getNamedItem("height").getNodeValue();
        if (width.contains("px") && height.contains("px")) {
            widthAndHeight[0] = Float.valueOf(width.replace("px", "")).floatValue();
            widthAndHeight[1] = Float.valueOf(height.replace("px", "")).floatValue();
        } else if (width.contains("%") && height.contains("%")) {
            String viewbox = svgAttr.getNamedItem("viewBox").getNodeValue();
            String[] datas = viewbox.split(",");
            if (0.0f != Float.valueOf(datas[0]).floatValue() && 0.0f != Float.valueOf(datas[1]).floatValue()) {
                throw new SealException("viewBox must start with (0,0)");
            }
            widthAndHeight[0] = Float.valueOf(datas[2]).floatValue();
            widthAndHeight[1] = Float.valueOf(datas[3]).floatValue();
        } else {
            widthAndHeight[0] = Float.valueOf(width).floatValue();
            widthAndHeight[1] = Float.valueOf(height).floatValue();
        }
        return widthAndHeight;
    }
}

