/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.google.typography.font.tools.subsetter;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.data.FontData;
import cfca.com.google.typography.font.sfntly.table.core.CMap;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat12;
import cfca.com.google.typography.font.sfntly.table.core.CMapFormat4;
import cfca.com.google.typography.font.sfntly.table.core.CMapTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CMapTableBuilder {
    private static final int MAX_FORMAT4_ENDCODE = 65535;
    private final Font.Builder fontBuilder;
    private final Map<Integer, Integer> mapping;

    public CMapTableBuilder(Font.Builder fontBuilder, Map<Integer, Integer> mapping) {
        this.fontBuilder = fontBuilder;
        this.mapping = mapping;
    }

    private List<CMap4Segment> getFormat4Segments() {
        Map.Entry entry;
        int unicode;
        ArrayList<CMap4Segment> result = new ArrayList<CMap4Segment>();
        TreeMap<Integer, Integer> sortedMap = new TreeMap<Integer, Integer>(this.mapping);
        if (!sortedMap.containsKey(65535)) {
            sortedMap.put(65535, 0);
        }
        CMap4Segment curSegment = null;
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext() && (unicode = ((Integer)(entry = iterator.next()).getKey()).intValue()) <= 65535) {
            int glyphId = (Integer)entry.getValue();
            if (curSegment == null || unicode != curSegment.getEndCode() + 1) {
                curSegment = new CMap4Segment(unicode, unicode);
                result.add(curSegment);
            } else {
                curSegment.setEndCode(unicode);
            }
            curSegment.getGlyphIds().add(glyphId);
        }
        return result;
    }

    private void buildCMapFormat4(CMapFormat4.Builder builder, List<CMap4Segment> segments) {
        ArrayList<CMapFormat4.Builder.Segment> segmentList = new ArrayList<CMapFormat4.Builder.Segment>();
        ArrayList<Integer> glyphIdArray = new ArrayList<Integer>();
        int idOffset = segments.size();
        for (int i = 0; i < segments.size(); ++i) {
            int idRangeOffset;
            CMap4Segment segment = segments.get(i);
            if (segment.isContiguous()) {
                idRangeOffset = 0;
            } else {
                idRangeOffset = (idOffset - i) * FontData.DataSize.USHORT.size();
                glyphIdArray.addAll(segment.getGlyphIds());
                idOffset += segment.getGlyphIds().size();
            }
            segmentList.add(new CMapFormat4.Builder.Segment(segment.getStartCode(), segment.getEndCode(), segment.idDelta(), idRangeOffset));
        }
        builder.setGlyphIdArray(glyphIdArray);
        builder.setSegments(segmentList);
    }

    private List<CMap12Group> getFormat12Groups() {
        ArrayList<CMap12Group> result = new ArrayList<CMap12Group>();
        TreeMap<Integer, Integer> sortedMap = new TreeMap<Integer, Integer>(this.mapping);
        CMap12Group curGroup = null;
        for (Map.Entry entry : sortedMap.entrySet()) {
            int unicode = (Integer)entry.getKey();
            int glyphId = (Integer)entry.getValue();
            if (curGroup == null || unicode != curGroup.getGroupEndCode() + 1 || glyphId != curGroup.getGlyphIds().get(curGroup.getGlyphIds().size() - 1) + 1) {
                curGroup = new CMap12Group(unicode, unicode);
                result.add(curGroup);
            } else {
                curGroup.setGroupEndCode(unicode);
            }
            curGroup.getGlyphIds().add(glyphId);
        }
        return result;
    }

    private void buildCMapFormat12(CMapFormat12.Builder builder, List<CMap12Group> groups) {
        ArrayList<CMapFormat12.Builder.Group> groupList = new ArrayList<CMapFormat12.Builder.Group>();
        for (int i = 0; i < groups.size(); ++i) {
            CMap12Group group = groups.get(i);
            groupList.add(new CMapFormat12.Builder.Group(group.getGroupStartCode(), group.getGroupEndCode(), group.getGroupStartGlyph()));
        }
        builder.setGroups(groupList);
    }

    private boolean isContainUCS4() {
        boolean hasUCS4 = false;
        TreeMap<Integer, Integer> sortedMap = new TreeMap<Integer, Integer>(this.mapping);
        for (Map.Entry entry : sortedMap.entrySet()) {
            int unicode = (Integer)entry.getKey();
            if (unicode <= 65535) continue;
            hasUCS4 = true;
        }
        return hasUCS4;
    }

    public void build() {
        CMapTable.Builder cmapTableBuilder = (CMapTable.Builder)this.fontBuilder.newTableBuilder(Tag.cmap);
        if (this.isContainUCS4()) {
            CMapFormat12.Builder cmap12Builder = (CMapFormat12.Builder)cmapTableBuilder.newCMapBuilder(CMapTable.CMapId.WINDOWS_UCS4, CMap.CMapFormat.Format12);
            this.buildCMapFormat12(cmap12Builder, this.getFormat12Groups());
        } else {
            CMapFormat4.Builder cmap4Builder = (CMapFormat4.Builder)cmapTableBuilder.newCMapBuilder(CMapTable.CMapId.WINDOWS_BMP, CMap.CMapFormat.Format4);
            this.buildCMapFormat4(cmap4Builder, this.getFormat4Segments());
        }
    }

    private class CMap12Group {
        private final int groupStartCode;
        private int groupEndCode;
        List<Integer> glyphIds;

        CMap12Group(int groupStartCode, int groupEndCode) {
            this.groupStartCode = groupStartCode;
            this.groupEndCode = groupEndCode;
            this.glyphIds = new ArrayList<Integer>();
        }

        public int getGroupStartCode() {
            return this.groupStartCode;
        }

        public void setGroupEndCode(int groupEndCode) {
            this.groupEndCode = groupEndCode;
        }

        public int getGroupEndCode() {
            return this.groupEndCode;
        }

        public int getGroupStartGlyph() {
            return this.glyphIds.get(0);
        }

        public List<Integer> getGlyphIds() {
            return this.glyphIds;
        }
    }

    private class CMap4Segment {
        private final int startCode;
        private int endCode;
        List<Integer> glyphIds;

        CMap4Segment(int startCode, int endCode) {
            this.startCode = startCode;
            this.endCode = endCode;
            this.glyphIds = new ArrayList<Integer>();
        }

        private boolean isContiguous() {
            int firstId = this.glyphIds.get(0);
            for (int index = 1; index < this.glyphIds.size(); ++index) {
                if (this.glyphIds.get(index) == firstId + index) continue;
                return false;
            }
            return true;
        }

        int idDelta() {
            return this.isContiguous() ? this.getGlyphIds().get(0) - this.getStartCode() : 0;
        }

        public int getStartCode() {
            return this.startCode;
        }

        public void setEndCode(int endCode) {
            this.endCode = endCode;
        }

        public int getEndCode() {
            return this.endCode;
        }

        public List<Integer> getGlyphIds() {
            return this.glyphIds;
        }
    }
}

