/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.exception.CodeException;
import cfca.paperless.base.util.FileUtil;
import cfca.paperless.base.util.GUIDUtil;
import cfca.pdf.jni.Document;
import cfca.sadk.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdf2ImageUtil {
    private static final Logger sysLog = LoggerFactory.getLogger(Pdf2ImageUtil.class);

    public static String pdf2Image(byte[] pdf, int pageNum, int pageCount, String outputFolder) throws CodeException {
        String pdfPath = outputFolder + "data" + GUIDUtil.generateId() + ".pdf";
        sysLog.info("prepare pdfPath: " + pdfPath);
        Document doc = null;
        try {
            FileUtil.saveDataToFile(pdf, pdfPath);
            sysLog.info("saveDataToFile finish. pdfPath: " + pdfPath);
            doc = new Document();
            doc.setRotation(0);
            doc.setResolution(0);
            doc.setMaxWidth(0);
            doc.setMaxHeight(0);
            doc.setMaintainAspectRatio(true);
            doc.openDocument(pdfPath);
            sysLog.info("PDFJniKit Document.openDocument finish.");
            int count = doc.getPageCount();
            if (count != pageCount) {
                throw new CodeException("600605", "pageCount parse failed. PdfReader.pageCount=" + pageCount + " PDFJniKit.pageCount=" + count);
            }
            String imageBase64 = "";
            if (pageNum == -1 || pageNum == 0) {
                for (int i = 1; i <= count; ++i) {
                    byte[] pngData = doc.renderPage(i);
                    imageBase64 = imageBase64 + Base64.toBase64String((byte[])pngData);
                    if (i >= 1 && i < pageCount) {
                        imageBase64 = imageBase64 + ":";
                    }
                    sysLog.info("PDFJniKit Document.renderPage finish. pageNo=" + i + ". pngData.length=" + pngData + ". imageBase64.length=" + imageBase64.length());
                }
            } else {
                byte[] pngData = doc.renderPage(pageNum);
                imageBase64 = Base64.toBase64String((byte[])pngData);
                sysLog.info("PDFJniKit Document.renderPage finish. pageNo=" + pageNum + ". pngData.length=" + pngData + ". imageBase64.length=" + imageBase64.length());
            }
            String string = imageBase64;
            return string;
        }
        catch (CodeException e) {
            sysLog.error("PDFJniKit pdf2Image CodeException.", (Throwable)e);
            throw new CodeException("630041", e.getMessage());
        }
        catch (Exception e) {
            sysLog.error("PDFJniKit pdf2Image Exception.", (Throwable)e);
            throw new CodeException("630041", e.getMessage());
        }
        catch (Error e) {
            sysLog.error("PDFJniKit pdf2Image Error.", (Throwable)e);
            throw new CodeException("630041", e.getMessage());
        }
        finally {
            if (doc != null) {
                try {
                    doc.closeDocument();
                }
                catch (Exception e) {
                    sysLog.error("PDFJniKit Document.closeDocument fail.", (Throwable)e);
                }
            }
            try {
                FileUtil.deleteSingleFile(pdfPath);
            }
            catch (Exception e) {
                sysLog.error("File delete fail. pdfPath: " + pdfPath, (Throwable)e);
            }
        }
    }
}

