/*
 * Decompiled with CFR 0.152.
 */
package cfca.org.slf4j.helpers;

import cfca.logback.util.SystemUtil;

public final class Util {
    private static ClassContextSecurityManager SECURITY_MANAGER;
    private static boolean SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED;

    private Util() {
    }

    public static String safeGetSystemProperty(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null input");
        }
        String result = null;
        try {
            result = System.getProperty(key);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return result;
    }

    public static boolean safeGetBooleanSystemProperty(String key) {
        String value = Util.safeGetSystemProperty(key);
        boolean safeFlag = false;
        safeFlag = value == null ? false : value.equalsIgnoreCase("true");
        return safeFlag;
    }

    private static ClassContextSecurityManager getSecurityManager() {
        ClassContextSecurityManager manager = null;
        if (SECURITY_MANAGER != null) {
            manager = SECURITY_MANAGER;
        } else if (SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED) {
            manager = null;
        } else {
            SECURITY_MANAGER = Util.safeCreateSecurityManager();
            SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = true;
            manager = SECURITY_MANAGER;
        }
        return manager;
    }

    private static ClassContextSecurityManager safeCreateSecurityManager() {
        try {
            return new ClassContextSecurityManager();
        }
        catch (SecurityException sm) {
            return null;
        }
    }

    public static Class<?> getCallingClass() {
        ClassContextSecurityManager securityManager = Util.getSecurityManager();
        Class<?> clazz = null;
        if (securityManager != null) {
            int i;
            Class<?>[] trace = securityManager.getClassContext();
            String thisClassName = Util.class.getName();
            for (i = 0; i < trace.length && !thisClassName.equals(trace[i].getName()); ++i) {
            }
            if (i >= trace.length || i + 2 >= trace.length) {
                throw new IllegalStateException("Failed to find cfca.org.slf4j.helpers.Util or its caller in the stack; this should not happen");
            }
            clazz = trace[i + 2];
        }
        return clazz;
    }

    public static final void report(String msg, Throwable t) {
        SystemUtil.ERR.println(msg);
        SystemUtil.ERR.println("Reported exception:");
        SystemUtil.printStackTrace(t);
    }

    public static final void report(String msg) {
        SystemUtil.ERR.println("SLF4J: " + msg);
    }

    static {
        SECURITY_MANAGER_CREATION_ALREADY_ATTEMPTED = false;
    }

    private static final class ClassContextSecurityManager
    extends SecurityManager {
        private ClassContextSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

