/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.system.Mechanisms;

public class MechanismUtil {
    private static final Mechanism M_SHA384_RSA = new Mechanism("sha384WithRSAEncryption");
    private static final String SHA1 = "SHA1";
    private static final String SHA256 = "SHA256";
    private static final String SHA384 = "SHA384";
    private static final String SHA512 = "SHA512";

    public static Mechanism getMechanism(DERPrintableString hashOID) {
        Mechanism digestAlg = null;
        digestAlg = hashOID.toString().equals(PKCSObjectIdentifiers.sm3.getId()) ? Mechanisms.M_SM3_SM2 : new Mechanism(Mechanisms.getDigestAlgorithmName((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(hashOID.getString())));
        return digestAlg;
    }

    public static String getDigestId(Mechanism signAlg) {
        String oid = null;
        oid = signAlg.equals((Object)Mechanisms.M_SM3_SM2) ? PKCSObjectIdentifiers.sm3.getId() : Mechanisms.getDigestAlgIdentifier((Mechanism)signAlg).getAlgorithm().getId();
        return oid;
    }

    public static String getSignAlgId(Mechanism signAlg) {
        String oid = null;
        oid = signAlg.equals((Object)Mechanisms.M_SM3_SM2) ? PKCSObjectIdentifiers.sm2Encryption.getId() : Mechanism.getAlgorithmIdentifier((String)signAlg.getMechanismType()).getAlgorithm().getId();
        return oid;
    }

    public static Mechanism getSignMechanism(ASN1ObjectIdentifier signAlg) {
        Mechanism mechanism = null;
        mechanism = signAlg.equals((Object)PKCSObjectIdentifiers.sm2Encryption) ? Mechanisms.M_SM3_SM2 : new Mechanism(Mechanisms.getDigestAlgorithmName((ASN1ObjectIdentifier)signAlg));
        return mechanism;
    }

    public static Mechanism getMechanism(String digestOID) {
        Mechanism digestAlg = null;
        if (digestOID.contains(".")) {
            digestAlg = digestOID.equals(PKCSObjectIdentifiers.sm3.getId()) ? Mechanisms.M_SM3_SM2 : new Mechanism(Mechanisms.getDigestAlgorithmName((ASN1ObjectIdentifier)new ASN1ObjectIdentifier(digestOID)));
        } else {
            boolean isSM2;
            String signAlg = digestOID.replaceAll("-", "").replaceAll(" ", "").toUpperCase();
            boolean bl = isSM2 = "SM3WITHSM2ENCRYPTION".equals(signAlg) || "SM3WITHSM2".equals(signAlg) || "SM2WITHSM3ENCRYPTION".equals(signAlg) || "SM2WITHSM3".equals(signAlg) || "SM2".equals(signAlg) || "SM3".equals(signAlg);
            if (isSM2) {
                digestAlg = Mechanisms.M_SM3_SM2;
            } else if (signAlg.equals(SHA1)) {
                digestAlg = Mechanisms.M_SHA1_RSA;
            } else if (signAlg.equals(SHA256)) {
                digestAlg = Mechanisms.M_SHA256_RSA;
            } else if (signAlg.equals(SHA384)) {
                digestAlg = M_SHA384_RSA;
            } else if (signAlg.equals(SHA512)) {
                digestAlg = Mechanisms.M_SHA512_RSA;
            } else if (signAlg.equals("MD5")) {
                digestAlg = Mechanisms.M_MD5_RSA;
            } else {
                throw new IllegalArgumentException(digestOID + "is not supported!");
            }
        }
        return digestAlg;
    }
}

