/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.servlet;

import cfca.ch.qos.logback.access.servlet.TeeServletInputStream;
import cfca.ch.qos.logback.access.servlet.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class TeeHttpServletRequest
extends HttpServletRequestWrapper {
    private TeeServletInputStream inStream;
    private BufferedReader reader;
    boolean postedParametersMode = false;

    TeeHttpServletRequest(HttpServletRequest request) {
        super(request);
        if (Util.isFormUrlEncoded(request)) {
            this.postedParametersMode = true;
        } else {
            this.inStream = new TeeServletInputStream(request);
            request.setAttribute("LB_INPUT_BUFFER", (Object)this.inStream.getInputBuffer());
            this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.inStream)));
        }
    }

    byte[] getInputBuffer() {
        if (this.postedParametersMode) {
            throw new IllegalStateException("Call disallowed in postedParametersMode");
        }
        return this.inStream.getInputBuffer();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (!this.postedParametersMode) {
            return this.inStream;
        }
        return super.getInputStream();
    }

    public BufferedReader getReader() throws IOException {
        if (!this.postedParametersMode) {
            return this.reader;
        }
        return super.getReader();
    }

    public boolean isPostedParametersMode() {
        return this.postedParametersMode;
    }
}

