/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm;

import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.gmt.GMTObjectIdentifiers;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTBigIntegerUtil;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import java.math.BigInteger;

public class GMTPublicKey
implements ECPublicKey,
GMTKey {
    private final ECParameterSpec sm2ParameterSpec = SM2Params.sm2ParameterSpec;
    private static final long serialVersionUID = -4714957801525215906L;
    private byte[] bPubX = null;
    private byte[] bPubY = null;
    private BigInteger iPubX = null;
    private BigInteger iPubY = null;
    private boolean withCompression = false;
    private final ECPoint Q;
    private final byte[] zvalue;

    public GMTPublicKey(byte[] encoded) {
        if (encoded == null || encoded.length < 64) {
            throw new IllegalArgumentException("null not allowed for encoded");
        }
        byte[] coding = null;
        if (encoded.length == 64 || encoded.length == 65) {
            coding = (byte[])encoded.clone();
        } else {
            try {
                AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMTObjectIdentifiers.sm2);
                SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance(encoded);
                if (!aid.equals(info.getAlgorithm())) {
                    throw new SecurityException("encoded not valid");
                }
                coding = info.getPublicKeyData().getBytes();
                if (coding.length != 65) {
                    throw new SecurityException("encoded not valid");
                }
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("encoded not valid", e);
            }
        }
        int offset = encoded.length == 64 ? 0 : 1;
        this.bPubX = new byte[32];
        this.bPubY = new byte[32];
        System.arraycopy(coding, offset, this.bPubX, 0, this.bPubX.length);
        System.arraycopy(coding, offset += this.bPubY.length, this.bPubY, 0, this.bPubY.length);
        this.iPubX = new BigInteger(1, this.bPubX);
        this.iPubY = new BigInteger(1, this.bPubY);
        this.Q = this.sm2ParameterSpec.getCurve().createPoint(this.iPubX, this.iPubY).normalize();
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    public GMTPublicKey(byte[] bPubX, byte[] bPubY) {
        if (bPubX == null) {
            throw new IllegalArgumentException("null not allowed for bPubX");
        }
        if (bPubY == null) {
            throw new IllegalArgumentException("null not allowed for bPubY");
        }
        this.Q = this.createPoint(null, new BigInteger(1, bPubX), new BigInteger(1, bPubY));
        this.zvalue = SM2Params.calcZ(bPubX, bPubY);
    }

    public GMTPublicKey(BigInteger iPubX, BigInteger iPubY) {
        this.Q = this.createPoint(null, iPubX, iPubY);
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    public GMTPublicKey(ECPublicKeyParameters ecParams) {
        if (ecParams == null) {
            throw new IllegalArgumentException("null not allowed for ecParams");
        }
        if (!SM2Params.sm2DomainParameters.equals(ecParams.getParameters())) {
            throw new IllegalArgumentException("domainParameters not allowed for ecParams");
        }
        this.Q = this.createPoint(ecParams.getQ(), null, null);
        this.zvalue = SM2Params.calcZ(this.bPubX, this.bPubY);
    }

    private final ECPoint createPoint(ECPoint point, BigInteger iPubX, BigInteger iPubY) {
        ECPoint Q = null;
        if (point != null) {
            Q = point.normalize();
            this.iPubX = Q.getXCoord().toBigInteger();
            this.iPubY = Q.getYCoord().toBigInteger();
        } else {
            if (iPubX == null) {
                throw new IllegalArgumentException("null not allowed for iPubX");
            }
            if (iPubY == null) {
                throw new IllegalArgumentException("null not allowed for iPubY");
            }
            this.iPubX = iPubX;
            this.iPubY = iPubY;
            Q = this.sm2ParameterSpec.getCurve().createPoint(iPubX, iPubY);
        }
        this.bPubX = GMTBigIntegerUtil.asUnsigned32ByteArray(this.iPubX);
        this.bPubY = GMTBigIntegerUtil.asUnsigned32ByteArray(this.iPubY);
        return Q;
    }

    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMTObjectIdentifiers.sm2);
            byte[] encoded = new byte[65];
            encoded[0] = 4;
            System.arraycopy(this.bPubX, 0, encoded, 1, 32);
            System.arraycopy(this.bPubY, 0, encoded, 33, 32);
            SubjectPublicKeyInfo info = new SubjectPublicKeyInfo(algorithm, encoded);
            return info.getEncoded("DER");
        }
        catch (Exception e) {
            throw new RuntimeException("Encoded Failure for SM2PublicKey", e);
        }
    }

    public ECPoint getQ() {
        return this.Q;
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public byte[] getPubX() {
        return (byte[])this.bPubX.clone();
    }

    public BigInteger getPubX_Int() {
        return this.iPubX;
    }

    public byte[] getPubXByBytes() {
        return (byte[])this.bPubX.clone();
    }

    public BigInteger getPubXByInt() {
        return this.iPubX;
    }

    public byte[] getPubY() {
        return (byte[])this.bPubY.clone();
    }

    public BigInteger getPubY_Int() {
        return this.iPubY;
    }

    public byte[] getPubYByBytes() {
        return (byte[])this.bPubY.clone();
    }

    public BigInteger getPubYByInt() {
        return this.iPubY;
    }

    public byte[] getZvalue() {
        return (byte[])this.zvalue.clone();
    }

    public boolean isWithCompression() {
        return this.withCompression;
    }

    public String getAlgorithm() {
        return "SM2";
    }

    public String getFormat() {
        return "X.509";
    }

    public ECParameterSpec getParams() {
        return this.sm2ParameterSpec;
    }

    public ECParameterSpec getParameters() {
        return this.sm2ParameterSpec;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.iPubX == null ? 0 : this.iPubX.hashCode());
        result = 31 * result + (this.iPubY == null ? 0 : this.iPubY.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GMTPublicKey other = (GMTPublicKey)obj;
        if (this.iPubX == null ? other.iPubX != null : !this.iPubX.equals(other.iPubX)) {
            return false;
        }
        return !(this.iPubY == null ? other.iPubY != null : !this.iPubY.equals(other.iPubY));
    }

    public String toString() {
        String separator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("SM2 Public Key: ");
        buffer.append(separator);
        buffer.append("X:");
        if (this.iPubX != null) {
            buffer.append(this.iPubX.toString(16));
        }
        buffer.append(separator);
        buffer.append("Y:");
        if (this.iPubY != null) {
            buffer.append(this.iPubY.toString(16));
        }
        return buffer.toString();
    }

    public final byte[] getDefaultZ() {
        return (byte[])this.zvalue.clone();
    }

    public final byte[] calcZ(byte[] userId) {
        return SM2Params.calcZ(this.bPubX, this.bPubY, userId);
    }

    public byte[] xBytes() {
        return (byte[])this.bPubX.clone();
    }

    public byte[] yBytes() {
        return (byte[])this.bPubY.clone();
    }
}

