/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.client.tx.transaction;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.paperless.base.util.ProofHashUtil;
import cfca.paperless.base.util.StringUtil;
import cfca.paperless.base.util.validity.ValidityUtil;
import cfca.paperless.client.connector.HttpConnector;
import cfca.paperless.client.tx.transaction.AbstractTransaction;
import cfca.paperless.client.util.CommonUtil;
import cfca.paperless.client.util.JsonUtil;
import cfca.paperless.client.util.ValidateUtil;
import cfca.paperless.dto.RequestDto;
import cfca.paperless.dto.ResponseDto;
import cfca.paperless.dto.ResponseHead;
import cfca.paperless.dto.bean.Organization;
import cfca.paperless.dto.request.requestbody.tx10.AddCrossToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.AddOrganizationRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.AddWaterMarkToPdfRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.ConcatPdfListRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.DownloadTemplateRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeBusinessDataRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.SynthesizeMultiDataRequestBody;
import cfca.paperless.dto.request.requestbody.tx10.UploadTemplateRequestBody;
import cfca.paperless.dto.request.tx10.AddCrossToPdfRequest;
import cfca.paperless.dto.request.tx10.AddOrganizationRequest;
import cfca.paperless.dto.request.tx10.AddWaterMarkToPdfRequest;
import cfca.paperless.dto.request.tx10.ConcatPdfListRequest;
import cfca.paperless.dto.request.tx10.DeleteOrganizationRequest;
import cfca.paperless.dto.request.tx10.DownloadTemplateRequest;
import cfca.paperless.dto.request.tx10.SynthesizeBusinessDataRequest;
import cfca.paperless.dto.request.tx10.SynthesizeMultiDataRequest;
import cfca.paperless.dto.request.tx10.UpdateOrganizationRequest;
import cfca.paperless.dto.request.tx10.UploadTemplateRequest;
import cfca.paperless.dto.response.responsebody.tx10.AddCrossToPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx10.AddWaterMarkToPdfResponseBody;
import cfca.paperless.dto.response.responsebody.tx10.ConcatPdfListResponseBody;
import cfca.paperless.dto.response.responsebody.tx10.DownloadTemplateResponseBody;
import cfca.paperless.dto.response.responsebody.tx10.SynthesizeBusinessDataResponseBody;
import cfca.paperless.dto.response.responsebody.tx10.SynthesizeMultiDataResponseBody;
import cfca.paperless.dto.response.tx10.AddCrossToPdfResponse;
import cfca.paperless.dto.response.tx10.AddOrganizationResponse;
import cfca.paperless.dto.response.tx10.AddWaterMarkToPdfResponse;
import cfca.paperless.dto.response.tx10.ConcatPdfListResponse;
import cfca.paperless.dto.response.tx10.DeleteOrganizationResponse;
import cfca.paperless.dto.response.tx10.DownloadTemplateResponse;
import cfca.paperless.dto.response.tx10.SynthesizeBusinessDataResponse;
import cfca.paperless.dto.response.tx10.SynthesizeMultiDataResponse;
import cfca.paperless.dto.response.tx10.UpdateOrganizationResponse;
import java.util.ArrayList;
import java.util.List;

public class Tx10Transaction
extends AbstractTransaction {
    public static final Logger logger = LoggerFactory.getLogger(Tx10Transaction.class);

    public ResponseDto doTx1001(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1001 start.");
        UploadTemplateRequest requestBean = (UploadTemplateRequest)requestDto;
        UploadTemplateRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1001(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1001 doCheckTx1001 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1001 handleRequest finish.");
        ResponseDto responseBean = this.parseTx1001Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1001 parseTx1001Result finish.");
        logger.info("Tx10Transaction.doTx1001 end.");
        return responseBean;
    }

    public DownloadTemplateResponse doTx1002(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1002 start.");
        DownloadTemplateRequest requestBean = (DownloadTemplateRequest)requestDto;
        DownloadTemplateRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1002(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1002 doCheckTx1002 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1002 handleRequest finish.");
        DownloadTemplateResponse responseBean = this.parseTx1002Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1002 parseTx1002Result finish.");
        logger.info("Tx10Transaction.doTx1002 end.");
        return responseBean;
    }

    public SynthesizeBusinessDataResponse doTx1003(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1003 start.");
        SynthesizeBusinessDataRequest requestBean = (SynthesizeBusinessDataRequest)requestDto;
        SynthesizeBusinessDataRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1003(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1003 doCheckTx1003 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1003 handleRequest finish.");
        SynthesizeBusinessDataResponse responseBean = this.parseTx1003Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1003 parseTx1003Result finish.");
        logger.info("Tx10Transaction.doTx1003 end.");
        return responseBean;
    }

    public SynthesizeMultiDataResponse doTx1004(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1004 start.");
        SynthesizeMultiDataRequest requestBean = (SynthesizeMultiDataRequest)requestDto;
        SynthesizeMultiDataRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1004(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1004 doCheckTx1004 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1004 handleRequest finish.");
        SynthesizeMultiDataResponse responseBean = this.parseTx1004Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1004 parseTx1004Result finish.");
        logger.info("Tx10Transaction.doTx1004 end.");
        return responseBean;
    }

    public ConcatPdfListResponse doTx1005(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1005 start.");
        ConcatPdfListRequest requestBean = (ConcatPdfListRequest)requestDto;
        ConcatPdfListRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1005(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1005 doCheckTx1005 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1005 handleRequest finish.");
        ConcatPdfListResponse responseBean = this.parseTx1005Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1005 parseTx1005Result finish.");
        logger.info("Tx10Transaction.doTx1005 end.");
        return responseBean;
    }

    public AddWaterMarkToPdfResponse doTx1006(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1006 start.");
        AddWaterMarkToPdfRequest requestBean = (AddWaterMarkToPdfRequest)requestDto;
        AddWaterMarkToPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1006(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1006 doCheckTx1006 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1006 handleRequest finish.");
        AddWaterMarkToPdfResponse responseBean = this.parseTx1006Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1006 parseTx1006Result finish.");
        logger.info("Tx10Transaction.doTx1006 end.");
        return responseBean;
    }

    public AddCrossToPdfResponse doTx1007(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1007 start.");
        AddCrossToPdfRequest requestBean = (AddCrossToPdfRequest)requestDto;
        AddCrossToPdfRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1007(requestBody, inputFileDataList);
        logger.info("Tx10Transaction.doTx1007 doCheckTx1007 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1007 handleRequest finish.");
        AddCrossToPdfResponse responseBean = this.parseTx1007Result(responseJSONString, outputFileDataList);
        logger.info("Tx10Transaction.doTx1007 parseTx1007Result finish.");
        logger.info("Tx10Transaction.doTx1007 end.");
        return responseBean;
    }

    private ResponseDto parseTx1001Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        ResponseDto responseBean = JsonUtil.json2Obj(responseJSONString, ResponseDto.class);
        return responseBean;
    }

    private DownloadTemplateResponse parseTx1002Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        DownloadTemplateResponse responseBean = JsonUtil.json2Obj(responseJSONString, DownloadTemplateResponse.class);
        ResponseHead head = responseBean.getHead();
        DownloadTemplateResponseBody body = responseBean.getBody();
        if (CommonUtil.isNotEmpty(outputFileDataList)) {
            body.setTemplateData(outputFileDataList.get(0));
        }
        return responseBean;
    }

    private SynthesizeBusinessDataResponse parseTx1003Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SynthesizeBusinessDataResponse responseBean = JsonUtil.json2Obj(responseJSONString, SynthesizeBusinessDataResponse.class);
        ResponseHead head = responseBean.getHead();
        if ("000000".equals(head.getCode())) {
            SynthesizeBusinessDataResponseBody body = responseBean.getBody();
            if (CommonUtil.isNotEmpty(outputFileDataList)) {
                body.setPdf(outputFileDataList.get(0));
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(body.getPdf(), resultPdfFileDataHash);
            }
        }
        return responseBean;
    }

    private SynthesizeMultiDataResponse parseTx1004Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        SynthesizeMultiDataResponse responseBean = JsonUtil.json2Obj(responseJSONString, SynthesizeMultiDataResponse.class);
        ResponseHead head = responseBean.getHead();
        if ("000000".equals(head.getCode())) {
            SynthesizeMultiDataResponseBody body = responseBean.getBody();
            if (CommonUtil.isNotEmpty(outputFileDataList)) {
                body.setPdf(outputFileDataList.get(0));
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(body.getPdf(), resultPdfFileDataHash);
            }
        }
        return responseBean;
    }

    private ConcatPdfListResponse parseTx1005Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        ConcatPdfListResponse responseBean = JsonUtil.json2Obj(responseJSONString, ConcatPdfListResponse.class);
        ResponseHead head = responseBean.getHead();
        if ("000000".equals(head.getCode())) {
            ConcatPdfListResponseBody body = responseBean.getBody();
            if (CommonUtil.isNotEmpty(outputFileDataList)) {
                body.setPdf(outputFileDataList.get(0));
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(body.getPdf(), resultPdfFileDataHash);
            }
        }
        return responseBean;
    }

    private AddWaterMarkToPdfResponse parseTx1006Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        AddWaterMarkToPdfResponse responseBean = JsonUtil.json2Obj(responseJSONString, AddWaterMarkToPdfResponse.class);
        ResponseHead head = responseBean.getHead();
        if ("000000".equals(head.getCode())) {
            AddWaterMarkToPdfResponseBody body = responseBean.getBody();
            if (CommonUtil.isNotEmpty(outputFileDataList)) {
                body.setPdf(outputFileDataList.get(0));
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(body.getPdf(), resultPdfFileDataHash);
            }
        }
        return responseBean;
    }

    private AddCrossToPdfResponse parseTx1007Result(String responseJSONString, List<byte[]> outputFileDataList) throws Exception {
        AddCrossToPdfResponse responseBean = JsonUtil.json2Obj(responseJSONString, AddCrossToPdfResponse.class);
        ResponseHead head = responseBean.getHead();
        if ("000000".equals(head.getCode())) {
            AddCrossToPdfResponseBody body = responseBean.getBody();
            if (CommonUtil.isNotEmpty(outputFileDataList)) {
                body.setPdf(outputFileDataList.get(0));
                String resultPdfFileDataHash = body.getPdfFileDataHash();
                this.checkAndComparePdf(body.getPdf(), resultPdfFileDataHash);
            }
        }
        return responseBean;
    }

    public ResponseDto doTx1008(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1008 start.");
        AddOrganizationRequest requestBean = (AddOrganizationRequest)requestDto;
        AddOrganizationRequestBody requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1008(requestBody);
        logger.info("Tx10Transaction.doTx1008 doCheckTx1008 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1008 handleRequest finish.");
        AddOrganizationResponse responseBean = this.parseTx1008Result(responseJSONString);
        logger.info("Tx10Transaction.doTx1008 parseTx1008Result finish.");
        logger.info("Tx10Transaction.doTx1008 end.");
        return responseBean;
    }

    private AddOrganizationResponse parseTx1008Result(String responseJSONString) throws Exception {
        AddOrganizationResponse responseBean = JsonUtil.json2Obj(responseJSONString, AddOrganizationResponse.class);
        return responseBean;
    }

    public ResponseDto doTx1009(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1009 start.");
        UpdateOrganizationRequest requestBean = (UpdateOrganizationRequest)requestDto;
        Organization requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1009(requestBody);
        logger.info("Tx10Transaction.doTx1009 doCheckTx1009 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1009 handleRequest finish.");
        UpdateOrganizationResponse responseBean = this.parseTx1009Result(responseJSONString);
        logger.info("Tx10Transaction.doTx1009 parseTx1009Result finish.");
        logger.info("Tx10Transaction.doTx1009 end.");
        return responseBean;
    }

    private UpdateOrganizationResponse parseTx1009Result(String responseJSONString) throws Exception {
        UpdateOrganizationResponse responseBean = JsonUtil.json2Obj(responseJSONString, UpdateOrganizationResponse.class);
        return responseBean;
    }

    public ResponseDto doTx1010(HttpConnector httpConnector, RequestDto requestDto) throws Exception {
        logger.info("Tx10Transaction.doTx1010 start.");
        DeleteOrganizationRequest requestBean = (DeleteOrganizationRequest)requestDto;
        Organization requestBody = requestBean.getBody();
        ArrayList<byte[]> inputFileDataList = new ArrayList<byte[]>();
        ValidateUtil.doCheckTx1010(requestBody);
        logger.info("Tx10Transaction.doTx1010 doCheckTx1010 finish.");
        ArrayList<byte[]> outputFileDataList = new ArrayList<byte[]>();
        String responseJSONString = super.handleRequest(httpConnector, requestDto, inputFileDataList, outputFileDataList);
        logger.info("Tx10Transaction.doTx1010 handleRequest finish.");
        DeleteOrganizationResponse responseBean = this.parseTx1010Result(responseJSONString);
        logger.info("Tx10Transaction.doTx1009 parseTx1010Result finish.");
        logger.info("Tx10Transaction.doTx1009 end.");
        return responseBean;
    }

    private DeleteOrganizationResponse parseTx1010Result(String responseJSONString) throws Exception {
        DeleteOrganizationResponse responseBean = JsonUtil.json2Obj(responseJSONString, DeleteOrganizationResponse.class);
        return responseBean;
    }

    private void checkAndComparePdf(byte[] pdf, String resultPdfFileDataHash) throws Exception {
        boolean checkResult;
        ValidityUtil.checkIsPdfFile((byte[])pdf);
        if (StringUtil.isNotEmpty((String)resultPdfFileDataHash) && !(checkResult = ProofHashUtil.compareHashHex((byte[])pdf, (String)resultPdfFileDataHash))) {
            System.err.println("pdf hash compare resultPdfFileDataHash is error.");
            throw new Exception("pdf hash compare resultPdfFileDataHash is error.");
        }
    }
}

