/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.manager;

import cfca.sadk.tls.javax.net.ssl.CFCASNIHostName;
import cfca.sadk.tls.javax.net.ssl.CFCASNIServerName;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.manager.CertCheckResult;
import cfca.sadk.tls.sun.security.ssl.manager.CertKeyUsage;
import cfca.sadk.tls.sun.security.util.CFCASSLHelper;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

enum CertCheckType {
    NONE(new String[0]),
    CLIENT(new String[]{"2.5.29.37.0", "1.3.6.1.5.5.7.3.2"}),
    SERVER(new String[]{"2.5.29.37.0", "1.3.6.1.5.5.7.3.1", "2.16.840.1.113730.4.1", "1.3.6.1.4.1.311.10.3.3"});

    final Set<String> validEku;

    private CertCheckType(String[] validEku) {
        this.validEku = new HashSet<String>(Arrays.asList(validEku));
    }

    final CertCheckResult check(X509Certificate cert, Date date, List<CFCASNIServerName> serverNames, String idAlgorithm) {
        if (cert == null || date == null) {
            throw new IllegalArgumentException("parameters cert and date must not null");
        }
        CertCheckResult checkResult = CertCheckResult.OK;
        if (this == NONE) {
            return checkResult;
        }
        checkResult = this.checkExtensions(cert);
        if (checkResult != CertCheckResult.OK) {
            return checkResult;
        }
        checkResult = this.checkValidity(cert, date);
        if (checkResult != CertCheckResult.OK) {
            return checkResult;
        }
        return this.checkSNIServerName(cert, serverNames, idAlgorithm);
    }

    private final CertCheckResult checkExtensions(X509Certificate cert) {
        try {
            List<String> certEku = cert.getExtendedKeyUsage();
            if (certEku != null && Collections.disjoint(this.validEku, certEku)) {
                return CertCheckResult.EXTENSION_MISMATCH;
            }
            boolean[] keyUsage = cert.getKeyUsage();
            if (keyUsage != null) {
                String algorithm = cert.getPublicKey().getAlgorithm();
                boolean enabledSignBit = CertKeyUsage.digitalSignature.getEnabled(keyUsage);
                if (!(!"RSA".equals(algorithm) || enabledSignBit || this != CLIENT && CertKeyUsage.keyEncipherment.getEnabled(keyUsage))) {
                    return CertCheckResult.EXTENSION_MISMATCH;
                }
                if ("DSA".equals(algorithm) && !enabledSignBit) {
                    return CertCheckResult.EXTENSION_MISMATCH;
                }
                if ("DH".equals(algorithm) && !CertKeyUsage.keyAgreement.getEnabled(keyUsage)) {
                    return CertCheckResult.EXTENSION_MISMATCH;
                }
                if ("DH".equals(algorithm)) {
                    if (!enabledSignBit) {
                        return CertCheckResult.EXTENSION_MISMATCH;
                    }
                    if (this == SERVER && !CertKeyUsage.keyAgreement.getEnabled(keyUsage)) {
                        return CertCheckResult.EXTENSION_MISMATCH;
                    }
                }
            }
        }
        catch (CertificateException e) {
            return CertCheckResult.EXTENSION_MISMATCH;
        }
        return CertCheckResult.OK;
    }

    private final CertCheckResult checkValidity(X509Certificate cert, Date date) {
        CertCheckResult checkResult = CertCheckResult.OK;
        try {
            cert.checkValidity(date);
        }
        catch (CertificateExpiredException e) {
            checkResult = CertCheckResult.EXPIRED;
        }
        catch (CertificateNotYetValidException e) {
            checkResult = CertCheckResult.NOTYETVALID;
        }
        return checkResult;
    }

    private final CertCheckResult checkSNIServerName(X509Certificate cert, List<CFCASNIServerName> serverNames, String idAlgorithm) {
        CertCheckResult checkResult;
        block1: {
            checkResult = CertCheckResult.OK;
            if (serverNames == null || serverNames.isEmpty()) break block1;
            for (CFCASNIServerName serverName : serverNames) {
                if (serverName != null && (checkResult = this.checkSNIServerName(cert, serverName, idAlgorithm)) != CertCheckResult.OK) break;
            }
        }
        return checkResult;
    }

    private final CertCheckResult checkSNIServerName(X509Certificate cert, CFCASNIServerName serverName, String idAlgorithm) {
        CertCheckResult checkResult = CertCheckResult.OK;
        if (serverName.getType() == 0) {
            if (!(serverName instanceof CFCASNIHostName)) {
                try {
                    serverName = new CFCASNIHostName(serverName.getEncoded());
                }
                catch (IllegalArgumentException iae) {
                    if (Debugger.check.isDebugEnabled()) {
                        Debugger.check.debug("Illegal server name: {}", (Object)serverName);
                    }
                    return CertCheckResult.INSENSITIVE;
                }
            }
            String hostname = ((CFCASNIHostName)serverName).getAsciiName();
            try {
                CFCASSLHelper.checkIdentity(cert, idAlgorithm, hostname);
                checkResult = CertCheckResult.OK;
            }
            catch (CertificateException e) {
                if (Debugger.check.isDebugEnabled()) {
                    Debugger.check.debug("Certificate identity does not match  Server Name Inidication (SNI): {}", (Object)hostname);
                }
                checkResult = CertCheckResult.INSENSITIVE;
            }
        }
        return checkResult;
    }
}

