/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretGenerator;
import cfca.sadk.tls.sun.security.ssl.prf.TlsProtocolVersion;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;

public final class TlsMasterSecretParameters {
    private final SecretKey premasterSecret;
    private final TlsProtocolVersion versions;
    private final byte[] clientRandom;
    private final byte[] serverRandom;
    private final HashPRF prfHashParameters;

    public TlsMasterSecretParameters(SecretKey premasterSecret, int majorVersion, int minorVersion, byte[] clientRandom, byte[] serverRandom, HashPRF hashPRF) {
        TlsKeyMaterialsTools.checkParameters(hashPRF, clientRandom, serverRandom);
        TlsMasterSecretParameters.checkParameters(premasterSecret);
        this.premasterSecret = premasterSecret;
        this.versions = new TlsProtocolVersion(majorVersion, minorVersion);
        this.clientRandom = (byte[])clientRandom.clone();
        this.serverRandom = (byte[])serverRandom.clone();
        this.prfHashParameters = hashPRF;
    }

    private static void checkParameters(SecretKey premasterSecret) {
        if (premasterSecret == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "premasterSecret"));
        }
    }

    public SecretKey getPremasterSecret() {
        return this.premasterSecret;
    }

    public int getMajorVersion() {
        return this.versions.majorVersion;
    }

    public int getMinorVersion() {
        return this.versions.minorVersion;
    }

    public byte[] getClientRandom() {
        return (byte[])this.clientRandom.clone();
    }

    public byte[] getServerRandom() {
        return (byte[])this.serverRandom.clone();
    }

    public String getPRFHashAlg() {
        return this.prfHashParameters.prfHashAlg;
    }

    public int getPRFHashLength() {
        return this.prfHashParameters.prfHashLength;
    }

    public int getPRFBlockSize() {
        return this.prfHashParameters.prfBlockSize;
    }

    public HashPRF getPrfHashParameters() {
        return this.prfHashParameters;
    }

    public final SecretKey generateMasterKey() throws GeneralSecurityException {
        return new TlsMasterSecretGenerator().generateMasterKey(this);
    }
}

