/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.signature.decoder;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.signature.decoder.AbstractPKCS7Decoder;
import cfca.sadk.signature.rsa.RSAHashUtil;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.security.PublicKey;

final class PKCS7RSADecoder
extends AbstractPKCS7Decoder {
    public PKCS7RSADecoder(Session session, SignedData signedData, boolean isSM2Type) throws PKIException {
        super(session, signedData, isSM2Type);
    }

    public PKCS7RSADecoder(Session session, PKCS7SignFileParser signedFile, boolean isSM2Type) throws PKIException {
        super(session, signedFile, isSM2Type);
    }

    final boolean isSM2Type() {
        return false;
    }

    final byte[] getSignValue() throws PKIException {
        return SignerInfo.getInstance(this.signerInfo).getEncryptedDigest().getOctets();
    }

    final AbstractPKCS7Decoder.SignHashAlgorithm getSignHashAlgorithm() throws PKIException {
        SignerInfo signerInfo = SignerInfo.getInstance(this.signerInfo);
        ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
        if (!this.isRSASignType(encryptionId)) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support encryptionId=" + encryptionId);
        }
        ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
        Mechanism signM = Mechanisms.signMechanismRSAFrom(digestId);
        if (signM == null) {
            throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, "do not support digestId=" + digestId);
        }
        String hashAlg = Mechanisms.getDigestAlgorithmName(digestId);
        return new AbstractPKCS7Decoder.SignHashAlgorithm(signM, hashAlg);
    }

    final byte[] hashData(String digestAlgorithm, byte[] sourceData, PublicKey pubKey) throws PKIException {
        try {
            boolean forJNILib = this.session != null && this.session.useJniNativeOperation();
            byte[] hashValue = null;
            hashValue = forJNILib ? HashUtil.RSAHashMessageByJNI(sourceData, new Mechanism(digestAlgorithm), false) : HashUtil.RSAHashMessageByBC(sourceData, new Mechanism(digestAlgorithm), false);
            return hashValue;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    final byte[] hashData(String digestAlgorithm, InputStream sourceData, PublicKey pubKey) throws PKIException {
        try {
            return RSAHashUtil.calculateDigest(digestAlgorithm, sourceData, this.session);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    byte[] hashData(String digestAlgorithm, ASN1Node sourceNode, PublicKey pubKey, String sourceFileOutputPath) throws PKIException {
        try {
            return RSAHashUtil.calculateDigest(digestAlgorithm, sourceNode, sourceFileOutputPath, this.session);
        }
        catch (Exception e) {
            throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, "sourceHash do not successfully", e);
        }
    }

    private boolean isRSASignType(ASN1ObjectIdentifier encryptionId) {
        return PKCSObjectIdentifiers.rsaEncryption.equals(encryptionId) || PKCSObjectIdentifiers.sha1WithRSAEncryption.equals(encryptionId) || PKCSObjectIdentifiers.sha256WithRSAEncryption.equals(encryptionId) || PKCSObjectIdentifiers.sha384WithRSAEncryption.equals(encryptionId) || PKCSObjectIdentifiers.sha512WithRSAEncryption.equals(encryptionId) || PKCSObjectIdentifiers.md5WithRSAEncryption.equals(encryptionId);
    }
}

