/*
 * Decompiled with CFR 0.152.
 */
package cfca.com.itextpdf.tool.xml.html;

import cfca.com.itextpdf.text.Chunk;
import cfca.com.itextpdf.text.Element;
import cfca.com.itextpdf.text.Paragraph;
import cfca.com.itextpdf.text.pdf.draw.LineSeparator;
import cfca.com.itextpdf.tool.xml.NoCustomContextException;
import cfca.com.itextpdf.tool.xml.Tag;
import cfca.com.itextpdf.tool.xml.WorkerContext;
import cfca.com.itextpdf.tool.xml.css.FontSizeTranslator;
import cfca.com.itextpdf.tool.xml.exceptions.LocaleMessages;
import cfca.com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import cfca.com.itextpdf.tool.xml.html.CssAppliers;
import cfca.com.itextpdf.tool.xml.html.CssAppliersAware;
import cfca.com.itextpdf.tool.xml.html.HTMLUtils;
import cfca.com.itextpdf.tool.xml.html.TagProcessor;
import cfca.com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import cfca.com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import cfca.com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import cfca.com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagProcessor
implements TagProcessor,
CssAppliersAware {
    private final FontSizeTranslator fontsizeTrans = FontSizeTranslator.getInstance();
    private CssAppliers cssAppliers;

    public CSSResolver getCSSResolver(WorkerContext context) throws NoCustomContextException {
        return (CSSResolver)((ObjectContext)context.get(CssResolverPipeline.class.getName())).get();
    }

    public HtmlPipelineContext getHtmlPipelineContext(WorkerContext context) throws NoCustomContextException {
        return (HtmlPipelineContext)context.get(HtmlPipeline.class.getName());
    }

    @Override
    public final List<Element> startElement(WorkerContext ctx, Tag tag) {
        String pagebreak;
        float fontSize = this.fontsizeTrans.translateFontSize(tag);
        if (fontSize != -1.0f) {
            tag.getCSS().put("font-size", fontSize + "pt");
        }
        if (null != (pagebreak = tag.getCSS().get("page-break-before")) && "always".equalsIgnoreCase(pagebreak)) {
            ArrayList<Element> list = new ArrayList<Element>(2);
            list.add(Chunk.NEXTPAGE);
            list.addAll(this.start(ctx, tag));
            return list;
        }
        return this.start(ctx, tag);
    }

    public List<Element> start(WorkerContext ctx, Tag tag) {
        return new ArrayList<Element>(0);
    }

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        return new ArrayList<Element>(0);
    }

    protected int getRunDirection(Tag tag) {
        String dirValue = tag.getCSS().get("dir");
        if (dirValue == null) {
            dirValue = tag.getAttributes().get("dir");
        }
        if ("rtl".equalsIgnoreCase(dirValue)) {
            return 3;
        }
        if ("ltr".equalsIgnoreCase(dirValue)) {
            return 2;
        }
        return 0;
    }

    protected List<Element> textContent(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            try {
                l.add(this.getCssAppliers().apply(sanitized, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public final List<Element> endElement(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> list = new ArrayList();
        if (currentContent.isEmpty()) {
            list = this.end(ctx, tag, currentContent);
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element el : currentContent) {
                if (el instanceof Chunk && ((Chunk)el).hasAttributes() && ((Chunk)el).getAttributes().containsKey("NEWPAGE")) {
                    if (elements.size() > 0) {
                        list.addAll(this.end(ctx, tag, elements));
                        elements.clear();
                    }
                    list.add(el);
                    continue;
                }
                elements.add(el);
            }
            if (elements.size() > 0) {
                list.addAll(this.end(ctx, tag, elements));
                elements.clear();
            }
        }
        String pagebreak = tag.getCSS().get("page-break-after");
        if (null != pagebreak && "always".equalsIgnoreCase(pagebreak)) {
            list.add(Chunk.NEXTPAGE);
        }
        return list;
    }

    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        return new ArrayList<Element>(currentContent);
    }

    @Override
    public boolean isStackOwner() {
        return false;
    }

    public List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines, boolean applyCSS, Tag tag, WorkerContext ctx) {
        try {
            ArrayList<Element> list = new ArrayList<Element>();
            if (currentContent.size() > 0) {
                if (addNewLines) {
                    Paragraph p = this.createParagraph();
                    p.setMultipliedLeading(1.2f);
                    for (Element e : currentContent) {
                        if (e instanceof LineSeparator) {
                            try {
                                HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                                Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                                p.add(newLine);
                            }
                            catch (NoCustomContextException e1) {
                                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                            }
                        }
                        p.add(e);
                    }
                    if (p.trim()) {
                        if (applyCSS) {
                            p = (Paragraph)this.getCssAppliers().apply(p, tag, this.getHtmlPipelineContext(ctx));
                        }
                        list.add(p);
                    }
                } else {
                    NoNewLineParagraph p = new NoNewLineParagraph(Float.NaN);
                    p.setMultipliedLeading(1.2f);
                    for (Element e : currentContent) {
                        p.add(e);
                    }
                    p = (NoNewLineParagraph)this.getCssAppliers().apply(p, tag, this.getHtmlPipelineContext(ctx));
                    list.add(p);
                }
            }
            return list;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    public final List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines) {
        return this.currentContentToParagraph(currentContent, addNewLines, false, null, null);
    }

    @Override
    public void setCssAppliers(CssAppliers cssAppliers) {
        this.cssAppliers = cssAppliers;
    }

    @Override
    public CssAppliers getCssAppliers() {
        return this.cssAppliers;
    }

    protected Paragraph createParagraph() {
        return new Paragraph(Float.NaN);
    }
}

