/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200r.BigIntegers;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKey;
import cfca.sadk.lib.crypto.card.c200r.RSARefPublicKeyParams;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;

public final class C200RSAPublicKey
extends BCRSAPublicKey
implements C200RSAKey {
    private static final long serialVersionUID = -3958659078118796232L;
    final int bitLength;
    final byte[] keyData;
    final int keyIndex;

    private C200RSAPublicKey(int keyIndex, byte[] pubKeyData) throws CardException {
        super(new RSARefPublicKeyParams((byte[])pubKeyData).params);
        this.bitLength = BigIntegers.parseModulusBitLength(pubKeyData);
        this.keyData = pubKeyData;
        this.keyIndex = keyIndex;
    }

    static C200RSAPublicKey buildExtervalSoftKey(byte[] pubKeyData) throws CardException {
        return new C200RSAPublicKey(-1, pubKeyData);
    }

    static C200RSAPublicKey buildIntervalHardKey(int keyIndex, byte[] pubKeyData) throws CardException {
        if (keyIndex <= 0) {
            throw new CardException("C200RSACard buildIntervalHardKey failure with keyIndex=" + keyIndex);
        }
        return new C200RSAPublicKey(keyIndex, pubKeyData);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("C200RSAPublicKey [bitLength=");
        builder.append(this.bitLength);
        builder.append(",pubKeyData=");
        builder.append(Hex.toHexString(this.keyData));
        builder.append(",keyIndex=");
        builder.append(this.keyIndex);
        builder.append("(#isHardKey=").append(this.isHardKey());
        builder.append("]");
        return builder.toString();
    }

    public byte[] getEncoded() {
        return super.getEncoded();
    }

    public boolean isHardKey() {
        return this.keyIndex > 0;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int modulusBitsLength() {
        return this.bitLength;
    }

    public int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public byte[] keyData() throws CardException {
        return (byte[])this.keyData.clone();
    }

    public String dumpPublicKey() {
        return "pubKeyData=" + Hex.toHexString(this.keyData, 0, 1028);
    }
}

