/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.sadk.security.deferred;

import cfca.com.itextpdf.text.pdf.PdfDate;
import cfca.com.itextpdf.text.pdf.PdfDictionary;
import cfca.com.itextpdf.text.pdf.PdfName;
import cfca.com.itextpdf.text.pdf.security.ExternalBlankSignatureContainer;
import cfca.com.itextpdf.text.pdf.security.ExternalDigest;
import cfca.com.itextpdf.text.pdf.security.ExternalSignature;
import cfca.com.itextpdf.text.pdf.security.MakeSignature;
import cfca.com.itextpdf.text.pdf.security.PdfPKCS7;
import cfca.com.itextpdf.text.pdf.security.TSAClientBouncyCastle;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.sadk.security.deferred.ReservedPdfPKCS7;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;

public class ExternalReservedSignatureContainer
extends ExternalBlankSignatureContainer {
    private ExternalSignature externalSignature;
    private ExternalDigest externalDigest;
    private ReservedPdfPKCS7 reservedPdfPKCS7;

    public ExternalReservedSignatureContainer(PdfDictionary sigDic) {
        super(sigDic);
    }

    public ExternalReservedSignatureContainer(PdfName filter, PdfName subFilter) {
        super(filter, subFilter);
    }

    public ExternalReservedSignatureContainer(PdfName filter, PdfName subFilter, ExternalDigest externalDigest, ExternalSignature externalSignature, ReservedPdfPKCS7 reservedPdfPKCS7) {
        super(filter, subFilter);
        this.externalDigest = externalDigest;
        this.externalSignature = externalSignature;
        this.reservedPdfPKCS7 = reservedPdfPKCS7;
    }

    public byte[] sign(InputStream data) throws GeneralSecurityException {
        String hashAlgorithm = this.externalSignature.getHashAlgorithm();
        String encryptionAlgorithm = this.externalSignature.getEncryptionAlgorithm();
        byte[][] tmpChainBytes = this.reservedPdfPKCS7.chainBytes;
        int lenOfChain = tmpChainBytes.length;
        Certificate[] chain = new X509Certificate[lenOfChain];
        byte[] encodedSig = new byte[]{};
        if ("RSA".equals(encryptionAlgorithm)) {
            int type = this.reservedPdfPKCS7.type;
            if (type != 1) {
                int i = 0;
                while (i < lenOfChain) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(tmpChainBytes[i]);
                    CertificateFactory fact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)fact.generateCertificate(bais);
                    chain[i++] = cert;
                }
                PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, this.externalDigest, false);
                byte[] hash = this.reservedPdfPKCS7.hashPdf;
                byte[] ocsp = this.reservedPdfPKCS7.ocspBytes;
                byte[] extSignature = this.reservedPdfPKCS7.signaturePKCS1;
                sgn.setExternalDigest(extSignature, null, this.externalSignature.getEncryptionAlgorithm());
                TSAClientBouncyCastle tsaClient = null;
                if (this.reservedPdfPKCS7.tsaClientBouncyCastle != null) {
                    tsaClient = this.reservedPdfPKCS7.tsaClientBouncyCastle;
                } else if (this.reservedPdfPKCS7.tsaUrl != null) {
                    tsaClient = new TSAClientBouncyCastle(this.reservedPdfPKCS7.tsaUrl, this.reservedPdfPKCS7.tsaUserName, this.reservedPdfPKCS7.tsaPassword, this.reservedPdfPKCS7.tsaEstimatedTokenSize, this.reservedPdfPKCS7.tsaDigestAlgorithm);
                }
                byte[][] tmpCrlBytes = this.reservedPdfPKCS7.crlBytes;
                ArrayList<byte[]> crlBytes = null;
                if (tmpCrlBytes != null) {
                    crlBytes = new ArrayList<byte[]>();
                    int lenOfCrls = tmpCrlBytes.length;
                    i = 0;
                    while (i < lenOfCrls) {
                        crlBytes.add(tmpCrlBytes[i++]);
                    }
                }
                MakeSignature.CryptoStandard sigtype = MakeSignature.CryptoStandard.CADES.ordinal() == this.reservedPdfPKCS7.cryptostandard ? MakeSignature.CryptoStandard.CADES : MakeSignature.CryptoStandard.CMS;
                Calendar cal = null;
                if (2 == this.reservedPdfPKCS7.type) {
                    cal = PdfDate.decode(this.reservedPdfPKCS7.calendarLocalString);
                }
                encodedSig = sgn.getEncodedPKCS7(hash, cal, tsaClient, ocsp, crlBytes, sigtype);
            } else {
                int i = 0;
                while (i < lenOfChain) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(tmpChainBytes[i]);
                    CertificateFactory fact = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)fact.generateCertificate(bais);
                    chain[i++] = cert;
                }
                PdfPKCS7 sgn = new PdfPKCS7(null, chain, hashAlgorithm, null, this.externalDigest, false);
                byte[] hash = this.reservedPdfPKCS7.hashPdf;
                byte[] extSignature = this.reservedPdfPKCS7.signaturePKCS1;
                sgn.setExternalDigest(extSignature, null, this.externalSignature.getEncryptionAlgorithm());
                TSAClientBouncyCastle tsaClient = null;
                if (this.reservedPdfPKCS7.tsaUrl != null) {
                    tsaClient = new TSAClientBouncyCastle(this.reservedPdfPKCS7.tsaUrl, this.reservedPdfPKCS7.tsaUserName, this.reservedPdfPKCS7.tsaPassword, this.reservedPdfPKCS7.tsaEstimatedTokenSize, this.reservedPdfPKCS7.tsaDigestAlgorithm);
                }
                MakeSignature.CryptoStandard sigtype = MakeSignature.CryptoStandard.CADES.ordinal() == this.reservedPdfPKCS7.cryptostandard ? MakeSignature.CryptoStandard.CADES : MakeSignature.CryptoStandard.CMS;
                encodedSig = sgn.getEncodedPKCS7(hash, null, tsaClient, null, null, sigtype);
            }
        } else if ("SM2".equals(encryptionAlgorithm)) {
            try {
                int i;
                tmpChainBytes = this.reservedPdfPKCS7.chainBytes;
                Mechanism mechanism = new Mechanism("sm3WithSM2Encryption");
                PKCS7SignedData p7 = new PKCS7SignedData((Session)new BCSoftLib());
                byte[] signture = this.reservedPdfPKCS7.signaturePKCS1;
                ASN1InputStream in = new ASN1InputStream(signture);
                ASN1Sequence seq = (ASN1Sequence)in.readObject();
                ASN1Integer r = (ASN1Integer)seq.getObjectAt(0);
                ASN1Integer s = (ASN1Integer)seq.getObjectAt(1);
                byte[] rBytes = r.getValue().toByteArray();
                byte[] sBytes = s.getValue().toByteArray();
                byte[] rsBytes = new byte[64];
                int len = rBytes.length;
                for (i = 0; i < len && i < 32; ++i) {
                    rsBytes[31 - i] = rBytes[len - 1 - i];
                }
                len = sBytes.length;
                for (i = 0; i < len && i < 32; ++i) {
                    rsBytes[63 - i] = sBytes[len - 1 - i];
                }
                X509Cert x509Cert = new X509Cert(tmpChainBytes[0]);
                encodedSig = p7.packageSignedData(false, null, null, rsBytes, mechanism, new X509Cert[]{x509Cert});
            }
            catch (IOException e) {
                throw new GeneralSecurityException("read asn1 object failed!");
            }
            catch (PKIException e) {
                throw new GeneralSecurityException("create pkcs7 failed!");
            }
        }
        return encodedSig;
    }
}

