/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.google.typography.font.sfntly.data;

import cfca.sadk.com.google.typography.font.sfntly.data.ByteArray;

public abstract class FontData {
    protected static final int GROWABLE_SIZE = Integer.MAX_VALUE;
    protected final ByteArray<? extends ByteArray<?>> array;
    private int boundOffset;
    private int boundLength = Integer.MAX_VALUE;

    protected FontData(ByteArray<? extends ByteArray<?>> ba) {
        this.array = ba;
    }

    protected FontData(FontData data, int offset, int length) {
        this(data.array);
        this.bound(data.boundOffset + offset, length);
    }

    protected FontData(FontData data, int offset) {
        this(data.array);
        this.bound(data.boundOffset + offset, data.boundLength == Integer.MAX_VALUE ? Integer.MAX_VALUE : data.boundLength - offset);
    }

    public boolean bound(int offset, int length) {
        if (offset + length > this.size() || offset < 0 || length < 0) {
            return false;
        }
        this.boundOffset += offset;
        this.boundLength = length;
        return true;
    }

    public boolean bound(int offset) {
        if (offset > this.size() || offset < 0) {
            return false;
        }
        this.boundOffset += offset;
        return true;
    }

    public abstract FontData slice(int var1, int var2);

    public abstract FontData slice(int var1);

    public int length() {
        return Math.min(this.array.length() - this.boundOffset, this.boundLength);
    }

    public int size() {
        return Math.min(this.array.size() - this.boundOffset, this.boundLength);
    }

    public final int dataOffset() {
        return this.boundOffset;
    }

    protected final int boundOffset(int offset) {
        return offset + this.boundOffset;
    }

    protected final int boundLength(int offset, int length) {
        return Math.min(length, this.boundLength - offset);
    }

    protected final boolean boundsCheck(int offset, int length) {
        if (offset < 0 || offset >= this.boundLength) {
            return false;
        }
        return length >= 0 && length + offset <= this.boundLength;
    }

    public static enum DataSize {
        BYTE(1),
        CHAR(1),
        USHORT(2),
        SHORT(2),
        UINT24(3),
        ULONG(4),
        LONG(4),
        Fixed(4),
        FUNIT(4),
        FWORD(2),
        UFWORD(2),
        F2DOT14(2),
        LONGDATETIME(8),
        Tag(4),
        GlyphID(2),
        Offset(2);

        private final int size;

        private DataSize(int size) {
            this.size = size;
        }

        public int size() {
            return this.size;
        }
    }
}

