/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.SSLProtocolVersionConstants;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialParameters;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterials;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretGenerator;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfGenerator;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class TlsKeyMaterialGenerator
implements TlsKeyMaterialsConstants,
SSLProtocolVersionConstants {
    protected TlsKeyMaterialGenerator() {
    }

    final TlsKeyMaterials generateWorkKeys(TlsKeyMaterialParameters params) throws GeneralSecurityException {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsKeyMaterialParameters"));
        }
        if (params.getMasterSecret() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsKeyMaterialParameters#MasterSecret"));
        }
        if (!"RAW".equals(params.getMasterSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsKeyMaterialParameters#MasterSecret"));
        }
        int protocolVersion = params.getMajorVersion() << 8 | params.getMinorVersion();
        if (!TlsMasterSecretGenerator.hasVersion(protocolVersion)) {
            throw new InvalidAlgorithmParameterException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
        }
        byte[] masterSecret = params.getMasterSecret().getEncoded();
        if (masterSecret == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "masterSecret"));
        }
        byte[] clientRandom = params.getClientRandom();
        if (clientRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "clientRandom"));
        }
        byte[] serverRandom = params.getServerRandom();
        if (serverRandom == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "serverRandom"));
        }
        byte[] bothRandom = TlsKeyMaterialsTools.concat(serverRandom, clientRandom);
        HashPRF prf = params.hashPRF();
        int macLength = params.getMacKeyLength();
        int expandedKeyLength = params.getExpandedCipherKeyLength();
        boolean isExportable = expandedKeyLength != 0;
        int keyLength = params.getCipherKeyLength();
        int ivLength = params.getIvLength();
        int keyBlockLen = macLength + keyLength + (isExportable ? 0 : ivLength) << 1;
        MessageDigest md5 = JSSEJCE.getMessageDigest("MD5");
        MessageDigest sha = JSSEJCE.getMessageDigest("SHA1");
        byte[] keyBlock = this.generateKeyBlock(protocolVersion, masterSecret, bothRandom, serverRandom, clientRandom, keyBlockLen, prf, md5, sha);
        TlsKeyMaterials keyMaterials = new TlsKeyMaterials();
        int offset = 0;
        if (macLength != 0) {
            keyMaterials.clientMacKey = TlsKeyMaterialGenerator.buildSecretKey(keyBlock, offset, macLength, "Mac");
            keyMaterials.serverMacKey = TlsKeyMaterialGenerator.buildSecretKey(keyBlock, offset += macLength, macLength, "Mac");
            offset += macLength;
        }
        if (keyLength != 0) {
            String cipherAlgorithm = params.getCipherAlgorithm();
            byte[] clientKeyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset, keyLength);
            byte[] serverKeyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset += keyLength, keyLength);
            offset += keyLength;
            if (isExportable) {
                if (protocolVersion >= 770) {
                    throw new RuntimeException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.mustNotNegotiating"));
                }
                if (protocolVersion == 769) {
                    this.setKeyMaterialsforTLSv10(keyMaterials, clientKeyBytes, serverKeyBytes, bothRandom, expandedKeyLength, cipherAlgorithm, ivLength, md5, sha);
                } else {
                    this.setKeyMaterialsforSSLv3(keyMaterials, clientKeyBytes, serverKeyBytes, clientRandom, serverRandom, expandedKeyLength, cipherAlgorithm, ivLength, md5);
                }
            } else {
                this.setKeyMaterials(keyMaterials, clientKeyBytes, serverKeyBytes, cipherAlgorithm, keyBlock, offset, ivLength);
            }
        }
        return keyMaterials;
    }

    private final byte[] generateKeyBlock(int protocolVersion, byte[] masterSecret, byte[] seed, byte[] serverRandom, byte[] clientRandom, int keyBlockLen, HashPRF hashPRF, MessageDigest md5, MessageDigest sha) throws DigestException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        byte[] keyBlock = new byte[keyBlockLen];
        switch (protocolVersion) {
            case 768: {
                keyBlock = TlsPrfGenerator.doSSL30PRF(masterSecret, serverRandom, clientRandom, keyBlockLen, md5, sha);
                break;
            }
            case 257: 
            case 258: {
                keyBlock = TlsPrfGenerator.doTLS12PRF(masterSecret, LABEL_KEY_EXPANSION, seed, keyBlockLen, hashPRF);
                break;
            }
            case 771: {
                keyBlock = TlsPrfGenerator.doTLS12PRF(masterSecret, LABEL_KEY_EXPANSION, seed, keyBlockLen, hashPRF);
                break;
            }
            case 769: 
            case 770: {
                keyBlock = TlsPrfGenerator.doTLS10PRF(masterSecret, LABEL_KEY_EXPANSION, seed, keyBlockLen, md5, sha);
                break;
            }
            default: {
                throw new InvalidAlgorithmParameterException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
            }
        }
        return keyBlock;
    }

    private final void setKeyMaterialsforTLSv10(TlsKeyMaterials keyMaterials, byte[] clientKeyBytes, byte[] serverKeyBytes, byte[] bothRandom, int expandedKeyLength, String cipherAlgorithm, int ivLength, MessageDigest md5, MessageDigest sha) throws DigestException {
        keyMaterials.clientCipherKey = new SecretKeySpec(TlsPrfGenerator.doTLS10PRF(clientKeyBytes, LABEL_CLIENT_WRITE_KEY, bothRandom, expandedKeyLength, md5, sha), cipherAlgorithm);
        keyMaterials.serverCipherKey = new SecretKeySpec(TlsPrfGenerator.doTLS10PRF(serverKeyBytes, LABEL_SERVER_WRITE_KEY, bothRandom, expandedKeyLength, md5, sha), cipherAlgorithm);
        if (ivLength != 0) {
            byte[] ivBytes = TlsPrfGenerator.doTLS10PRF(null, LABEL_IV_BLOCK, bothRandom, ivLength * 2, md5, sha);
            keyMaterials.clientIv = new IvParameterSpec(ivBytes, 0, ivLength);
            keyMaterials.serverIv = new IvParameterSpec(ivBytes, ivLength, ivLength);
        }
    }

    private final void setKeyMaterialsforSSLv3(TlsKeyMaterials keyMaterials, byte[] clientKeyBytes, byte[] serverKeyBytes, byte[] clientRandom, byte[] serverRandom, int expandedKeyLength, String cipherAlgorithm, int ivLength, MessageDigest md5) {
        keyMaterials.clientCipherKey = TlsKeyMaterialGenerator.buildExpandedKey(clientKeyBytes, clientRandom, serverRandom, expandedKeyLength, cipherAlgorithm, md5);
        keyMaterials.serverCipherKey = TlsKeyMaterialGenerator.buildExpandedKey(serverKeyBytes, serverRandom, clientRandom, expandedKeyLength, cipherAlgorithm, md5);
        if (ivLength != 0) {
            keyMaterials.clientIv = TlsKeyMaterialGenerator.buildIvParameter(clientRandom, serverRandom, ivLength, md5);
            keyMaterials.serverIv = TlsKeyMaterialGenerator.buildIvParameter(serverRandom, clientRandom, ivLength, md5);
        }
    }

    private final void setKeyMaterials(TlsKeyMaterials keyMaterials, byte[] clientKeyBytes, byte[] serverKeyBytes, String cipherAlgorithm, byte[] keyBlock, int offset, int ivLength) {
        keyMaterials.clientCipherKey = new SecretKeySpec(clientKeyBytes, cipherAlgorithm);
        keyMaterials.serverCipherKey = new SecretKeySpec(serverKeyBytes, cipherAlgorithm);
        if (ivLength != 0) {
            keyMaterials.clientIv = new IvParameterSpec(keyBlock, offset, ivLength);
            keyMaterials.serverIv = new IvParameterSpec(keyBlock, offset + ivLength, ivLength);
        }
    }

    private static final SecretKey buildExpandedKey(byte[] keyBytesPartOne, byte[] randomPartOne, byte[] randomPartTwo, int expandedKeyLength, String cipherAlgorithm, MessageDigest md5) {
        byte[] expandedKeyBytes = new byte[expandedKeyLength];
        md5.update(keyBytesPartOne);
        md5.update(randomPartOne);
        md5.update(randomPartTwo);
        System.arraycopy(md5.digest(), 0, expandedKeyBytes, 0, expandedKeyLength);
        return new SecretKeySpec(expandedKeyBytes, cipherAlgorithm);
    }

    private static final IvParameterSpec buildIvParameter(byte[] randomPartOne, byte[] randomPartTwo, int ivLength, MessageDigest md5) {
        byte[] ivBytes = new byte[ivLength];
        md5.update(randomPartOne);
        md5.update(randomPartTwo);
        System.arraycopy(md5.digest(), 0, ivBytes, 0, ivLength);
        return new IvParameterSpec(ivBytes);
    }

    private static final SecretKey buildSecretKey(byte[] keyBlock, int offset, int macLength, String keyAlgorithm) {
        byte[] keyBytes = TlsKeyMaterialsTools.copyBytes(keyBlock, offset, macLength);
        return new SecretKeySpec(keyBytes, keyAlgorithm);
    }
}

