/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.common.ZipUtil;
import cfca.sadk.ofd.base.config.VersionInfo;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.base.seal.RevokeResultInfo;
import cfca.sadk.ofd.base.seal.SealXMLUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Map;

public class RevokeSignatureUtil {
    private static Logger businessLog = LoggerFactory.getLogger(RevokeSignatureUtil.class);

    public static RevokeResultInfo revokeLastSign(byte[] ofdDatas) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        return RevokeSignatureUtil.doRevokeLastSign(filesMap);
    }

    public static RevokeResultInfo revokeLastSign(InputStream ofdInputStream) throws Exception {
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
        return RevokeSignatureUtil.doRevokeLastSign(filesMap);
    }

    public static RevokeResultInfo revokeAllSigns(byte[] ofdDatas) throws Exception {
        if (null == ofdDatas) {
            throw new IllegalArgumentException("ofdDatas is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(new ByteArrayInputStream(ofdDatas));
        return RevokeSignatureUtil.doRevokeAllSigns(filesMap);
    }

    public static RevokeResultInfo revokeAllSigns(InputStream ofdInputStream) throws Exception {
        if (null == ofdInputStream) {
            throw new IllegalArgumentException("ofdInputStream is null");
        }
        Map<String, byte[]> filesMap = ZipUtil.uncompress(ofdInputStream);
        return RevokeSignatureUtil.doRevokeAllSigns(filesMap);
    }

    private static RevokeResultInfo doRevokeLastSign(Map<String, byte[]> filesMap) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("revokeLastSign start...");
        RevokeResultInfo revokeResult = new RevokeResultInfo();
        String signID = null;
        try {
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            byte[] signaturesData = filesMap.get(baseDir + "Signatures.xml");
            String tmpSignatures = "";
            String signDir = "Signs/Sign_";
            if (null == signaturesData) {
                tmpSignatures = "Signs/";
                signaturesData = filesMap.get(baseDir + tmpSignatures + "Signatures.xml");
                if (null == signaturesData) {
                    throw new IllegalArgumentException("no signature exists!");
                }
                signDir = signDir.replace("Signs/", "");
            }
            signID = SealXMLUtil.deleteLastSignatureNode(filesMap, baseDir, tmpSignatures);
            filesMap.remove(baseDir + tmpSignatures + signDir + signID + "/" + "Seal.esl");
            filesMap.remove(baseDir + tmpSignatures + signDir + signID + "/" + "Signature.xml");
            filesMap.remove(baseDir + tmpSignatures + signDir + signID + "/" + "SignedValue.dat");
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            revokeResult.setRevokedData(newOFDStream.toByteArray());
            revokeResult.setRevokeStatus(true);
            revokeResult.setSignID(signID);
            RevokeResultInfo revokeResultInfo = revokeResult;
            return revokeResultInfo;
        }
        catch (SealException e) {
            businessLog.error("revokeLastSign failed:", (Throwable)e);
            revokeResult.setRevokeStatus(false);
            revokeResult.setFailReason(e.getMessage());
            revokeResult.setSignID(signID);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("revokeLastSign failed:", (Throwable)e);
            revokeResult.setRevokeStatus(false);
            revokeResult.setFailReason(e.getMessage());
            revokeResult.setSignID(signID);
            throw new SealException("revokeLastSign failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("revokeLastSign end...cost= " + (end - start) + " ms");
        }
    }

    private static RevokeResultInfo doRevokeAllSigns(Map<String, byte[]> filesMap) throws Exception {
        long start = System.currentTimeMillis();
        businessLog.info("revokeAllSigns start...");
        RevokeResultInfo revokeResult = new RevokeResultInfo();
        try {
            String[] allSignatureIds;
            String baseDir = SealXMLUtil.getBaseDir(filesMap);
            byte[] signaturesData = filesMap.get(baseDir + "Signatures.xml");
            String tmpSignatures = "";
            String signDir = "Signs/Sign_";
            if (null == signaturesData) {
                tmpSignatures = "Signs/";
                signaturesData = filesMap.get(baseDir + tmpSignatures + "Signatures.xml");
                if (null == signaturesData) {
                    throw new IllegalArgumentException("no signature exists!");
                }
            }
            for (String signID : allSignatureIds = SealXMLUtil.getAllSignatureIds(filesMap, baseDir, tmpSignatures)) {
                filesMap.remove(baseDir + signDir + signID + "/" + "Seal.esl");
                filesMap.remove(baseDir + signDir + signID + "/" + "Signature.xml");
                filesMap.remove(baseDir + signDir + signID + "/" + "SignedValue.dat");
            }
            SealXMLUtil.deteleSignatureFiles(filesMap, baseDir, tmpSignatures);
            ByteArrayOutputStream newOFDStream = ZipUtil.compress(filesMap);
            revokeResult.setRevokedData(newOFDStream.toByteArray());
            revokeResult.setRevokeStatus(true);
            RevokeResultInfo revokeResultInfo = revokeResult;
            return revokeResultInfo;
        }
        catch (SealException e) {
            businessLog.error("revokeLastSign failed:", (Throwable)e);
            revokeResult.setRevokeStatus(false);
            revokeResult.setFailReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            businessLog.error("revokeLastSign failed:", (Throwable)e);
            revokeResult.setRevokeStatus(false);
            revokeResult.setFailReason(e.getMessage());
            throw new SealException("revokeLastSign failed:", e);
        }
        finally {
            long end = System.currentTimeMillis();
            businessLog.info("revokeLastSign end...cost= " + (end - start) + " ms");
        }
    }

    static {
        VersionInfo.environments();
    }
}

