/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.signatures;

import cfca.sadk.com.itextpdf.signatures.DigestAlgorithms;
import cfca.sadk.com.itextpdf.signatures.IExternalDigest;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.GOST3411;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.MD2;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.MD5;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.RIPEMD128;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.RIPEMD160;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.RIPEMD256;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.SHA1;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.SHA224;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.SHA256;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.SHA384;
import cfca.sadk.org.bouncycastle.jcajce.provider.digest.SHA512;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BouncyCastleDigest
implements IExternalDigest {
    @Override
    public MessageDigest getMessageDigest(String hashAlgorithm) throws GeneralSecurityException {
        String oid = DigestAlgorithms.getAllowedDigest(hashAlgorithm);
        if ("1.2.840.113549.2.2".equals(oid)) {
            return new MD2.Digest();
        }
        if ("1.2.840.113549.2.5".equals(oid)) {
            return new MD5.Digest();
        }
        if ("1.3.14.3.2.26".equals(oid)) {
            return new SHA1.Digest();
        }
        if ("2.16.840.1.101.3.4.2.4".equals(oid)) {
            return new SHA224.Digest();
        }
        if ("2.16.840.1.101.3.4.2.1".equals(oid)) {
            return new SHA256.Digest();
        }
        if ("2.16.840.1.101.3.4.2.2".equals(oid)) {
            return new SHA384.Digest();
        }
        if ("2.16.840.1.101.3.4.2.3".equals(oid)) {
            return new SHA512.Digest();
        }
        if ("1.3.36.3.2.2".equals(oid)) {
            return new RIPEMD128.Digest();
        }
        if ("1.3.36.3.2.1".equals(oid)) {
            return new RIPEMD160.Digest();
        }
        if ("1.3.36.3.2.3".equals(oid)) {
            return new RIPEMD256.Digest();
        }
        if ("1.2.643.2.2.9".equals(oid)) {
            return new GOST3411.Digest();
        }
        throw new NoSuchAlgorithmException(hashAlgorithm);
    }
}

