/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.link.jni;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.link.ICryptoLinkPartSM2;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.logging.LoggerManager;
import cryptokit.jni.JNISDF;

final class CryptoLinkPartSM2Imp
implements ICryptoLinkPartSM2 {
    private static final int PUBLICKEYDATA_LENGTH = 68;
    private static final int PRIVATEKEYDATA_LENGTH = 36;
    private static final int ENCRYPT_LENGTH_MIN = 100;
    private static final int SOURCE_LENGTH_MAX = 8192;
    private static final int HASH_LENGTH_MIN = 20;
    private static final int SIGN_LENGTH = 64;
    private final JNISDF jnisdf;
    private final long warningTimeThreshold;

    CryptoLinkPartSM2Imp(JNISDF jnisdf, long warningTimeThreshold) {
        this.jnisdf = jnisdf;
        this.warningTimeThreshold = warningTimeThreshold;
    }

    public int generateKeyPairSM2(long sessionHandle, int algID, int keyBits, byte[] publicKeyData, byte[] privateKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 generateKeyPairSM2 Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 generateKeyPairSM2 failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 generateKeyPairSM2 failed: param publicKeyData is null/invalid");
        }
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 generateKeyPairSM2 failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 generateKeyPairSM2 failed: param privateKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.generateKeyPairSM2(sessionHandle, algID, keyBits, publicKeyData, privateKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 generateKeyPairSM2 failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpSM2 generateKeyPairSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 generateKeyPairSM2 failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 generateKeyPairSM2 finished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 generateKeyPairSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int exportPublicKeySM2(long sessionHandle, int keyIndex, int algType, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 exportPublicKeySM2 Running: sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType});
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportPublicKeySM2 failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 exportPublicKeySM2 failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportPublicKeySM2(sessionHandle, keyIndex, algType, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportPublicKeySM2 failed, sessionHandle={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algType, e});
            throw new CryptoException("CryptoNativeImpSM2 exportPublicKeySM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportPublicKeySM2 failed, sessionHandle={},returnResult={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algType});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 exportPublicKeySM2 finished, sessionHandle={},returnResult={},costTime={},keyIndex={},algType={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, algType});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 exportPublicKeySM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int exportProtectSM2Key(long sessionHandle, byte[] publicKeyData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 exportProtectKey Running: sessionHandle={}", (Object)NumberHelper.hex(sessionHandle));
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportProtectKey failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 exportProtectKey failed: param publicKeyData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.exportProtectKey(sessionHandle, publicKeyData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportProtectKey failed, sessionHandle={}", (Object)NumberHelper.hex(sessionHandle), (Object)e);
            throw new CryptoException("CryptoNativeImpSM2 exportProtectKey failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 exportProtectKey failed, sessionHandle={},returnResult={}", (Object)NumberHelper.hex(sessionHandle), (Object)NumberHelper.hex(returnResult));
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 exportProtectKey finished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 exportProtectKey accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int importEncryptedSM2KeyPairs(long sessionHandle, int keyIndex, byte[] encryptedKeyCipherData) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 importEncryptedSM2KeyPairs Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        if (encryptedKeyCipherData == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 importEncryptedSM2KeyPairs failed: param encryptedKeyCipherData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 importEncryptedSM2KeyPairs failed: param encryptedKeyCipherData is null/invalid");
        }
        try {
            returnResult = this.jnisdf.importEncryptedSM2KeyPairs(sessionHandle, keyIndex, encryptedKeyCipherData);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 importEncryptedSM2KeyPairs failed, sessionHandle={},keyIndex={},encryptedKeyCipherData={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(encryptedKeyCipherData), e});
            throw new CryptoException("CryptoNativeImpSM2 importEncryptedSM2KeyPairs failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 importEncryptedSM2KeyPairs failed, sessionHandle={},returnResult={},keyIndex={},encryptedKeyCipherData={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(encryptedKeyCipherData)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 importEncryptedSM2KeyPairs finished, sessionHandle={},returnResult={},costTime={},keyIndex={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex});
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 importEncryptedSM2KeyPairs accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalSignSM2(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalSignSM2 Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalSignSM2 failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalSignSM2 failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalSignSM2 failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalSignSM2 failed: param hashLength is invalid");
        }
        if (signOutput == null || signOutput.length < 64) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalSignSM2 failed: param signOutput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalSignSM2 failed: param signOutput is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalSignSM2(sessionHandle, keyIndex, hashInput, hashLength, signOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalSignSM2 failed, sessionHandle={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpSM2 internalSignSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalSignSM2 failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 internalSignSM2 finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalSignSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalSignSM2(long sessionHandle, int algID, byte[] privateKeyData, byte[] hashInput, int hashLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalSignSM2 Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalSignSM2 failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalSignSM2 failed: param privateKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalSignSM2 failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalSignSM2 failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalSignSM2 failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalSignSM2 failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalSignSM2(sessionHandle, algID, privateKeyData, hashInput, hashLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalSignSM2 failed, sessionHandle={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpSM2 externalSignSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalSignSM2 failed, sessionHandle={},returnResult={},algID={},privateKeyDataMD5={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 externalSignSM2 finished, sessionHandle={},returnResult={},costTime={}, algID={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalSignSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalVerifySM2(long sessionHandle, int keyIndex, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalVerifySM2 Running: sessionHandle={},keyIndex={}\uff0chashLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, hashLength});
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalVerifySM2 failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalVerifySM2 failed: param hashInput is null/invalid");
        }
        if (signature == null || signature.length != 64) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalVerifySM2 failed: param signature is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalVerifySM2 failed: param signature is null/invalid");
        }
        try {
            returnResult = this.jnisdf.internalVerifySM2(sessionHandle, keyIndex, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalVerifySM2 failed, sessionHandle={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature), e});
            throw new CryptoException("CryptoNativeImpSM2 internalVerifySM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalVerifySM2 failed, sessionHandle={},returnResult={},keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 internalVerifySM2 finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},hashInput={},hashLength={},signature={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(hashInput), hashLength, Hex.toHexString(signature)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalVerifySM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalVerifySM2(long sessionHandle, int algID, byte[] publicKeyData, byte[] hashInput, int hashLength, byte[] signature) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalVerifySM2 Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalVerifySM2 failed: param publicKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalVerifySM2 failed: param publicKeyData is null/invalid");
        }
        if (hashInput == null || hashInput.length < 20) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalVerifySM2 failed: param hashInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalVerifySM2 failed: param hashInput is null/invalid");
        }
        if (hashInput.length < hashLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalVerifySM2 failed: param hashLength is invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalVerifySM2 failed: param hashLength is invalid");
        }
        try {
            returnResult = this.jnisdf.externalVerifySM2(sessionHandle, algID, publicKeyData, hashInput, hashLength, signature);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalVerifySM2 failed, sessionHandle={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength, e});
            throw new CryptoException("CryptoNativeImpSM2 externalVerifySM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalVerifySM2 failed, sessionHandle={},returnResult={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 externalVerifySM2 failed, sessionHandle={},returnResult={},costTime={},algID={},publicKeyData={},hashInput={},hashLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(publicKeyData), Hex.toHexString(hashInput), hashLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalVerifySM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalEncryptSM2(long sessionHandle, int keyIndex, int algID, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalEncryptSM2 Running: sessionHandle={},keyIndex={}\uff0cdataLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, dataLength});
        if (dataInput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalEncryptSM2 failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 internalEncryptSM2 failed: param dataInput is null/invalid");
        }
        int requiredLength = dataInput.length + 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalEncryptSM2 failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpSM2 internalEncryptSM2 failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.internalEncryptSM2(sessionHandle, keyIndex, algID, dataInput, dataLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalEncryptSM2 failed, sessionHandle={},keyIndex={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algID, Hex.toHexString(dataInput), dataLength, e});
            throw new CryptoException("CryptoNativeImpSM2 internalEncryptSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalEncryptSM2 failed, sessionHandle={},returnResult={},keyIndex={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algID, Hex.toHexString(dataInput), dataLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 internalEncryptSM2 finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(dataInput), dataLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalEncryptSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalEncryptSM2(long sessionHandle, int algID, byte[] publicKeyData, byte[] dataInput, int dataLength, byte[] dataOutput) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalEncryptSM2 Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (publicKeyData == null || publicKeyData.length < 68) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed: param publicKeyData is null");
            throw new CryptoException("CryptoNativeImpSM2 externalEncryptSM2 failed: param publicKeyData is null");
        }
        if (dataInput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataInput is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataInput is null/invalid");
        }
        if (dataLength > 8192 || dataInput.length < dataLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataInput is invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataInput is invalid");
        }
        int requiredLength = dataLength + 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpSM2 externalEncryptSM2 failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.externalEncryptSM2(sessionHandle, algID, publicKeyData, dataInput, dataLength, dataOutput);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed, sessionHandle={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, Hex.toHexString(dataInput), dataLength, e});
            throw new CryptoException("CryptoNativeImpSM2 externalEncryptSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalEncryptSM2 failed, sessionHandle={},returnResult={},algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, Hex.toHexString(dataInput), dataLength});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 externalEncryptSM2 finished, sessionHandle={},returnResult={},costTime={}, algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(dataInput), dataLength});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalEncryptSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int internalDecryptSM2(long sessionHandle, int keyIndex, int algID, byte[] dataInput, byte[] dataOutput, int[] dataOutputLength) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalDecryptSM2 Running: sessionHandle={},keyIndex={}", (Object)NumberHelper.hex(sessionHandle), (Object)keyIndex);
        if (dataInput == null || dataInput.length < 100) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalDecryptSM2 failed: param dataInput is null/not enough space&requiredMinLength={}", (Object)100);
            throw new CryptoException("CryptoNativeImpSM2 internalDecryptSM2 failed: param dataInput is null/not enough length");
        }
        int requiredLength = dataInput.length - 100;
        if (dataOutput == null || dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalDecryptSM2 failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpSM2 internalDecryptSM2 failed: param dataOutput is null/not enough space");
        }
        try {
            returnResult = this.jnisdf.internalDecryptSM2(sessionHandle, keyIndex, algID, dataInput, dataOutput, dataOutputLength);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalDecryptSM2 failed, sessionHandle={},keyIndex={},algID={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), keyIndex, algID, Hex.toHexString(dataInput), e});
            throw new CryptoException("CryptoNativeImpSM2 internalDecryptSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 internalDecryptSM2 failed, sessionHandle={},returnResult={},keyIndex={},algID={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), keyIndex, algID, Hex.toHexString(dataInput)});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 internalDecryptSM2 finished, sessionHandle={},returnResult={},costTime={}, keyIndex={},dataInput={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, keyIndex, Hex.toHexString(dataInput)});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 internalDecryptSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }

    public int externalDecryptSM2(long sessionHandle, int algID, byte[] privateKeyData, byte[] dataInput, byte[] dataOutput, int[] dataOutputLength) throws CryptoException {
        long costTime;
        int returnResult;
        long strTime = System.currentTimeMillis();
        LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalDecryptSM2 Running: sessionHandle={},algID={}", (Object)NumberHelper.hex(sessionHandle), (Object)algID);
        if (privateKeyData == null || privateKeyData.length < 36) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed: param privateKeyData is null/invalid");
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed: param privateKeyData is null/invalid");
        }
        int limitedLength = 8292;
        if (dataInput == null || dataInput.length > 8292) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataInput is null/invalid(limitedLength={})", (Object)8292);
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataInput is null/invalid");
        }
        if (dataOutput == null) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutput is null/not enough space");
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutput is null/not enough space");
        }
        int requiredLength = dataInput.length - 100;
        if (dataOutput.length < requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutput is null/not enough space&requiredLength={}", (Object)requiredLength);
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutput is null/not enough space");
        }
        if (dataOutputLength == null || dataOutputLength.length == 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutputLength is null/length=0");
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed: param dataOutputLength is null/length=0");
        }
        try {
            returnResult = this.jnisdf.externalDecryptSM2(sessionHandle, algID, privateKeyData, dataInput, dataOutput, dataOutputLength);
        }
        catch (Throwable e) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed, sessionHandle={},algID={},privateKeyDataMD5={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length, e});
            throw new CryptoException("CryptoNativeImpSM2 externalDecryptSM2 failed", e);
        }
        if (returnResult != 0) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed, sessionHandle={},returnResult={},algID={},privateKeyDataMD5={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length});
        }
        if (dataOutputLength[0] != requiredLength) {
            LoggerManager.exceptionLogger.error("CryptoNativeImpSM2 externalDecryptSM2 failed, sessionHandle={},algID={},privateKeyDataMD5={},dataInput={},dataLength={},dataOutputLength[0]={}", new Object[]{NumberHelper.hex(sessionHandle), algID, NumberHelper.md5(privateKeyData), Hex.toHexString(dataInput), dataInput.length, dataOutputLength[0]});
        }
        if ((costTime = System.currentTimeMillis() - strTime) > this.warningTimeThreshold) {
            if (LoggerManager.timeoutLogger.isWarnEnabled()) {
                LoggerManager.timeoutLogger.warn("CryptoNativeImpSM2 externalDecryptSM2 finished, sessionHandle={},returnResult={},costTime={}, algID={},dataInput={},dataLength={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime, algID, Hex.toHexString(dataInput), dataInput.length});
            }
        } else {
            LoggerManager.systemLogger.info("CryptoNativeImpSM2 externalDecryptSM2 accomplished, sessionHandle={},returnResult={},costTime={}", new Object[]{NumberHelper.hex(sessionHandle), NumberHelper.hex(returnResult), costTime});
        }
        return returnResult;
    }
}

