/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec;

import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.anssi.ANSSINamedCurves;
import cfca.sadk.org.bouncycastle.asn1.nist.NISTNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.sec.SECNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X962NamedCurves;
import cfca.sadk.org.bouncycastle.asn1.x9.X9ECParameters;

public final class ECCurveParameters {
    private ECCurveParameters() {
    }

    public static X9ECParameters findX9ECParameters(String curveName) {
        X9ECParameters ecP = null;
        if (curveName != null) {
            ecP = X962NamedCurves.getByName(curveName);
            if (ecP == null) {
                ecP = SECNamedCurves.getByName(curveName);
            }
            if (ecP == null) {
                ecP = NISTNamedCurves.getByName(curveName);
            }
            if (ecP == null) {
                ecP = TeleTrusTNamedCurves.getByName(curveName);
            }
            if (ecP == null) {
                ecP = ANSSINamedCurves.getByName(curveName);
            }
        }
        return ecP;
    }

    public static X9ECParameters findX9ECParameters(ASN1ObjectIdentifier curveOid) {
        X9ECParameters ecP = null;
        if (curveOid != null) {
            ecP = X962NamedCurves.getByOID(curveOid);
            if (ecP == null) {
                ecP = SECNamedCurves.getByOID(curveOid);
            }
            if (ecP == null) {
                ecP = NISTNamedCurves.getByOID(curveOid);
            }
            if (ecP == null) {
                ecP = TeleTrusTNamedCurves.getByOID(curveOid);
            }
            if (ecP == null) {
                ecP = ANSSINamedCurves.getByOID(curveOid);
            }
        }
        return ecP;
    }
}

