/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.prf.HashPRF;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfGenerator;
import java.security.GeneralSecurityException;
import java.security.ProviderException;
import javax.crypto.SecretKey;

public final class TlsPrfParameters {
    private final SecretKey secret;
    private final String label;
    private final byte[] seed;
    private final int outputLength;
    private final HashPRF hashPRF;

    public TlsPrfParameters(SecretKey secret, String label, byte[] seed, int outputLength, HashPRF hashPRF) {
        if (label == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notAllowNULL", "label"));
        }
        if (seed == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notAllowNULL", "seed"));
        }
        if (hashPRF == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notAllowNULL", "prfHashParameters"));
        }
        if (outputLength <= 0) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBePositive", "outputLength"));
        }
        this.secret = secret;
        this.label = label;
        this.seed = (byte[])seed.clone();
        this.outputLength = outputLength;
        this.hashPRF = hashPRF;
    }

    public SecretKey getSecret() {
        return this.secret;
    }

    public String getLabel() {
        return this.label;
    }

    public byte[] getSeed() {
        return (byte[])this.seed.clone();
    }

    public int getOutputLength() {
        return this.outputLength;
    }

    public String getPRFHashAlg() {
        return this.hashPRF.prfHashAlg;
    }

    public int getPRFHashLength() {
        return this.hashPRF.prfHashLength;
    }

    public int getPRFBlockSize() {
        return this.hashPRF.prfBlockSize;
    }

    public HashPRF hashPRF() {
        return this.hashPRF;
    }

    public final SecretKey generateKey(boolean newForm) {
        TlsPrfGenerator kg = new TlsPrfGenerator();
        try {
            return kg.generateKey(this, newForm);
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.generateKey"), e);
        }
    }
}

