/*
 * Decompiled with CFR 0.152.
 */
package cfca.seal.maker.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.system.FileHelper;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.HashUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.seal.maker.bean.SignInfo;
import cfca.seal.maker.bean.SignResult;
import cfca.seal.maker.bean.SignSource;
import cfca.seal.maker.bean.SoftSeal;
import cfca.seal.maker.bean.UsbKeySeal;
import cfca.seal.maker.util.EndianUtil;
import cfca.seal.maker.util.WebSealExtracter;
import cfca.seal.maker.util.WebSealUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivateKey;

public class WebSeal {
    private static final long SECONDSPERDAY = 86400L;
    private static X509Cert signerCert;

    public byte[] signWebSeal(SignResult signResult, byte[] source, String pfxPassword) throws Exception {
        SignInfo signInfo = signResult.getSignInfo();
        SoftSeal softSeal = new SoftSeal(signResult.getUsbKeySeal(), signInfo.getVersion());
        SignSource signSource = new SignSource(softSeal, signInfo, source);
        byte[] signData = this.signResult(signSource, pfxPassword);
        return this.generateSignedResult(signSource, signData);
    }

    public static void main(String[] args) throws Exception {
        byte[] sealSource = FileHelper.read((String)"TestData/sm2-test.seal");
        byte[] pngData = FileHelper.read((String)"TestData/1.png");
        SignResult signResult = WebSealUtil.getSignResultFromSeal(sealSource, "123123", "123123", pngData, "beijing", "signreason");
        WebSeal webSeal = new WebSeal();
        byte[] signBytes = webSeal.signWebSeal(signResult, "cfca".getBytes(Charset.forName("UTF8")), "123123");
    }

    public byte[] signWebSeal(SignResult signResult, byte[] source, byte[] signData, boolean isRSA) throws Exception {
        SignInfo signInfo = signResult.getSignInfo();
        SoftSeal softSeal = new SoftSeal(signResult.getUsbKeySeal(), signInfo.getVersion());
        SignSource signSource = new SignSource(softSeal, signInfo, source);
        return this.generateSignedResult(signSource, signData, isRSA);
    }

    public boolean verifyWebSeal(String base64SignedData, byte[] source) throws Exception {
        Signature signature = new Signature();
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session session = JCrypto.getInstance().openSession("JSOFT_LIB");
        WebSealExtracter webSealExtracter = new WebSealExtracter(base64SignedData, source);
        boolean ret = signature.p7VerifyMessageDetach(webSealExtracter.getSourceData(), webSealExtracter.getP7SourceData(), session);
        signerCert = signature.getSignerCert();
        return ret;
    }

    public X509Cert getSignerCert() {
        return signerCert;
    }

    public byte[] generateSignedResult(SignSource signSource, byte[] signData, boolean isRSA) throws Exception {
        SoftSeal softSeal = signSource.getSoftSeal();
        UsbKeySeal usbKeySeal = softSeal.getUsbKeySeal();
        SignInfo signInfo = signSource.getSignInfo();
        byte[] usbKeyData = this.generateUSBKeyData(usbKeySeal);
        byte[] signMessage = this.generateSignedInfo(signInfo);
        byte[] signLenData = EndianUtil.intToBytes(signData.length);
        int totalLength = usbKeyData.length + signMessage.length + signData.length + 4;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(signSource.getSignID().getBytes("UTF-8"));
        baos.write(EndianUtil.intToBytes(totalLength));
        baos.write(usbKeyData);
        baos.write(signMessage);
        baos.write(EndianUtil.intToBytes(signData.length));
        baos.write(signData);
        byte[] totalData = new byte[totalLength];
        System.arraycopy(usbKeyData, 0, totalData, 0, usbKeyData.length);
        System.arraycopy(signMessage, 0, totalData, usbKeyData.length, signMessage.length);
        System.arraycopy(signLenData, 0, totalData, signMessage.length + usbKeyData.length, signLenData.length);
        System.arraycopy(signData, 0, totalData, 4 + signMessage.length + usbKeyData.length, signData.length);
        byte[] hash = null;
        if (isRSA) {
            hash = HashUtil.RSAHashMessageByBC((byte[])totalData, (Mechanism)new Mechanism("SHA-1"), (boolean)false);
        } else {
            hash = new byte[32];
            SM3Digest digest = new SM3Digest();
            digest.update(totalData, 0, totalData.length);
            digest.doFinal(hash, 0);
        }
        baos.write(hash);
        return Base64.encode((byte[])baos.toByteArray());
    }

    public byte[] generateSignedResult(SignSource signSource, byte[] signData) throws Exception {
        SoftSeal softSeal = signSource.getSoftSeal();
        UsbKeySeal usbKeySeal = softSeal.getUsbKeySeal();
        int keyType = WebSealUtil.getKeyStoreType(usbKeySeal.getPfxData());
        return this.generateSignedResult(signSource, signData, keyType == 1);
    }

    public byte[] signResult(SignSource signSource, String pfxPWD) throws Exception {
        JCrypto.getInstance().initialize("JSOFT_LIB", null);
        Session jsoft_session = JCrypto.getInstance().openSession("JSOFT_LIB");
        Signature util = new Signature();
        SoftSeal softSeal = signSource.getSoftSeal();
        UsbKeySeal usbKeySeal = softSeal.getUsbKeySeal();
        byte[] sourceData = this.generateSignedSource(signSource);
        byte[] signData = null;
        int keyType = WebSealUtil.getKeyStoreType(usbKeySeal.getPfxData());
        if (keyType == 1) {
            X509Cert cert = CertUtil.getCertFromPFX((byte[])usbKeySeal.getPfxData(), (String)pfxPWD);
            PrivateKey key = KeyUtil.getPrivateKeyFromPFX((byte[])usbKeySeal.getPfxData(), (String)pfxPWD);
            signData = util.p7SignMessageDetach("sha1WithRSAEncryption", sourceData, key, cert, jsoft_session);
        } else if (keyType == 2) {
            X509Cert cert = CertUtil.getCertFromSM2((byte[])usbKeySeal.getPfxData());
            SM2PrivateKey key = KeyUtil.getPrivateKeyFromSM2((byte[])usbKeySeal.getPfxData(), (String)pfxPWD);
            signData = util.p7SignMessageDetach("sm3WithSM2Encryption", sourceData, (PrivateKey)key, cert, jsoft_session);
        }
        signData = Base64.decode(signData);
        return signData;
    }

    public byte[] generateSignedSource(SignSource signSource) throws IOException {
        ByteArrayOutputStream os = null;
        UsbKeySeal usbKeySeal = signSource.getSoftSeal().getUsbKeySeal();
        SignInfo signInfo = signSource.getSignInfo();
        os = new ByteArrayOutputStream();
        byte[] usbKeyData = this.generateUSBKeyData(usbKeySeal);
        byte[] signMessage = this.generateSignedInfo(signInfo);
        byte[] sourceData = signSource.getSource();
        int sourceLength = sourceData.length;
        int totalLength = usbKeyData.length + signMessage.length + 4 + sourceLength;
        os.write(EndianUtil.intToBytes(totalLength));
        os.write(usbKeyData);
        os.write(signMessage);
        os.write(EndianUtil.intToBytes(sourceLength));
        os.write(sourceData);
        byte[] temp = os.toByteArray();
        byte[] signSealSource = new byte[totalLength + 4];
        System.arraycopy(temp, 0, signSealSource, 0, totalLength + 4);
        return signSealSource;
    }

    public byte[] generateSignedInfo(SignInfo signInfo) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] signReasonData = signInfo.getSignReason().getBytes("UTF-8");
        byte[] signLocationData = signInfo.getSignLocation().getBytes("UTF-8");
        int signLocationLength = signLocationData.length;
        int signReasonLength = signReasonData.length;
        int totalLength = 20 + signLocationLength + signReasonLength;
        baos.write(EndianUtil.intToBytes(totalLength));
        baos.write(signInfo.getVersion());
        baos.write(EndianUtil.doubleToByte((double)signInfo.getSignTime() / 86400.0));
        baos.write(EndianUtil.intToBytes(signLocationLength));
        baos.write(signLocationData);
        baos.write(EndianUtil.intToBytes(signReasonLength));
        baos.write(signReasonData);
        byte[] temp = baos.toByteArray();
        byte[] signMessage = new byte[totalLength + 4];
        System.arraycopy(temp, 0, signMessage, 0, totalLength + 4);
        return signMessage;
    }

    public byte[] generateUSBKeyData(UsbKeySeal usbKeySeal) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int len = usbKeySeal.getPngData().length;
        baos.write(EndianUtil.intToBytes(len));
        baos.write(usbKeySeal.getPngData());
        byte[] signerData = usbKeySeal.getSignerName().getBytes("UTF-8");
        baos.write(EndianUtil.intToBytes(signerData.length));
        baos.write(signerData);
        byte[] unitData = usbKeySeal.getUnitName().getBytes("UTF-8");
        baos.write(EndianUtil.intToBytes(unitData.length));
        baos.write(unitData);
        byte[] sealNameData = usbKeySeal.getSealName().getBytes("UTF-8");
        baos.write(EndianUtil.intToBytes(sealNameData.length));
        baos.write(sealNameData);
        byte[] subjectData = usbKeySeal.getSubjectName().getBytes("UTF-8");
        baos.write(EndianUtil.intToBytes(subjectData.length));
        baos.write(subjectData);
        baos.write(EndianUtil.doubleToByte((double)usbKeySeal.getStartValidTime() / 86400.0));
        baos.write(EndianUtil.doubleToByte((double)usbKeySeal.getEndValidTime() / 86400.0));
        byte[] before_temp = baos.toByteArray();
        len = before_temp.length;
        byte[] after_temp = new byte[len + 4];
        byte[] len_data = EndianUtil.intToBytes(len);
        System.arraycopy(len_data, 0, after_temp, 0, len_data.length);
        System.arraycopy(before_temp, 0, after_temp, 4, len);
        return after_temp;
    }
}

