/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.ofd.base.font;

import cfca.com.google.typography.font.sfntly.Font;
import cfca.com.google.typography.font.sfntly.FontFactory;
import cfca.com.google.typography.font.sfntly.Tag;
import cfca.com.google.typography.font.sfntly.table.core.NameTable;
import cfca.com.google.typography.font.tools.sfnttool.SfntTool;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.ofd.base.common.StringUtil;
import cfca.sadk.ofd.base.exception.SealException;
import cfca.sadk.ofd.util.SysEnv;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;

public class FontUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FontUtil.class);
    private Map<String, Font> fontsMap = new ConcurrentHashMap<String, Font>();
    private static FontUtil instance = new FontUtil();

    private FontUtil() {
    }

    public static FontUtil getInstance() throws SealException {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadFonts(String fontPath) throws SealException, IOException {
        boolean hasCorrectFont = false;
        if (this.fontsMap.size() > SysEnv.getMaxFont() * 2) throw new SealException("More than " + SysEnv.getMaxFont() + " font type is loaded! Invoke SysEnv.setMaxFont() to support more font type.");
        FontFactory fontFactory = FontFactory.getInstance();
        if (null == fontPath) throw new SealException("fontPath is null!");
        File dir = new File(fontPath);
        if (null == dir || !dir.isDirectory()) throw new SealException("fontPath is wrong!");
        File[] fontFiles = dir.listFiles();
        for (int i = 0; i < fontFiles.length; ++i) {
            String fontFileName = fontFiles[i].getName().toLowerCase();
            if (!fontFileName.endsWith(".ttf") && !fontFileName.endsWith(".otf")) continue;
            try {
                if (this.fontsMap.size() > SysEnv.getMaxFont() * 2) continue;
                Font[] fontArray = null;
                byte[] fontBytes = FileUtils.readFileToByteArray((File)fontFiles[i]);
                fontArray = fontFactory.loadFonts(fontBytes);
                Font font = fontArray[0];
                String fontName = this.getFontName(font);
                if (StringUtil.isEmpty(fontName)) {
                    fontName = fontFileName;
                }
                this.fontsMap.put(fontName, font);
                this.fontsMap.put(fontName.toLowerCase(), font);
                fontBytes = null;
                hasCorrectFont = true;
                continue;
            }
            catch (Exception e) {
                businessLog.error(fontFileName + " has error!", (Throwable)e);
            }
        }
        businessLog.info("loat fonts: " + this.fontsMap.keySet());
        if (hasCorrectFont) return;
        throw new SealException("no font loaded,file type need ttf or otf format!");
    }

    public List<String> getSubSetFont(String fontName, String subsetString, OutputStream output) throws SealException, IOException {
        SfntTool tool = new SfntTool();
        tool.setSubsetString(subsetString);
        Font font = this.fontsMap.get(fontName);
        if (font != null) {
            HashMap<String, List<Integer>> glyphs = tool.subsetFontFile(font, output);
            return this.getGlyphOrder(glyphs);
        }
        throw new SealException("fontName = " + fontName + " is not found!");
    }

    public Set<String> getFontNames() {
        return this.fontsMap.keySet();
    }

    private String getFontName(Font font) {
        NameTable name = (NameTable)font.getTable(Tag.name);
        for (NameTable.NameEntry entry : name) {
            if (entry.nameId() != NameTable.NameId.FontFamilyName.value()) continue;
            for (NameTable.NameEntry entry2 : name) {
                if (entry2.nameId() != NameTable.NameId.FullFontName.value() || entry.platformId() != entry2.platformId() || entry.encodingId() != entry2.encodingId() || entry.languageId() != entry2.languageId()) continue;
                return entry2.name();
            }
        }
        return null;
    }

    private List<String> getGlyphOrder(HashMap<String, List<Integer>> glyphs) {
        List<Integer> originGlyphs = glyphs.get("originGlyphs");
        List<Integer> sortedGlyphs = glyphs.get("sortedGlyphs");
        ArrayList<String> sortedGlyph = new ArrayList<String>();
        block0: for (int i = 0; i < originGlyphs.size(); ++i) {
            Integer glyph = originGlyphs.get(i);
            for (int j = 0; j < sortedGlyphs.size(); ++j) {
                Integer newGlyph = sortedGlyphs.get(j);
                if (glyph.compareTo(newGlyph) != 0) continue;
                sortedGlyph.add(String.valueOf(j));
                continue block0;
            }
        }
        return sortedGlyph;
    }
}

