/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.message;

import cfca.sadk.tls.sun.security.ssl.DistinguishedName;
import cfca.sadk.tls.sun.security.ssl.HandshakeInStream;
import cfca.sadk.tls.sun.security.ssl.HandshakeOutStream;
import cfca.sadk.tls.sun.security.ssl.ProtocolVersion;
import cfca.sadk.tls.sun.security.ssl.message.HandshakeMessage;
import cfca.sadk.tls.sun.security.ssl.sec.KeyExchangeAlgorithm;
import cfca.sadk.tls.sun.security.ssl.sec.SignatureAndHashAlgorithm;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;

public final class CertificateRequest
extends HandshakeMessage {
    public static final int cct_rsa_sign = 1;
    public static final int cct_ecdsa_sign = 64;
    public static final int cct_ibc_params = 80;
    private static final byte[] TYPES_ECC = new byte[]{1, 64};
    public byte[] types;
    DistinguishedName[] authorities;
    ProtocolVersion protocolVersion;
    private Collection<SignatureAndHashAlgorithm> algorithms;
    private int algorithmsLen;

    public CertificateRequest(X509Certificate[] ca, KeyExchangeAlgorithm keyExchange, Collection<SignatureAndHashAlgorithm> signAlgs, ProtocolVersion protocolVersion) throws IOException {
        this.protocolVersion = protocolVersion;
        this.authorities = new DistinguishedName[ca.length];
        for (int i = 0; i < ca.length; ++i) {
            X500Principal x500Principal = ca[i].getSubjectX500Principal();
            this.authorities[i] = new DistinguishedName(x500Principal);
        }
        this.types = TYPES_ECC;
        if (protocolVersion.isStandardTLS12()) {
            if (signAlgs == null || signAlgs.isEmpty()) {
                throw new SSLProtocolException("No supported signature algorithms");
            }
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>(signAlgs);
            this.algorithmsLen = SignatureAndHashAlgorithm.sizeInRecord() * this.algorithms.size();
        } else {
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
            this.algorithmsLen = 0;
        }
    }

    public CertificateRequest(HandshakeInStream in, ProtocolVersion protocolVersion) throws IOException {
        int len;
        DistinguishedName dn;
        this.protocolVersion = protocolVersion;
        this.types = in.getBytes8();
        if (protocolVersion.isStandardTLS12()) {
            int remains;
            this.algorithmsLen = in.getInt16();
            if (this.algorithmsLen < 2) {
                throw new SSLProtocolException("Invalid supported_signature_algorithms field");
            }
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
            int sequence = 0;
            for (remains = this.algorithmsLen; remains > 1; remains -= 2) {
                int hash = in.getInt8();
                int signature = in.getInt8();
                this.algorithms.add(SignatureAndHashAlgorithm.valueOf(hash, signature, ++sequence));
            }
            if (remains != 0) {
                throw new SSLProtocolException("Invalid supported_signature_algorithms field");
            }
        } else {
            this.algorithms = new ArrayList<SignatureAndHashAlgorithm>();
            this.algorithmsLen = 0;
        }
        ArrayList<DistinguishedName> v = new ArrayList<DistinguishedName>();
        for (len = in.getInt16(); len >= 3; len -= dn.length()) {
            dn = new DistinguishedName(in);
            v.add(dn);
        }
        if (len != 0) {
            throw new SSLProtocolException("Bad CertificateRequest DN length");
        }
        this.authorities = v.toArray(new DistinguishedName[v.size()]);
    }

    public X500Principal[] getAuthorities() throws IOException {
        X500Principal[] ret = new X500Principal[this.authorities.length];
        for (int i = 0; i < this.authorities.length; ++i) {
            ret[i] = this.authorities[i].getX500Principal();
        }
        return ret;
    }

    public Collection<SignatureAndHashAlgorithm> getSignAlgorithms() {
        return this.algorithms;
    }

    @Override
    public int messageType() {
        return 13;
    }

    @Override
    int messageLength() {
        int len = 1 + this.types.length + 2;
        if (this.protocolVersion.isStandardTLS12()) {
            len += this.algorithmsLen + 2;
        }
        for (int i = 0; i < this.authorities.length; ++i) {
            len += this.authorities[i].length();
        }
        return len;
    }

    @Override
    void send(HandshakeOutStream out) throws IOException {
        int i;
        out.putBytes8(this.types);
        if (this.protocolVersion.isStandardTLS12()) {
            out.putInt16(this.algorithmsLen);
            for (SignatureAndHashAlgorithm algorithm : this.algorithms) {
                out.putInt8(algorithm.getHashValue());
                out.putInt8(algorithm.getSignatureValue());
            }
        }
        int len = 0;
        for (i = 0; i < this.authorities.length; ++i) {
            len += this.authorities[i].length();
        }
        out.putInt16(len);
        for (i = 0; i < this.authorities.length; ++i) {
            this.authorities[i].write(out);
        }
    }

    public String toString() {
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append('\n');
        builder.append("*** CertificateRequest");
        builder.append("Cert Types: ");
        for (i = 0; i < this.types.length; ++i) {
            switch (this.types[i]) {
                case 1: {
                    builder.append("RSA");
                    break;
                }
                case 64: {
                    builder.append("ECDSA");
                    break;
                }
                case 80: {
                    builder.append("IBC Params");
                    break;
                }
                default: {
                    builder.append("Type-" + (this.types[i] & 0xFF));
                }
            }
            if (i == this.types.length - 1) continue;
            builder.append(", ");
        }
        builder.append('\n');
        if (this.protocolVersion.isStandardTLS12()) {
            builder.append('\n');
            builder.append("Supported Signature Algorithms: ");
            boolean opened = false;
            for (SignatureAndHashAlgorithm signAlg : this.algorithms) {
                if (signAlg == null) continue;
                if (opened) {
                    builder.append(", ");
                } else {
                    opened = true;
                }
                builder.append(signAlg.getAlgorithmName());
            }
        }
        builder.append('\n');
        builder.append("Cert Authorities:");
        if (this.authorities.length == 0) {
            builder.append('\n');
            builder.append("<Empty>");
        } else {
            for (i = 0; i < this.authorities.length; ++i) {
                builder.append(this.authorities[i]);
            }
        }
        builder.append("\n***");
        return builder.toString();
    }
}

