/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.annot;

import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfName;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;

public class PdfPolyGeomAnnotation
extends PdfMarkupAnnotation {
    private static final long serialVersionUID = -9038993253308315792L;
    public static final PdfName Polygon = PdfName.Polygon;
    public static final PdfName PolyLine = PdfName.PolyLine;

    public PdfPolyGeomAnnotation(Rectangle rect, PdfName subtype, float[] vertices) {
        super(rect);
        this.setSubtype(subtype);
        this.setVertices(vertices);
    }

    public PdfPolyGeomAnnotation(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfPolyGeomAnnotation createPolygon(Rectangle rect, float[] vertices) {
        return new PdfPolyGeomAnnotation(rect, Polygon, vertices);
    }

    public static PdfPolyGeomAnnotation createPolyLine(Rectangle rect, float[] vertices) {
        return new PdfPolyGeomAnnotation(rect, PolyLine, vertices);
    }

    @Override
    public PdfName getSubtype() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
    }

    public PdfArray getVertices() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.Vertices);
    }

    public PdfPolyGeomAnnotation setVertices(PdfArray vertices) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, vertices);
    }

    public PdfPolyGeomAnnotation setVertices(float[] vertices) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Vertices, new PdfArray(vertices));
    }

    public PdfArray getLineEndingStyles() {
        return ((PdfDictionary)this.getPdfObject()).getAsArray(PdfName.LE);
    }

    public PdfPolyGeomAnnotation setLineEndingStyles(PdfArray lineEndingStyles) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.LE, lineEndingStyles);
    }

    public PdfDictionary getMeasure() {
        return ((PdfDictionary)this.getPdfObject()).getAsDictionary(PdfName.Measure);
    }

    public PdfPolyGeomAnnotation setMeasure(PdfDictionary measure) {
        return (PdfPolyGeomAnnotation)this.put(PdfName.Measure, measure);
    }

    private void setSubtype(PdfName subtype) {
        this.put(PdfName.Subtype, subtype);
    }
}

