/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.x509.certificate.CRLLengths;
import cfca.sadk.x509.certificate.CRLRecord;
import java.io.IOException;
import java.util.HashSet;

final class CRLFindResult {
    final int offset;
    final boolean isRevoke;

    CRLFindResult(int offset, boolean isRevoke) {
        this.offset = offset;
        this.isRevoke = isRevoke;
    }

    static CRLFindResult findBlock(byte[] encoding, int beginIndex, int endIndex, byte[] certsn) throws IOException {
        boolean isRevoke = false;
        CRLLengths crlLengths = null;
        while (beginIndex < encoding.length - 10) {
            crlLengths = CRLLengths.buildLengthsFrom(encoding, beginIndex, 0);
            if (crlLengths.asn1Length > endIndex - beginIndex) break;
            if (crlLengths.asn1Length > 4 + certsn.length && CRLFindResult.contains(encoding, beginIndex, crlLengths, certsn)) {
                isRevoke = true;
                break;
            }
            beginIndex += crlLengths.asn1Length;
        }
        return new CRLFindResult(beginIndex, isRevoke);
    }

    static int loadBlock(byte[] encoding, int beginIndex, int endIndex, HashSet values) throws IOException {
        CRLLengths crlLengths = null;
        byte[] value = null;
        while (beginIndex < encoding.length - 10) {
            crlLengths = CRLLengths.buildLengthsFrom(encoding, beginIndex, 0);
            if (crlLengths.asn1Length > endIndex - beginIndex) break;
            if (crlLengths.asn1Length > 4 && (value = CRLFindResult.certsnFrom(encoding, beginIndex, crlLengths)) != null) {
                values.add(new CRLRecord(value));
            }
            beginIndex += crlLengths.asn1Length;
        }
        return beginIndex;
    }

    static byte[] certsnFrom(byte[] encoding, int offset, CRLLengths crlLengths) {
        byte[] certsn = null;
        try {
            CRLLengths lengths = CRLLengths.buildLengthsFrom(encoding, offset += crlLengths.headLength, 0);
            certsn = new byte[lengths.valueLength];
            System.arraycopy(encoding, offset += lengths.headLength, certsn, 0, certsn.length);
        }
        catch (Exception e) {
            certsn = null;
        }
        return certsn;
    }

    static boolean contains(byte[] encoding, int offset, CRLLengths crlLengths, byte[] certsn) {
        boolean isRevoke;
        block3: {
            isRevoke = false;
            try {
                CRLLengths lengths = CRLLengths.buildLengthsFrom(encoding, offset += crlLengths.headLength, 0);
                offset += lengths.headLength;
                if (certsn.length != lengths.valueLength) break block3;
                isRevoke = true;
                for (int i = 0; i < certsn.length; ++i) {
                    if (certsn[i] == encoding[offset++]) continue;
                    isRevoke = false;
                    break;
                }
            }
            catch (Exception e) {
                isRevoke = false;
            }
        }
        return isRevoke;
    }
}

