/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.timestamp.client.bean;

public enum PKIFailureInfo {
    badAlg(0, "unrecognized or unsupported Algorithm Identifier", 128),
    badRequest(2, "transaction not permitted or supported", 32),
    badDataFormat(5, "the data submitted has the wrong format", 4),
    timeNotAvailable(14, "the TSA's time source is not available", 512),
    unacceptedPolicy(15, "the requested TSA policy is not supported by the TSA", 256),
    unacceptedExtension(16, "the requested extension is not supported by the TSA", 0x800000),
    addInfoNotAvailable(17, "the additional information requested could not be understood or is not available", 0x400000),
    systemFailure(25, "the request cannot be handled due to system failure", 0x40000000);

    public final int no;
    public final String info;
    public final int value;

    private PKIFailureInfo(int no, String info, int value) {
        this.no = no;
        this.info = info;
        this.value = value;
    }

    public static final PKIFailureInfo find(int failValue) {
        PKIFailureInfo[] values = PKIFailureInfo.values();
        PKIFailureInfo pkiFailureInfo = null;
        for (PKIFailureInfo failInfo : values) {
            if (failInfo.value != failValue) continue;
            pkiFailureInfo = failInfo;
            break;
        }
        return pkiFailureInfo;
    }

    public String toString() {
        String name = super.toString();
        return String.format("%d-%-24s: 0x%s-%s", this.no, name, Integer.toHexString(this.value), this.info);
    }
}

