/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfButtonFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.forms.fields.PdfTextFormField;
import cfca.sadk.com.itextpdf.io.source.ByteArrayOutputStream;
import cfca.sadk.com.itextpdf.kernel.color.Color;
import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfArray;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDictionary;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfIndirectReference;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfObject;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfPage;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfString;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.pdf.StampingProperties;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import cfca.sadk.com.itextpdf.kernel.pdf.annot.PdfWidgetAnnotation;
import cfca.sadk.com.itextpdf.layout.Document;
import cfca.sadk.com.itextpdf.layout.border.Border;
import cfca.sadk.com.itextpdf.layout.element.Cell;
import cfca.sadk.com.itextpdf.layout.element.Paragraph;
import cfca.sadk.com.itextpdf.layout.element.Table;
import cfca.sadk.com.itextpdf.layout.property.VerticalAlignment;
import cfca.sadk.seal.base.bean.form.CheckBoxCellRender;
import cfca.sadk.seal.base.bean.form.FormFieldInfo;
import cfca.sadk.seal.base.bean.form.RadioCellRenderer;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.FontUtil;
import cfca.sadk.seal.base.util.FontsFactory;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.base.util.UCS4FontUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormFieldUtil {
    private static Logger businessLog = LoggerFactory.getLogger(FormFieldUtil.class);
    public static final String CHECKBOXSTATE_ON = "Yes";
    public static final String CHECKBOXSTATE_OFF = "Off";
    public static final String PAGENUM = "pageNum";
    public static final String RECTANGLE = "rectangle";
    public static final String FIELDNAME = "fieldName";
    public static final String PAGEHEIGHT = "pageHeight";

    public static Map<String, PdfFormField> getAllFields(byte[] sourceData) throws SealException {
        if (sourceData == null || sourceData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(sourceData);
            return FormFieldUtil.getAllFields(reader);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static Map<String, PdfFormField> getAllFields(InputStream inputStream) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            return FormFieldUtil.getAllFields(reader);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed:", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static List<String> getTextFormFields(byte[] pdfData) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            List<String> resultList = FormFieldUtil.getTextFormFields(new PdfReader(pdfData));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static List<Map<String, Object>> getTextFormFieldsWithKids(byte[] pdfData) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            List<Map<String, Object>> resultList = FormFieldUtil.getTextFormFieldsInfo(new PdfReader(pdfData));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static List<String> getTextFormFields(InputStream inputStream) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            List<String> resultList = FormFieldUtil.getTextFormFields(new PdfReader(inputStream));
            return resultList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, null);
    }

    public static void fillTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(inputStream, null, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    public static byte[] fillTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException) throws SealException {
        return FormFieldUtil.fillTextFormField(pdfData, null, formFieldInfoList, flattenFields, isThrowNoFieldException, false, null);
    }

    public static byte[] fillTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        return FormFieldUtil.fillTextFormField(pdfData, null, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    public static void fillAndCheckTextFormField(InputStream inputStream, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException, IOException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        PdfReader reader = new PdfReader(inputStream);
        FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, null);
    }

    public static byte[] fillAndCheckTextFormField(byte[] pdfData, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException {
        if (pdfData == null || pdfData.length == 0) {
            throw new SealException("pdfData is null");
        }
        try {
            PdfReader reader = new PdfReader(pdfData);
            return FormFieldUtil.fillTextFormField(reader, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired);
        }
        catch (SealException e) {
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            throw new SealException("getAllFields failed", e);
        }
    }

    public static byte[] fillCheckBox(byte[] sourceData, Map<String, String> checkBoxMap, boolean isThrowException) throws SealException {
        businessLog.info("fillCheckBox begin...");
        byte[] resultPdf = null;
        PdfDocument pdfDoc = null;
        boolean isflattenFields = false;
        try {
            PdfReader reader = new PdfReader(sourceData);
            ByteArrayOutputStream os = new ByteArrayOutputStream(sourceData.length + 8192);
            pdfDoc = new PdfDocument(reader, new PdfWriter(os), new StampingProperties(), false);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Map<String, PdfFormField> formFields = form.getFormFields();
            if (checkBoxMap != null && checkBoxMap.size() > 0) {
                for (String key : checkBoxMap.keySet()) {
                    PdfFormField pdfFormField = formFields.get(key);
                    if (null != pdfFormField && pdfFormField instanceof PdfButtonFormField) {
                        String state = checkBoxMap.get(key);
                        if (CHECKBOXSTATE_ON.equals(state) || CHECKBOXSTATE_OFF.equals(state)) {
                            ((PdfButtonFormField)pdfFormField).setValue(state);
                            ((PdfButtonFormField)pdfFormField).setBorderWidth(1.0f);
                            form.partialFormFlattening(key);
                            isflattenFields = true;
                            continue;
                        }
                        throw new SealException("checkBox key=" + key + " value=" + state + " is wrong,please use FormFieldUtil.CHECKBOXSTATE_ON or FormFieldUtil.CHECKBOXSTATE_OFF for value");
                    }
                    if (!isThrowException) continue;
                    throw new SealException("checkBox key=" + key + " is not exists");
                }
                if (isflattenFields) {
                    form.flattenFields();
                }
            }
            pdfDoc.close();
            resultPdf = os.toByteArray();
        }
        catch (SealException e) {
            businessLog.error("fillCheckBox failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("fillCheckBox failed", (Throwable)e);
            throw new SealException("fillCheckBox failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
            businessLog.info("fillCheckBox end...");
        }
        return resultPdf;
    }

    public static boolean[] haveFields(InputStream inputStream, String[] fields) throws IOException, SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (fields == null) {
            throw new SealException("fields is null");
        }
        return FormFieldUtil.haveFields(new PdfReader(inputStream), fields);
    }

    public static boolean[] haveFields(byte[] pdfData, String[] fields) throws IOException, SealException {
        if (pdfData == null) {
            throw new SealException("pdfData is null");
        }
        if (fields == null) {
            throw new SealException("fields is null");
        }
        return FormFieldUtil.haveFields(new PdfReader(pdfData), fields);
    }

    public static void addTextFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        if (formFieldInfo == null) {
            throw new SealException("formFieldInfo is null");
        }
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Rectangle rect = formFieldInfo.getRect();
            String filedName = formFieldInfo.getFieldName();
            String defaultValue = formFieldInfo.getTextValue();
            int pageNum = formFieldInfo.getPageNum();
            PdfFont font = formFieldInfo.getFont();
            float fontSize = formFieldInfo.getFontSize();
            boolean multiline = formFieldInfo.isMultiline();
            PdfTextFormField field = PdfFormField.createText(pdfDoc, rect, filedName, defaultValue, font, fontSize, multiline);
            form.addField(field, pdfDoc.getPage(pageNum));
            pdfDoc.close();
        }
        catch (IOException e) {
            businessLog.error("addTextFormField failed:" + formFieldInfo.toString());
            throw new SealException("addTextFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static void addCheckBoxFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            Document doc = new Document(pdfDoc);
            Rectangle rect = formFieldInfo.getRect();
            int pageNum = formFieldInfo.getPageNum();
            List<String> descList = formFieldInfo.getRadioList();
            int columns = descList.size();
            Table table = new Table(columns * 2);
            for (int i = 0; i < columns; ++i) {
                String cellValue = descList.get(i);
                Cell cell = new Cell();
                cell.setBorder(Border.NO_BORDER);
                cell.setNextRenderer(new CheckBoxCellRender(cell, "checkbox" + i, cellValue));
                table.addCell(cell);
                cell = new Cell().add(new Paragraph(cellValue));
                cell.setBorder(Border.NO_BORDER);
                table.addCell(cell);
            }
            table.setHeight(rect.getHeight() / 2.0f);
            table.setMargin(0.0f);
            table.setFont(FontUtil.getInstance().createPdfFont());
            table.setFontColor(Color.RED);
            table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
            table.setPageNumber(pageNum);
            table.setVerticalAlignment(VerticalAlignment.MIDDLE);
            doc.add(table);
            doc.close();
        }
        catch (SealException e) {
            businessLog.error("addCheckBoxFormField failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("addCheckBoxFormField failed:" + formFieldInfo.toString());
            throw new SealException("addCheckBoxFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    public static void addRadioFormField(InputStream inputStream, OutputStream outputStream, FormFieldInfo formFieldInfo) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            pdfDoc = new PdfDocument(new PdfReader(inputStream), new PdfWriter(outputStream));
            Document doc = new Document(pdfDoc);
            Rectangle rect = formFieldInfo.getRect();
            int pageNum = formFieldInfo.getPageNum();
            String groupName = formFieldInfo.getGroupName();
            String defaultSelectName = formFieldInfo.getDefaultRadioValue();
            List<String> descList = formFieldInfo.getRadioList();
            PdfButtonFormField radioGroup = PdfFormField.createRadioGroup(pdfDoc, groupName, defaultSelectName);
            int columns = descList.size();
            Table table = new Table(columns * 2);
            for (int i = 0; i < columns; ++i) {
                String cellValue = descList.get(i);
                Cell cell = new Cell();
                cell.setBorder(Border.NO_BORDER);
                cell.setNextRenderer(new RadioCellRenderer(cell, radioGroup, cellValue));
                table.addCell(cell);
                cell = new Cell().add(new Paragraph(cellValue));
                cell.setBorder(Border.NO_BORDER);
                table.addCell(cell);
            }
            table.setHeight(rect.getHeight() / 2.0f);
            table.setMargin(0.0f);
            table.setFont(formFieldInfo.getFont());
            table.setFixedPosition(rect.getX(), rect.getY(), rect.getWidth());
            doc.add(table);
            PdfAcroForm.getAcroForm(pdfDoc, true).addField(radioGroup, pdfDoc.getPage(pageNum));
            doc.close();
        }
        catch (Exception e) {
            businessLog.error("addRadioFormField failed:" + formFieldInfo.toString());
            throw new SealException("addRadioFormField failed", e);
        }
        finally {
            if (pdfDoc != null) {
                pdfDoc.close();
            }
        }
    }

    private static void fillTextFormField(InputStream inputStream, byte[] openPassword, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        businessLog.info("fillTextFormField begin...");
        if (inputStream == null) {
            throw new SealException("inputStream is null");
        }
        try {
            PdfReader reader = new PdfReader(inputStream);
            if (null != openPassword) {
                reader.setOpenPassword(openPassword);
            }
            FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
        }
        catch (SealException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw new SealException("fillTextFormField failed", e);
        }
        finally {
            businessLog.info("fillTextFormField end...");
        }
    }

    private static byte[] fillTextFormField(byte[] pdfData, byte[] openPassword, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        businessLog.info("fillTextFormField begin...");
        if (pdfData == null) {
            throw new SealException("pdfData is null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(pdfData.length + 8192);
        byte[] distPdfData = null;
        try {
            PdfReader reader = new PdfReader(pdfData);
            if (null != openPassword) {
                reader.setOpenPassword(openPassword);
            }
            FormFieldUtil.fillTextFormField(reader, (OutputStream)outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, allFont);
            byte[] byArray = distPdfData = outputStream.toByteArray();
            return byArray;
        }
        catch (SealException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw new SealException("fillTextFormField failed", e);
        }
        finally {
            try {
                outputStream.reset();
                outputStream.close();
                outputStream = null;
            }
            catch (IOException e) {
                businessLog.error("fillTextFormField failed:", (Throwable)e);
            }
            businessLog.info("fillTextFormField end...");
        }
    }

    private static List<String> getTextFormFields(PdfReader reader) throws SealException {
        if (reader == null) {
            throw new SealException("PdfReader is null");
        }
        String methodPrex = "getTextFormFields";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        PdfDocument doc = null;
        ArrayList<String> resultList = new ArrayList<String>();
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
            Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
            for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                PdfFormField field = singleEntry.getValue();
                if (!(field instanceof PdfTextFormField)) continue;
                resultList.add(singleEntry.getKey());
            }
            if (resultList.size() == 0) {
                throw new SealException("no textField found");
            }
            ArrayList<String> arrayList = resultList;
            return arrayList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFields failed:", (Throwable)e);
            throw new SealException("getTextFormFields failed", e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    private static List<Map<String, Object>> getTextFormFieldsInfo(PdfReader reader) throws SealException {
        if (reader == null) {
            throw new SealException("PdfReader is null");
        }
        String methodPrex = "getTextFormFieldsInfo";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        PdfDocument doc = null;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, false);
            if (null != form) {
                Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                    PdfFormField field = singleEntry.getValue();
                    if (!(field instanceof PdfTextFormField)) continue;
                    PdfArray kids = field.getKids();
                    if (kids != null) {
                        for (int i = 0; i < kids.size(); ++i) {
                            PdfObject kid = kids.get(i);
                            if (kid.isIndirectReference()) {
                                kid = ((PdfIndirectReference)kid).getRefersTo();
                            }
                            PdfFormField subField = new PdfFormField((PdfDictionary)kid);
                            PdfWidgetAnnotation oneWidget = subField.getWidgets().get(0);
                            HashMap<String, Object> oneEntry = FormFieldUtil.getOneEntry(doc, oneWidget, singleEntry.getKey(), i);
                            resultList.add(oneEntry);
                        }
                        continue;
                    }
                    PdfWidgetAnnotation widget = singleEntry.getValue().getWidgets().get(0);
                    HashMap<String, Object> oneEntry = FormFieldUtil.getOneEntry(doc, widget, singleEntry.getKey(), -1);
                    resultList.add(oneEntry);
                }
            }
            if (resultList.size() == 0) {
                throw new SealException("no textField found");
            }
            ArrayList<Map<String, Object>> arrayList = resultList;
            return arrayList;
        }
        catch (SealException e) {
            businessLog.error("getTextFormFieldsInfo failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("getTextFormFieldsInfo failed:", (Throwable)e);
            throw new SealException("getTextFormFieldsInfo failed", e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    private static byte[] fillTextFormField(PdfReader reader, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired) throws SealException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        FormFieldUtil.fillTextFormField(reader, (OutputStream)output, formFieldInfoList, flattenFields, isThrowNoFieldException, checkRequired, null);
        return output.toByteArray();
    }

    private static void fillTextFormField(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, boolean checkRequired, PdfFont allFont) throws SealException {
        if (reader == null) {
            throw new SealException("PdfReader is null");
        }
        if (outputStream == null) {
            throw new SealException("outputStream is null");
        }
        String methodPrex = "fillTextFormField-Stream";
        String methodid = MethodCostTimeUtil.recordStartTime(methodPrex);
        PdfDocument doc = null;
        boolean isAppend = flattenFields == null;
        boolean useFileFont = false;
        try {
            String fieldName;
            PdfFormField field;
            StampingProperties properties = new StampingProperties();
            if (isAppend) {
                properties.useAppendMode();
            }
            doc = new PdfDocument(reader, new PdfWriter(outputStream), properties, false);
            ParamsCheckUtil.checkSignature(doc);
            if (null != allFont) {
                doc.addFont(allFont);
                useFileFont = true;
            }
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, true);
            HashMap requiredFieldsMap = new HashMap();
            if (checkRequired) {
                Map<String, PdfFormField> formFieldInfoMap = form.getFormFields();
                for (Map.Entry<String, PdfFormField> singleEntry : formFieldInfoMap.entrySet()) {
                    field = singleEntry.getValue();
                    if (!(field instanceof PdfTextFormField) || !field.isRequired()) continue;
                    String fieldName2 = field.getFieldName().toUnicodeString();
                    requiredFieldsMap.put(fieldName2, null);
                }
            }
            if (formFieldInfoList != null) {
                for (int i = 0; i < formFieldInfoList.size(); ++i) {
                    FormFieldInfo formFieldInfo = formFieldInfoList.get(i);
                    fieldName = formFieldInfo.getFieldName();
                    if (null == fieldName || fieldName.isEmpty()) {
                        throw new SealException("fieldName is null");
                    }
                    field = form.getField(fieldName);
                    if (field != null && field instanceof PdfTextFormField) {
                        float fontSize;
                        PdfTextFormField textField = (PdfTextFormField)field;
                        boolean isAutoScale = false;
                        String text = formFieldInfo.getTextValue();
                        if (null == text || text.isEmpty()) {
                            throw new SealException("textValue is null");
                        }
                        PdfString pdfString = textField.getDefaultAppearance();
                        Object[] splits = null;
                        String fontName = null;
                        if (null != pdfString) {
                            splits = PdfTextFormField.splitDAelements(pdfString.toUnicodeString());
                            fontName = String.valueOf(splits[0]);
                        }
                        PdfFont font = formFieldInfo.getFont();
                        if (PDFUtil.containsUCS4Glyph(text)) {
                            font = UCS4FontUtil.getInstance().subsetFont(text);
                            textField.setFont(font, false);
                        } else if (useFileFont) {
                            textField.setFont(allFont, false);
                        } else {
                            if (null != fontName && null == font) {
                                font = FontsFactory.getInstance().getSubSetFont(fontName, text, false);
                            }
                            if (null == font) {
                                font = FontUtil.getInstance().subsetFont(text);
                            }
                            textField.setFont(font, false);
                        }
                        Color color = formFieldInfo.getFontColor();
                        if (null != color) {
                            textField.setColor(color, false);
                        }
                        if ((fontSize = formFieldInfo.getFontSize()) > 0.0f) {
                            textField.setFontSize(fontSize, false);
                        } else if (splits != null && ((Float)splits[1]).floatValue() == 0.0f) {
                            isAutoScale = true;
                        }
                        textField.setValue(text);
                        textField.setReadOnly(true);
                        if (isAutoScale) {
                            textField.setFontSizeAutoScale();
                        }
                        requiredFieldsMap.remove(fieldName);
                        continue;
                    }
                    if (!isThrowNoFieldException) continue;
                    throw new SealException("no textField found fieldName=" + fieldName);
                }
            }
            if (checkRequired && requiredFieldsMap.size() > 0) {
                throw new SealException("textField must be filled, fieldName is" + requiredFieldsMap.keySet());
            }
            boolean isflattenFields = false;
            if (flattenFields != null && flattenFields.length > 0) {
                form.setGenerateAppearance(false);
                for (int k = 0; k < flattenFields.length; ++k) {
                    fieldName = flattenFields[k];
                    field = form.getField(fieldName);
                    if (field == null) continue;
                    form.partialFormFlattening(fieldName);
                    isflattenFields = true;
                }
                if (isflattenFields) {
                    form.flattenFields();
                }
            }
        }
        catch (SealException e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("fillTextFormField failed:", (Throwable)e);
            throw new SealException("fillTextFormField failed", e);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
            MethodCostTimeUtil.recordEndTime(methodid);
        }
    }

    private static void fillTextFormField(PdfReader reader, OutputStream outputStream, List<FormFieldInfo> formFieldInfoList, String[] flattenFields, boolean isThrowNoFieldException, PdfFont allFont) throws SealException {
        FormFieldUtil.fillTextFormField(reader, outputStream, formFieldInfoList, flattenFields, isThrowNoFieldException, false, allFont);
    }

    private static boolean[] haveFields(PdfReader reader, String[] fields) throws IOException {
        PdfDocument doc = null;
        boolean[] haveFields = null;
        try {
            doc = new PdfDocument(reader);
            PdfAcroForm form = PdfAcroForm.getAcroForm(doc, false);
            if (null == form) {
                throw new IOException("no field found!");
            }
            Map<String, PdfFormField> fieldsMap = form.getFormFields();
            int fieldsLength = fields.length;
            haveFields = new boolean[fieldsLength];
            for (int i = 0; i < fieldsLength; ++i) {
                haveFields[i] = fieldsMap.containsKey(fields[i]);
            }
            doc.close();
            boolean[] blArray = haveFields;
            return blArray;
        }
        catch (Exception e) {
            businessLog.error("process haveFields() failed", (Throwable)e);
            throw new IOException(e.getMessage());
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, PdfFormField> getAllFields(PdfReader reader) throws SealException {
        PdfDocument pdfDoc = null;
        try {
            Map<String, PdfFormField> formFields;
            pdfDoc = new PdfDocument(reader, false);
            PdfAcroForm form = PdfAcroForm.getAcroForm(pdfDoc, true);
            Map<String, PdfFormField> map = formFields = form.getFormFields();
            return map;
        }
        catch (Exception e) {
            businessLog.error("getAllFields failed", (Throwable)e);
            Map<String, PdfFormField> map = null;
            return map;
        }
        finally {
            if (null != pdfDoc) {
                pdfDoc.close();
            }
        }
    }

    private static HashMap<String, Object> getOneEntry(PdfDocument doc, PdfAnnotation oneWidget, String fieldName, int index) {
        HashMap<String, Object> oneEntry = new HashMap<String, Object>();
        PdfDictionary pageDictionary = oneWidget.getPageObject();
        PdfPage page = doc.getPage(pageDictionary);
        int pageNum = doc.getPageNumber(page);
        PdfArray rect = oneWidget.getRectangle();
        float lx = rect.getAsNumber(0).floatValue();
        float ly = rect.getAsNumber(1).floatValue();
        float rx = rect.getAsNumber(2).floatValue();
        float ry = rect.getAsNumber(3).floatValue();
        oneEntry.put(PAGENUM, pageNum);
        oneEntry.put(PAGEHEIGHT, Float.valueOf(page.getPageSize().getHeight()));
        oneEntry.put(RECTANGLE, new Rectangle(lx, ly, rx - lx, ry - ly));
        if (index != -1) {
            oneEntry.put(FIELDNAME, fieldName + "#" + index);
        } else {
            oneEntry.put(FIELDNAME, fieldName);
        }
        return oneEntry;
    }
}

