/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.util;

import cfca.sadk.tls.util.TLSLoggings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;
import sun.security.action.GetPropertyAction;

public abstract class TLSDeviceConf {
    private static final String TLS_CONFIG_FILENAME = "tls-device.cfg";
    private static final String TLS_CONFIG_EXTERNAL_FILEPATH = "config/tls-device.cfg";
    public static final String deviceType;
    public static final boolean checkIdentity;
    private static String cfgFileLogging;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Properties loadFromFile() {
        String jvmArgsFilePath = AccessController.doPrivileged(new GetPropertyAction("cfca.tls.device"));
        File file = jvmArgsFilePath == null || jvmArgsFilePath.isEmpty() ? new File(TLS_CONFIG_EXTERNAL_FILEPATH) : new File(jvmArgsFilePath);
        TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg: {}", (Object)file.getAbsolutePath());
        Properties properties = new Properties();
        InputStream in = null;
        try {
            if (file.isFile() && file.exists()) {
                in = new FileInputStream(file);
                cfgFileLogging = file.getAbsolutePath();
                TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg load from externalFile: {}", (Object)cfgFileLogging);
            } else {
                TLSLoggings.ENVIRONMENT_LOGGER.warn("tls-device.cfg not found: {}", (Object)file.getAbsolutePath());
                TLSLoggings.ERROR_LOGGER.error("tls-device.cfg not found: {}", (Object)file.getAbsolutePath());
                String filename = TLS_CONFIG_FILENAME;
                TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg trying load from internalJarFile: {}", (Object)TLS_CONFIG_FILENAME);
                ClassLoader classLoader = TLSDeviceConf.class.getClassLoader();
                TLSLoggings.ENVIRONMENT_LOGGER.info("classLoader: {}", (Object)classLoader);
                in = classLoader.getResourceAsStream(TLS_CONFIG_FILENAME);
                if (in != null) {
                    URL url = classLoader.getResource(TLS_CONFIG_FILENAME);
                    cfgFileLogging = url != null ? file.getAbsolutePath() + " not exists, then use jar-->" + url.getPath() : file.getAbsolutePath() + " not exists, then use jar~";
                    TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg load from internalJarFile: {}", (Object)cfgFileLogging);
                } else {
                    TLSLoggings.ENVIRONMENT_LOGGER.warn("tls-device.cfg dot not load from internalJarFile");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            in = null;
        }
        if (in != null) {
            try {
                TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg load from start: {}", (Object)cfgFileLogging);
                properties.load(in);
                TLSLoggings.ENVIRONMENT_LOGGER.info("tls-device.cfg load from end: {}", (Object)cfgFileLogging);
            }
            catch (Exception e) {
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return properties;
    }

    static final StringBuilder appendME(StringBuilder builder) {
        builder.append("\n");
        builder.append("\n TLS\u517c\u5bb9\u914d\u7f6e: ");
        builder.append("\n###############################################");
        builder.append("\n  tls-device.cfg=");
        builder.append(cfgFileLogging);
        builder.append("\n  deviceType=");
        builder.append(deviceType);
        builder.append("\n  checkIdentity=");
        builder.append(checkIdentity);
        builder.append("\n###############################################");
        return builder;
    }

    static {
        Properties properties = TLSDeviceConf.loadFromFile();
        deviceType = properties.getProperty("JCryptoDeviceType", "JSOFT_LIB");
        checkIdentity = "true".equalsIgnoreCase(properties.getProperty("checkIdentity", "true"));
    }
}

