/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener;

import cfca.sadk.com.itextpdf.kernel.font.PdfFont;
import cfca.sadk.com.itextpdf.kernel.geom.LineSegment;
import cfca.sadk.com.itextpdf.kernel.geom.Matrix;
import cfca.sadk.com.itextpdf.kernel.geom.Rectangle;
import cfca.sadk.com.itextpdf.kernel.geom.Vector;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.CanvasTag;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.EventType;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.DefaultPdfTextLocation;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationMapExtractionStrategy;
import cfca.sadk.com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import cfca.sadk.seal.base.util.KMPUtil;
import cfca.sadk.seal.base.util.PDFUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class KeywordListLocationExtractionStrategy
implements ILocationMapExtractionStrategy {
    private List<String> keywordList = null;
    private List<int[]> kmpList = null;
    private static boolean DUMP_STATE = false;
    private static final float DIACRITICAL_MARKS_ALLOWED_VERTICAL_DEVIATION = 2.0f;
    private final List<TextChunk> locationalResult = new ArrayList<TextChunk>();
    private final ITextChunkLocationStrategy tclStrat;
    private boolean useActualText = false;
    private boolean rightToLeftRunDirection = false;
    private TextRenderInfo lastTextRenderInfo;

    public KeywordListLocationExtractionStrategy() {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
    }

    public KeywordListLocationExtractionStrategy(List<String> keywordList, List<int[]> kmpList) {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
        this.keywordList = keywordList;
        this.kmpList = kmpList;
    }

    public KeywordListLocationExtractionStrategy(String keyword, int[] kmpnext) {
        this(new ITextChunkLocationStrategy(){

            @Override
            public ITextChunkLocation createLocation(TextRenderInfo renderInfo, LineSegment baseline) {
                return new TextChunkLocationDefaultImp(baseline.getStartPoint(), baseline.getEndPoint(), renderInfo.getSingleSpaceWidth());
            }
        });
        this.keywordList = new ArrayList<String>();
        this.keywordList.add(keyword);
        this.kmpList = new ArrayList<int[]>();
        this.kmpList.add(kmpnext);
    }

    public KeywordListLocationExtractionStrategy(ITextChunkLocationStrategy strat) {
        this.tclStrat = strat;
    }

    public KeywordListLocationExtractionStrategy setUseActualText(boolean useActualText) {
        this.useActualText = useActualText;
        return this;
    }

    public KeywordListLocationExtractionStrategy setRightToLeftRunDirection(boolean rightToLeftRunDirection) {
        this.rightToLeftRunDirection = rightToLeftRunDirection;
        return this;
    }

    public boolean isUseActualText() {
        return this.useActualText;
    }

    @Override
    public void eventOccurred(IEventData data, EventType type) {
        if (type.equals((Object)EventType.RENDER_TEXT)) {
            TextRenderInfo renderInfo = (TextRenderInfo)data;
            LineSegment segment = renderInfo.getBaseline();
            if (renderInfo.getRise() != 0.0f) {
                Matrix riseOffsetTransform = new Matrix(0.0f, -renderInfo.getRise());
                segment = segment.transformBy(riseOffsetTransform);
            }
            if (this.useActualText) {
                CanvasTag lastTagWithActualText;
                CanvasTag canvasTag = lastTagWithActualText = this.lastTextRenderInfo != null ? this.findLastTagWithActualText(this.lastTextRenderInfo.getCanvasTagHierarchy()) : null;
                if (lastTagWithActualText != null && lastTagWithActualText == this.findLastTagWithActualText(renderInfo.getCanvasTagHierarchy())) {
                    TextChunk lastTextChunk = this.locationalResult.get(this.locationalResult.size() - 1);
                    Vector mergedStart = new Vector(Math.min(lastTextChunk.getLocation().getStartLocation().get(0), segment.getStartPoint().get(0)), Math.min(lastTextChunk.getLocation().getStartLocation().get(1), segment.getStartPoint().get(1)), Math.min(lastTextChunk.getLocation().getStartLocation().get(2), segment.getStartPoint().get(2)));
                    Vector mergedEnd = new Vector(Math.max(lastTextChunk.getLocation().getEndLocation().get(0), segment.getEndPoint().get(0)), Math.max(lastTextChunk.getLocation().getEndLocation().get(1), segment.getEndPoint().get(1)), Math.max(lastTextChunk.getLocation().getEndLocation().get(2), segment.getEndPoint().get(2)));
                    TextChunk merged = new TextChunk(lastTextChunk.getText(), this.tclStrat.createLocation(renderInfo, new LineSegment(mergedStart, mergedEnd)));
                    this.locationalResult.set(this.locationalResult.size() - 1, merged);
                } else {
                    String actualText = renderInfo.getActualText();
                    TextChunk tc = new TextChunk(actualText != null ? actualText : renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment));
                    this.locationalResult.add(tc);
                }
            } else {
                TextChunk tc = new TextChunk(renderInfo.getText(), this.tclStrat.createLocation(renderInfo, segment), renderInfo.getFont(), segment, renderInfo.getAscentLine(), renderInfo.getDescentLine());
                this.locationalResult.add(tc);
            }
            this.lastTextRenderInfo = renderInfo;
        }
    }

    @Override
    public Set<EventType> getSupportedEvents() {
        return null;
    }

    public String getResultantText() {
        if (DUMP_STATE) {
            this.dumpState();
        }
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>(this.locationalResult);
        this.sortWithMarks(textChunks);
        StringBuilder sb = new StringBuilder();
        TextChunk lastChunk = null;
        for (TextChunk chunk : textChunks) {
            if (lastChunk == null) {
                sb.append(chunk.text);
            } else if (chunk.sameLine(lastChunk)) {
                if (this.isChunkAtWordBoundary(chunk, lastChunk) && !this.startsWithSpace(chunk.text) && !this.endsWithSpace(lastChunk.text)) {
                    sb.append(' ');
                }
                sb.append(chunk.text);
            } else {
                sb.append('\n');
                sb.append(chunk.text);
            }
            lastChunk = chunk;
        }
        return sb.toString();
    }

    protected boolean isChunkAtWordBoundary(TextChunk chunk, TextChunk previousChunk) {
        return chunk.getLocation().isAtWordBoundary(previousChunk.getLocation());
    }

    private boolean startsWithSpace(String str) {
        return str.length() != 0 && str.charAt(0) == ' ';
    }

    private boolean endsWithSpace(String str) {
        return str.length() != 0 && str.charAt(str.length() - 1) == ' ';
    }

    private void dumpState() {
        for (TextChunk location : this.locationalResult) {
            location.printDiagnostics();
        }
    }

    private CanvasTag findLastTagWithActualText(List<CanvasTag> canvasTagHierarchy) {
        CanvasTag lastActualText = null;
        for (CanvasTag tag : canvasTagHierarchy) {
            if (tag.getActualText() == null) continue;
            lastActualText = tag;
            break;
        }
        return lastActualText;
    }

    private void sortWithMarks(List<TextChunk> textChunks) {
        HashMap<TextChunk, TextChunkMarks> marks = new HashMap<TextChunk, TextChunkMarks>();
        ArrayList<TextChunk> toSort = new ArrayList<TextChunk>();
        for (int markInd = 0; markInd < textChunks.size(); ++markInd) {
            ITextChunkLocation location = textChunks.get(markInd).getLocation();
            if (location.getStartLocation().equals(location.getEndLocation())) {
                boolean foundBaseToAttachTo = false;
                for (int baseInd = 0; baseInd < textChunks.size(); ++baseInd) {
                    ITextChunkLocation baseLocation;
                    if (markInd == baseInd || (baseLocation = textChunks.get(baseInd).getLocation()).getStartLocation().equals(baseLocation.getEndLocation()) || !this.containsMark(baseLocation, location)) continue;
                    TextChunkMarks currentMarks = (TextChunkMarks)marks.get(textChunks.get(baseInd));
                    if (currentMarks == null) {
                        currentMarks = new TextChunkMarks();
                        marks.put(textChunks.get(baseInd), currentMarks);
                    }
                    if (markInd < baseInd) {
                        currentMarks.preceding.add(textChunks.get(markInd));
                    } else {
                        currentMarks.succeeding.add(textChunks.get(markInd));
                    }
                    foundBaseToAttachTo = true;
                    break;
                }
                if (foundBaseToAttachTo) continue;
                toSort.add(textChunks.get(markInd));
                continue;
            }
            toSort.add(textChunks.get(markInd));
        }
        if (this.rightToLeftRunDirection) {
            Collections.sort(toSort, new TextChunkComparator(new TextChunkLocationComparator(false)));
        } else {
            Collections.sort(toSort);
        }
        textChunks.clear();
        for (TextChunk current : toSort) {
            int j;
            TextChunkMarks currentMarks = (TextChunkMarks)marks.get(current);
            if (currentMarks != null) {
                if (!this.rightToLeftRunDirection) {
                    for (j = 0; j < currentMarks.preceding.size(); ++j) {
                        textChunks.add(currentMarks.preceding.get(j));
                    }
                } else {
                    for (j = currentMarks.succeeding.size() - 1; j >= 0; --j) {
                        textChunks.add(currentMarks.succeeding.get(j));
                    }
                }
            }
            textChunks.add(current);
            if (currentMarks == null) continue;
            if (!this.rightToLeftRunDirection) {
                for (j = 0; j < currentMarks.succeeding.size(); ++j) {
                    textChunks.add(currentMarks.succeeding.get(j));
                }
                continue;
            }
            for (j = currentMarks.preceding.size() - 1; j >= 0; --j) {
                textChunks.add(currentMarks.preceding.get(j));
            }
        }
    }

    private boolean containsMark(ITextChunkLocation baseLocation, ITextChunkLocation markLocation) {
        return baseLocation.getStartLocation().get(0) <= markLocation.getStartLocation().get(0) && baseLocation.getEndLocation().get(0) >= markLocation.getEndLocation().get(0) && (float)Math.abs(baseLocation.distPerpendicular() - markLocation.distPerpendicular()) <= 2.0f;
    }

    @Override
    public HashMap<String, List<IPdfTextLocation>> getResultantLocations() {
        HashMap<Integer, Integer> chunkPositions = new HashMap<Integer, Integer>();
        StringBuilder sb = new StringBuilder();
        HashMap<Object, Object> mutiRetval = new HashMap();
        TextChunk lastChunk = null;
        int totalChars = 0;
        for (int i = 0; i < this.locationalResult.size(); ++i) {
            TextChunk textChunk = this.locationalResult.get(i);
            String text = textChunk.getText();
            for (int j = 0; j < text.length(); ++j) {
                chunkPositions.put(totalChars, i);
                ++totalChars;
            }
            if (lastChunk == null) {
                sb.append(text);
            } else if (textChunk.sameLine(lastChunk)) {
                if (!(!textChunk.getLocation().isAtWordBoundary(lastChunk.getLocation()) || text.startsWith(" ") || text.endsWith(" ") || "\u25a1".equals(text) || PDFUtil.isInteger(text))) {
                    sb.append(' ');
                    chunkPositions.put(totalChars, i);
                    ++totalChars;
                }
                sb.append(text);
            } else {
                sb.append(text);
            }
            lastChunk = textChunk;
        }
        mutiRetval = this.getKeywordList(sb.toString(), chunkPositions);
        for (String string : mutiRetval.keySet()) {
            List retval = (List)mutiRetval.get(string);
            Collections.sort(retval, new Comparator<IPdfTextLocation>(){

                @Override
                public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
                    Rectangle o1 = l1.getRectangle();
                    Rectangle o2 = l2.getRectangle();
                    if (o1.getY() == o2.getY()) {
                        return o1.getX() == o2.getX() ? 0 : (o1.getX() < o2.getX() ? -1 : 1);
                    }
                    return o1.getY() < o2.getY() ? 1 : -1;
                }
            });
        }
        this.locationalResult.clear();
        return mutiRetval;
    }

    private HashMap<String, List<IPdfTextLocation>> getKeywordList(String pageWords, HashMap<Integer, Integer> chunkPositions) {
        HashMap<String, List<IPdfTextLocation>> mutiRetval = new HashMap<String, List<IPdfTextLocation>>();
        for (int m = 0; m < this.keywordList.size(); ++m) {
            String sourceStr = pageWords;
            int charLastIndex = 0;
            int markChunkIndex = -1;
            String keyword = this.keywordList.get(m);
            int[] kmpnext = this.kmpList.get(m);
            boolean flag = true;
            ArrayList<DefaultPdfTextLocation> retval = new ArrayList<DefaultPdfTextLocation>();
            while (flag) {
                int charStartIndex = KMPUtil.kmp(sourceStr, keyword, kmpnext);
                if (charStartIndex == -1) {
                    flag = false;
                    continue;
                }
                charStartIndex = charLastIndex + charStartIndex;
                int charEndIndex = charStartIndex + kmpnext.length;
                int chunkStartIndex = charStartIndex;
                try {
                    chunkStartIndex = chunkPositions.get(charStartIndex);
                }
                catch (NullPointerException e) {
                    chunkStartIndex = chunkPositions.get(charStartIndex - 1);
                }
                if (chunkStartIndex <= markChunkIndex) {
                    charLastIndex = charEndIndex;
                    sourceStr = pageWords.substring(charEndIndex);
                    continue;
                }
                markChunkIndex = chunkStartIndex;
                int chunkEndIndex = chunkStartIndex;
                if (kmpnext.length != 1) {
                    chunkEndIndex = charEndIndex - 1;
                    try {
                        chunkEndIndex = chunkPositions.get(chunkEndIndex);
                    }
                    catch (NullPointerException e) {
                        chunkEndIndex = chunkPositions.get(chunkEndIndex + 1);
                    }
                } else {
                    chunkEndIndex = chunkPositions.get(charEndIndex - 1);
                }
                for (Rectangle r : this.getKeywordRectangleList(this.getSubChunkList(this.locationalResult, chunkStartIndex, chunkEndIndex), keyword, kmpnext)) {
                    retval.add(new DefaultPdfTextLocation(0, r, keyword));
                }
                charLastIndex = charEndIndex;
                sourceStr = pageWords.substring(charEndIndex);
            }
            mutiRetval.put(keyword, retval);
        }
        return mutiRetval;
    }

    protected List<TextChunk> getSubChunkList(List<TextChunk> chunkList, int startIndex, int endIndex) {
        ArrayList<TextChunk> subChunkList = new ArrayList<TextChunk>();
        TextChunk lastChunk = chunkList.get(startIndex);
        subChunkList.add(lastChunk);
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            TextChunk curChunk = chunkList.get(i);
            if (!curChunk.sameLine(lastChunk)) {
                subChunkList.clear();
                return subChunkList;
            }
            subChunkList.add(curChunk);
            lastChunk = curChunk;
        }
        return subChunkList;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected List<Rectangle> getKeywordRectangleList(List<TextChunk> cris, String keyword, int[] kmpnext) {
        float h;
        LineSegment descentLine;
        LineSegment ascentLine;
        PdfFont pdfFont;
        int offsetStartIndex;
        float offsetPounds;
        boolean flag;
        String firstChunkText0;
        String firstChunkText;
        Rectangle firstRectangle;
        TextChunk firstChunk;
        ArrayList<Rectangle> retval;
        block17: {
            float h2;
            block16: {
                float h3;
                block15: {
                    retval = new ArrayList<Rectangle>();
                    if (cris.isEmpty()) {
                        return retval;
                    }
                    int chunkSize = cris.size();
                    firstChunk = cris.get(0);
                    TextChunk lastChunk = cris.get(chunkSize - 1);
                    firstRectangle = firstChunk.getRectangle();
                    Rectangle lastRectangle = lastChunk.getRectangle();
                    if (chunkSize > 1) {
                        PdfFont pdfFont2 = firstChunk.getPdfFont();
                        LineSegment ascentLine2 = firstChunk.getAscentLine();
                        LineSegment descentLine2 = firstChunk.getDescentLine();
                        StringBuilder sb = new StringBuilder();
                        TextChunk chunk = firstChunk;
                        sb.append(chunk.getText());
                        for (int i = 1; i < chunkSize; ++i) {
                            TextChunk tmpLastChunk = chunk;
                            chunk = cris.get(i);
                            if (chunk.getLocation().isAtWordBoundary(tmpLastChunk.getLocation())) {
                                sb.append(' ');
                            }
                            sb.append(chunk.getText());
                        }
                        int keywordlength = kmpnext.length;
                        TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
                        Vector orientationVector = textChunkLocation.getOrientationVector();
                        float offsetPoundsFirst = 0.0f;
                        float offsetPoundsLast = 0.0f;
                        if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) {
                            float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                            float fontSize = ascentLine2.getStartPoint().get(1) - descentLine2.getStartPoint().get(1);
                            String first1String = keyword.substring(0, 1);
                            int offsetOfKeywordInFirstChunk = firstChunk.getText().indexOf(first1String);
                            String firstChunkText2 = firstChunk.getText();
                            String stringBeforeKeyword = firstChunkText2.substring(0, offsetOfKeywordInFirstChunk);
                            offsetPoundsFirst = pdfFont2.getWidth(stringBeforeKeyword, fontSize);
                            String last1String = keyword.substring(keywordlength - 1);
                            int offsetOfKeywordInLastChunk = lastChunk.getText().indexOf(last1String);
                            String lastChunkText = lastChunk.getText();
                            String stringAfterKeyword = lastChunkText.substring(offsetOfKeywordInLastChunk + 1);
                            offsetPoundsLast = pdfFont2.getWidth(stringAfterKeyword, fontSize);
                            offsetPoundsFirst = (int)(offsetPoundsFirst + 0.5f);
                            offsetPoundsLast = (int)(offsetPoundsLast + 0.5f);
                            float x = firstRectangle.getX() + offsetPoundsFirst;
                            float y = firstRectangle.getY();
                            float w = chunkWidth - offsetPoundsFirst - offsetPoundsLast;
                            float h4 = firstRectangle.getHeight();
                            retval.add(new Rectangle(x, y, w, h4));
                            return retval;
                        }
                        if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) {
                            float chunkHeight = lastRectangle.getY() - firstRectangle.getY() + lastRectangle.getHeight();
                            String firstChunkText3 = firstChunk.getText();
                            float fontSize = descentLine2.getStartPoint().get(0) - ascentLine2.getStartPoint().get(0);
                            String first1String = keyword.substring(0, 1);
                            int offsetOfKeywordInFirstChunk = firstChunkText3.indexOf(first1String);
                            String stringBeforeKeyword = firstChunkText3.substring(0, offsetOfKeywordInFirstChunk);
                            offsetPoundsFirst = pdfFont2.getWidth(stringBeforeKeyword, fontSize);
                            String lastChunkText = lastChunk.getText();
                            String last1String = keyword.substring(keywordlength - 1);
                            int offsetOfKeywordInLastChunk = lastChunkText.indexOf(last1String);
                            String stringAfterKeyword = lastChunkText.substring(offsetOfKeywordInLastChunk + 1);
                            offsetPoundsLast = pdfFont2.getWidth(stringAfterKeyword, fontSize);
                            offsetPoundsFirst = (int)(offsetPoundsFirst + 0.5f);
                            offsetPoundsLast = (int)(offsetPoundsLast + 0.5f);
                            float x = firstRectangle.getX();
                            float y = firstRectangle.getY() + offsetPoundsFirst;
                            float w = firstRectangle.getHeight();
                            float h5 = chunkHeight - offsetPoundsFirst - offsetPoundsLast;
                            retval.add(new Rectangle(x, y, -w, h5));
                            return retval;
                        }
                        if (Math.abs(orientationVector.get(0) + 1.0f) < 0.001f) {
                            float chunkWidth = lastRectangle.getX() - firstRectangle.getX() + lastRectangle.getWidth();
                            String firstChunkText4 = firstChunk.getText();
                            float fontSize = descentLine2.getStartPoint().get(1) - ascentLine2.getStartPoint().get(1);
                            String first1String = keyword.substring(0, 1);
                            int offsetOfKeywordInFirstChunk = firstChunkText4.indexOf(first1String);
                            String stringBeforeKeyword = firstChunkText4.substring(0, offsetOfKeywordInFirstChunk);
                            offsetPoundsFirst = pdfFont2.getWidth(stringBeforeKeyword, fontSize);
                            String lastChunkText = lastChunk.getText();
                            String last1String = keyword.substring(keywordlength - 1);
                            int offsetOfKeywordInLastChunk = lastChunkText.indexOf(last1String);
                            String stringAfterKeyword = lastChunkText.substring(offsetOfKeywordInLastChunk + 1);
                            offsetPoundsLast = pdfFont2.getWidth(stringAfterKeyword, fontSize);
                            offsetPoundsFirst = (int)(offsetPoundsFirst + 0.5f);
                            offsetPoundsLast = (int)(offsetPoundsLast + 0.5f);
                            float x = firstRectangle.getX() + offsetPoundsFirst;
                            float y = firstRectangle.getY();
                            float w = chunkWidth - offsetPoundsFirst - offsetPoundsLast;
                            float h6 = firstRectangle.getHeight();
                            retval.add(new Rectangle(x, y, -w, -h6));
                            return retval;
                        }
                        if (!(Math.abs(orientationVector.get(1) + 1.0f) < 0.001f)) return retval;
                        return retval;
                    }
                    firstChunkText0 = firstChunkText = firstChunk.getText();
                    flag = true;
                    offsetPounds = 0.0f;
                    offsetStartIndex = 0;
                    pdfFont = firstChunk.getPdfFont();
                    ascentLine = firstChunk.getAscentLine();
                    descentLine = firstChunk.getDescentLine();
                    TextChunkLocationDefaultImp textChunkLocation = (TextChunkLocationDefaultImp)firstChunk.getLocation();
                    Vector orientationVector = textChunkLocation.getOrientationVector();
                    if (Math.abs(orientationVector.get(0) - 1.0f) < 0.001f) break block15;
                    if (Math.abs(orientationVector.get(1) - 1.0f) < 0.001f) break block16;
                    if (!(Math.abs(orientationVector.get(0) + 1.0f) < 0.001f)) {
                        if (!(Math.abs(orientationVector.get(1) + 1.0f) < 0.001f)) return retval;
                        return retval;
                    }
                    break block17;
                }
                float fontSize = h3 = ascentLine.getStartPoint().get(1) - descentLine.getStartPoint().get(1);
                while (flag) {
                    int startIndex = KMPUtil.kmp(firstChunkText, keyword, kmpnext);
                    if (startIndex == -1) {
                        return retval;
                    }
                    String stringBeforeKeyword = firstChunkText0.substring(0, startIndex + offsetStartIndex);
                    offsetPounds = pdfFont.getWidth(stringBeforeKeyword, fontSize);
                    offsetPounds = (int)(offsetPounds + 0.5f);
                    float x = firstRectangle.getX() + offsetPounds;
                    float y = firstRectangle.getY();
                    float w = pdfFont.getWidth(keyword, fontSize);
                    retval.add(new Rectangle(x, y, w, h3));
                    offsetStartIndex = startIndex + offsetStartIndex + kmpnext.length;
                    firstChunkText = firstChunk.getText().substring(offsetStartIndex);
                }
                return retval;
            }
            float fontSize = h2 = descentLine.getStartPoint().get(0) - ascentLine.getStartPoint().get(0);
            while (flag) {
                int startIndex = KMPUtil.kmp(firstChunkText, keyword, kmpnext);
                if (startIndex == -1) {
                    return retval;
                }
                String stringBeforeKeyword = firstChunkText0.substring(0, startIndex + offsetStartIndex);
                offsetPounds = pdfFont.getWidth(stringBeforeKeyword, fontSize);
                offsetPounds = (int)(offsetPounds + 0.5f);
                float x = firstRectangle.getX();
                float y = firstRectangle.getY() + offsetPounds;
                float w = pdfFont.getWidth(keyword, fontSize);
                retval.add(new Rectangle(x, y, -h2, w));
                offsetStartIndex = startIndex + offsetStartIndex + kmpnext.length;
                firstChunkText = firstChunk.getText().substring(offsetStartIndex);
            }
            return retval;
        }
        float fontSize = h = descentLine.getStartPoint().get(1) - ascentLine.getStartPoint().get(1);
        while (flag) {
            int startIndex = KMPUtil.kmp(firstChunkText, keyword, kmpnext);
            if (startIndex == -1) {
                return retval;
            }
            String stringBeforeKeyword = firstChunkText0.substring(0, startIndex + offsetStartIndex);
            offsetPounds = pdfFont.getWidth(stringBeforeKeyword, fontSize);
            offsetPounds = (int)(offsetPounds + 0.5f);
            float x = firstRectangle.getX() - offsetPounds;
            float y = firstRectangle.getY();
            float w = pdfFont.getWidth(keyword, fontSize);
            retval.add(new Rectangle(x, y, -w, -h));
            offsetStartIndex = startIndex + offsetStartIndex + kmpnext.length;
            firstChunkText = firstChunk.getText().substring(offsetStartIndex);
        }
        return retval;
    }

    private static class TextChunkMarks {
        List<TextChunk> preceding = new ArrayList<TextChunk>();
        List<TextChunk> succeeding = new ArrayList<TextChunk>();

        private TextChunkMarks() {
        }
    }

    private static class TextChunkLocationComparator
    implements Comparator<ITextChunkLocation> {
        private boolean leftToRight = true;

        public TextChunkLocationComparator() {
        }

        public TextChunkLocationComparator(boolean leftToRight) {
            this.leftToRight = leftToRight;
        }

        @Override
        public int compare(ITextChunkLocation first, ITextChunkLocation second) {
            int result;
            int m2;
            if (first == second) {
                return 0;
            }
            int m1 = first.orientationMagnitude();
            int n = m1 < (m2 = second.orientationMagnitude()) ? -1 : (result = m1 == m2 ? 0 : 1);
            if (result != 0) {
                return result;
            }
            int distPerpendicularDiff = first.distPerpendicular() - second.distPerpendicular();
            if (distPerpendicularDiff != 0) {
                return distPerpendicularDiff;
            }
            return this.leftToRight ? Float.compare(first.distParallelStart(), second.distParallelStart()) : -Float.compare(first.distParallelEnd(), second.distParallelEnd());
        }
    }

    private static class TextChunkComparator
    implements Comparator<TextChunk> {
        private Comparator<ITextChunkLocation> locationComparator;

        public TextChunkComparator(Comparator<ITextChunkLocation> locationComparator) {
            this.locationComparator = locationComparator;
        }

        @Override
        public int compare(TextChunk o1, TextChunk o2) {
            return this.locationComparator.compare(o1.location, o2.location);
        }
    }

    public static class TextChunkLocationDefaultImp
    implements ITextChunkLocation {
        private static final TextChunkLocationComparator defaultComparator = new TextChunkLocationComparator();
        private final Vector startLocation;
        private final Vector endLocation;
        private final Vector orientationVector;
        private final int orientationMagnitude;
        private final int distPerpendicular;
        private final float distParallelStart;
        private final float distParallelEnd;
        private final float charSpaceWidth;

        public TextChunkLocationDefaultImp(Vector startLocation, Vector endLocation, float charSpaceWidth) {
            this.startLocation = startLocation;
            this.endLocation = endLocation;
            this.charSpaceWidth = charSpaceWidth;
            Vector oVector = endLocation.subtract(startLocation);
            if (oVector.length() == 0.0f) {
                oVector = new Vector(1.0f, 0.0f, 0.0f);
            }
            this.orientationVector = oVector.normalize();
            this.orientationMagnitude = (int)(Math.atan2(this.orientationVector.get(1), this.orientationVector.get(0)) * 1000.0);
            Vector origin = new Vector(0.0f, 0.0f, 1.0f);
            this.distPerpendicular = (int)startLocation.subtract(origin).cross(this.orientationVector).get(2);
            this.distParallelStart = this.orientationVector.dot(startLocation);
            this.distParallelEnd = this.orientationVector.dot(endLocation);
        }

        @Override
        public int orientationMagnitude() {
            return this.orientationMagnitude;
        }

        @Override
        public int distPerpendicular() {
            return this.distPerpendicular;
        }

        @Override
        public float distParallelStart() {
            return this.distParallelStart;
        }

        @Override
        public float distParallelEnd() {
            return this.distParallelEnd;
        }

        @Override
        public Vector getStartLocation() {
            return this.startLocation;
        }

        @Override
        public Vector getEndLocation() {
            return this.endLocation;
        }

        @Override
        public Vector getOrientationVector() {
            return this.orientationVector;
        }

        @Override
        public float getCharSpaceWidth() {
            return this.charSpaceWidth;
        }

        @Override
        public boolean sameLine(ITextChunkLocation as) {
            if (this.orientationMagnitude() != as.orientationMagnitude()) {
                return false;
            }
            float distPerpendicularDiff = this.distPerpendicular() - as.distPerpendicular();
            if (distPerpendicularDiff == 0.0f) {
                return true;
            }
            LineSegment mySegment = new LineSegment(this.startLocation, this.endLocation);
            LineSegment otherSegment = new LineSegment(as.getStartLocation(), as.getEndLocation());
            return Math.abs(distPerpendicularDiff) <= 2.0f && (mySegment.getLength() == 0.0f || otherSegment.getLength() == 0.0f);
        }

        @Override
        public float distanceFromEndOf(ITextChunkLocation other) {
            return this.distParallelStart() - other.distParallelEnd();
        }

        @Override
        public boolean isAtWordBoundary(ITextChunkLocation previous) {
            if (this.getCharSpaceWidth() < 0.1f) {
                return false;
            }
            if (this.startLocation.equals(this.endLocation) || previous.getEndLocation().equals(previous.getStartLocation())) {
                return false;
            }
            float dist = this.distanceFromEndOf(previous);
            return dist < -this.getCharSpaceWidth() || dist > this.getCharSpaceWidth() / 2.0f;
        }

        @Override
        public int compareTo(ITextChunkLocation other) {
            return defaultComparator.compare(this, other);
        }
    }

    public static class TextChunk
    implements Comparable<TextChunk> {
        protected final String text;
        protected final ITextChunkLocation location;
        protected LineSegment baseLine;
        protected LineSegment ascentLine;
        protected LineSegment descentLine;
        protected PdfFont pdfFont;

        public TextChunk(String string, ITextChunkLocation loc) {
            this.text = string;
            this.location = loc;
        }

        public TextChunk(String string, ITextChunkLocation loc, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
            this.text = string;
            this.location = loc;
            this.baseLine = baseLine;
            this.ascentLine = ascentLine;
            this.descentLine = descentLine;
        }

        public TextChunk(String string, ITextChunkLocation loc, PdfFont pdfFont, LineSegment baseLine, LineSegment ascentLine, LineSegment descentLine) {
            this.text = string;
            this.location = loc;
            this.pdfFont = pdfFont;
            this.baseLine = baseLine;
            this.ascentLine = ascentLine;
            this.descentLine = descentLine;
        }

        public String getText() {
            return this.text;
        }

        public PdfFont getPdfFont() {
            return this.pdfFont;
        }

        public LineSegment getBaseLine() {
            return this.baseLine;
        }

        public LineSegment getAscentLine() {
            return this.ascentLine;
        }

        public LineSegment getDescentLine() {
            return this.descentLine;
        }

        public ITextChunkLocation getLocation() {
            return this.location;
        }

        public Rectangle getRectangle() {
            float x0 = this.descentLine.getStartPoint().get(0);
            float y0 = this.descentLine.getStartPoint().get(1);
            float h = this.ascentLine.getStartPoint().get(1) - this.descentLine.getStartPoint().get(1);
            float w = Math.abs(this.descentLine.getStartPoint().get(0) - this.descentLine.getEndPoint().get(0));
            Rectangle chunkRectangle = new Rectangle(x0, y0, w, h);
            return chunkRectangle;
        }

        @Override
        public int compareTo(TextChunk rhs) {
            return this.location.compareTo(rhs.location);
        }

        void printDiagnostics() {
            System.out.println("Text (@" + this.location.getStartLocation() + " -> " + this.location.getEndLocation() + "): " + this.text);
            System.out.println("orientationMagnitude: " + this.location.orientationMagnitude());
            System.out.println("distPerpendicular: " + this.location.distPerpendicular());
            System.out.println("distParallel: " + this.location.distParallelStart());
        }

        boolean sameLine(TextChunk lastChunk) {
            return this.getLocation().sameLine(lastChunk.getLocation());
        }
    }

    public static interface ITextChunkLocation
    extends Comparable<ITextChunkLocation> {
        public float distParallelEnd();

        public float distParallelStart();

        public int distPerpendicular();

        public float getCharSpaceWidth();

        public Vector getEndLocation();

        public Vector getStartLocation();

        public Vector getOrientationVector();

        public int orientationMagnitude();

        public boolean sameLine(ITextChunkLocation var1);

        public float distanceFromEndOf(ITextChunkLocation var1);

        public boolean isAtWordBoundary(ITextChunkLocation var1);
    }

    public static interface ITextChunkLocationStrategy {
        public ITextChunkLocation createLocation(TextRenderInfo var1, LineSegment var2);
    }
}

