/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util;

import cfca.paperless.base.util.StringUtil;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMaskingUtils {
    private static final Logger logger = LoggerFactory.getLogger(DataMaskingUtils.class);

    public static String phoneMasking(String phone) {
        if (!StringUtil.isEmpty(phone)) {
            return phone.replaceAll("(^\\d{3})\\d.*(\\d{4}$)", "$1****$2");
        }
        return null;
    }

    public static String idMasking(String id) {
        if (!StringUtil.isEmpty(id)) {
            return id.replaceAll("(\\d{6})\\d{8}(\\w{4})", "$1********$2");
        }
        return null;
    }

    public static String emailMasking(String email) {
        if (!StringUtil.isEmpty(email)) {
            return email.replaceAll("(\\w?)(\\w+)(\\w)(@\\w+\\.[a-z]+(\\.[a-z]+)?)", "$1****$3$4");
        }
        return null;
    }

    public static String nameMasking(String name) {
        if (!StringUtil.isEmpty(name)) {
            return name.replaceAll("([\\d\\D]{1})(.*)", "$1**");
        }
        return null;
    }

    public static String englishNameMasking(String name) {
        if (!StringUtil.isEmpty(name)) {
            return name.replaceAll("([\\d\\D]{1})(.*)", "$1**");
        }
        return null;
    }

    public static String addressMasking(String address) {
        if (!StringUtil.isEmpty(address)) {
            return address.replaceAll("([\\u4e00-\\u9fa5]{3})(.*)", "$1****");
        }
        return null;
    }

    public static String fixedPhoneMasking(String fixedPhone) {
        if (!StringUtil.isEmpty(fixedPhone)) {
            return fixedPhone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
        }
        return null;
    }

    public static String dnMasking(String dn) {
        if (StringUtil.isNotEmpty(dn)) {
            return Pattern.compile("[\u4e00-\u9fa5]").matcher(dn).replaceAll("*");
        }
        return null;
    }

    public static String requestParmMasking(String requestParam) {
        String result = requestParam;
        int n = requestParam.indexOf("userName");
        while (n >= 0) {
            int m = requestParam.indexOf(",", n);
            if (m == -1) {
                m = requestParam.indexOf("}", n);
            }
            if (m == -1) break;
            System.out.println("m=" + m + ",n=" + n);
            System.out.println(requestParam.substring(n + 10, m - 1));
            if (m - n > 12) {
                requestParam = result = requestParam.substring(0, n + 11) + DataMaskingUtils.nameMasking(requestParam.substring(n + 11, m - 1)) + requestParam.substring(m - 1, requestParam.length());
            }
            n = requestParam.indexOf("userName", m);
        }
        int p = result.indexOf("identificationNo");
        while (p >= 0) {
            int o = result.indexOf(",", p);
            if (o == -1) {
                o = result.indexOf("}", p);
            }
            if (o == -1) break;
            System.out.println(p + "," + o);
            if (o - p > 20) {
                result = result.substring(0, p + 18) + DataMaskingUtils.idMasking(result.substring(p + 18, o - 1)) + result.substring(o - 1, result.length());
            }
            p = requestParam.indexOf("identificationNo", o);
        }
        int a = result.indexOf("phoneNo");
        while (a >= 0) {
            int b = result.indexOf(",", a);
            System.out.println(b + "," + a);
            if (b == -1) {
                b = result.indexOf("}", a);
            }
            if (b == -1) break;
            if (b - a > 12) {
                String phoneNoStr = result.substring(a + 10, b - 1);
                if (phoneNoStr.startsWith("0")) {
                    phoneNoStr = phoneNoStr.replace("-", "");
                    result = result.substring(0, a + 10) + DataMaskingUtils.fixedPhoneMasking(phoneNoStr) + result.substring(b - 1, result.length());
                } else {
                    result = result.substring(0, a + 10) + DataMaskingUtils.phoneMasking(phoneNoStr) + result.substring(b - 1, result.length());
                }
            }
            a = requestParam.indexOf("phoneNo", b);
        }
        int c = result.indexOf("certDn");
        System.out.println("c=" + c);
        while (c >= 0) {
            int d = result.indexOf(",", c);
            System.out.println("d=" + d + ",c=" + c);
            if (d == -1) {
                d = result.indexOf("}", a);
            }
            if (d == -1) break;
            if (d - c > 8) {
                System.out.println(result.substring(c + 6, d - 1));
                result = result.substring(0, c + 6) + DataMaskingUtils.dnMasking(result.substring(c + 6, d)) + result.substring(d - 1, result.length());
            }
            c = result.indexOf("certDn", d);
        }
        return result;
    }

    public static void main(String[] args) {
        System.out.println(DataMaskingUtils.phoneMasking("1390876453421"));
        System.out.println(DataMaskingUtils.idMasking("1101201988090919918"));
        System.out.println(DataMaskingUtils.emailMasking("test@cfca.com.cn"));
        System.out.println(DataMaskingUtils.nameMasking("\u738b\u5c0f\u5ddd"));
        System.out.println(DataMaskingUtils.englishNameMasking("\u738b\u5c0f\u5ddd"));
        System.out.println(DataMaskingUtils.addressMasking("\u5317\u4eac\u5e02\u897f\u57ce\u533a\u83dc\u5e02\u53e3\u5357\u5927\u8857\u5e73\u539f\u91cc20-3"));
        System.out.println(DataMaskingUtils.fixedPhoneMasking("01098763525"));
        System.out.println(DataMaskingUtils.dnMasking("CN=051@\u5f20\u6653\u66681390876453421@OU=Individual-1@,OU=CFCA PROXY TEST@O=CFCA TEST CA"));
        String str = "headJsonStr={\"sealCert\":{\"customerType\":\"2\",\"userName\":\"\u5f20\u83f2\u5206\", \"userName\":\"\",\"identificationType\":\"G\",\"identificationNo\":\"110120198612030093\",\"phoneNo\":\"13569441258\",\"phoneNo\":\"010-90876543\",\"certDn\":\"CN=051@\u5f20\u6653\u66681390876453421@OU=Individual-1@,OU=CFCA PROXY TEST@O=CFCA TEST CA\"}";
        System.out.println(DataMaskingUtils.requestParmMasking(str));
    }
}

