/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.c200r.C200RSAKey;
import cfca.sadk.lib.crypto.card.c200r.RSARefPublicKeyParams;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERUTF8String;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;

public final class C200InternalRSAPrivateKey
implements RSAPrivateKey,
C200RSAKey {
    private static final long serialVersionUID = -3958659078118796232L;
    final int bitLength;
    final byte[] keyData;
    final int keyIndex;
    final RSAKeyParameters pubKeyParam;

    C200InternalRSAPrivateKey(int keyIndex, byte[] pubKeyData) throws CardException {
        if (keyIndex <= 0) {
            throw new CardParameterException("C200RSACard invalid keyIndex = " + keyIndex);
        }
        RSARefPublicKeyParams params = new RSARefPublicKeyParams(pubKeyData);
        this.bitLength = params.bitLength;
        this.pubKeyParam = params.params;
        this.keyData = (byte[])params.keyData.clone();
        this.keyIndex = keyIndex;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "C200R";
    }

    public byte[] getEncoded() {
        try {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(new DERUTF8String("C200R#keyIndex"));
            v.add(new ASN1Integer(this.keyIndex));
            v.add(new ASN1Integer(this.pubKeyParam.getModulus()));
            v.add(new ASN1Integer(this.pubKeyParam.getExponent()));
            DERSequence value = new DERSequence(v);
            return value.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("C200InternalRSAPrivateKey [bitLength=");
        builder.append(this.bitLength);
        builder.append(",pubKeyData=");
        builder.append(Hex.toHexString(this.keyData));
        builder.append(",keyIndex=");
        builder.append(this.keyIndex);
        builder.append("]");
        return builder.toString();
    }

    public boolean isHardKey() {
        return true;
    }

    public int getKeyIndex() {
        return this.keyIndex;
    }

    public int modulusBitsLength() {
        return this.bitLength;
    }

    public int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public byte[] keyData() throws CardException {
        throw new CardException("C200InternalRSAPrivateKey not support keyData()");
    }

    public String dumpPublicKey() {
        return "pubKeyData=" + Hex.toHexString(this.keyData, 0, 1028);
    }

    public BigInteger getModulus() {
        return this.pubKeyParam.getModulus();
    }

    public BigInteger getPrivateExponent() {
        throw new UnsupportedOperationException("C200InternalRSAPrivateKey not support getPrivateExponent(): keyIndex=" + this.keyIndex);
    }
}

