/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200r;

import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.c200r.BigIntegers;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import java.math.BigInteger;

final class RSARefPublicKeyParams {
    final byte[] keyData;
    final int bitLength;
    final RSAKeyParameters params;

    RSARefPublicKeyParams(byte[] keyData) throws CardException {
        int bitLength = BigIntegers.parseModulusBitLength(keyData);
        if (keyData.length < 1028) {
            throw new CardParameterException("RSARefPublicKeyParams failure with invalid param#keyData");
        }
        int eMaxBitLength = 32;
        int maxLength = 512;
        int offset = 4;
        BigInteger modulus = BigIntegers.parseBigInteger(keyData, offset, 512, bitLength);
        BigInteger exponent = BigIntegers.parseBigInteger(keyData, offset += 512, 512, 32);
        this.keyData = keyData;
        this.bitLength = bitLength;
        this.params = new RSAKeyParameters(false, modulus, exponent);
    }

    RSARefPublicKeyParams(RSAKeyParameters params) throws CardException {
        if (params == null) {
            throw new CardParameterException("RSARefPublicKeyParams failure with invalid param#params");
        }
        BigInteger modulus = params.getModulus();
        int bitLength = BigIntegers.parseModulusBitLength(modulus);
        byte[] keyData = this.buildKeyData(bitLength, params);
        this.params = params;
        this.bitLength = bitLength;
        this.keyData = keyData;
    }

    private byte[] buildKeyData(int bitLength, RSAKeyParameters params) throws CardException {
        byte[] keyData = new byte[1028];
        int offset = BigIntegers.copyBitLength(bitLength, keyData, 0);
        int maxLength = 512;
        BigIntegers.copyBigInteger("params#modulus", params.getModulus(), 512, keyData, offset);
        BigIntegers.copyBigInteger("params#exponent", params.getExponent(), 512, keyData, offset += 512);
        if ((offset += 512) != keyData.length) {
            throw new CardParameterException("buildKeyData failure with invalid offset");
        }
        return keyData;
    }
}

