/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.extend.session.ECCCurveId;
import cfca.sadk.jcajce.provider.SADKProvider;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.Attribute;
import cfca.sadk.org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertBag;
import cfca.sadk.org.bouncycastle.asn1.pkcs.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.EncryptedData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.MacData;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PBEParameter;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import cfca.sadk.org.bouncycastle.asn1.pkcs.Pfx;
import cfca.sadk.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SafeBag;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.DigestInfo;
import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.org.bouncycastle.crypto.digests.MD2Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.MD5Digest;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.crypto.engines.RC2Engine;
import cfca.sadk.org.bouncycastle.crypto.generators.PKCS12ParametersGenerator;
import cfca.sadk.org.bouncycastle.crypto.macs.HMac;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPrivateCrtKey;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.Memoable;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.signature.rsa.SafeContents;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.logging.LoggerManager;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.PKCS8EncodedKeySpec;

public class PKCS12 {
    private Pfx pfx;
    private PrivateKey privateKey = null;
    private X509Cert[] certs = null;
    private static final int ITERATIONS = 2000;

    public PKCS12() {
        this.pfx = null;
    }

    public PKCS12(byte[] pfxFileData) throws PKIException {
        if (pfxFileData == null) {
            throw new PKIException("PFXFile pfxFileData should not be null");
        }
        this.load(pfxFileData);
    }

    public void load(Pfx _pfx) {
        this.pfx = _pfx;
    }

    public void load(String fileName) throws PKIException {
        byte[] encoding;
        if (fileName == null) {
            throw new PKIException("PFXFile fileName should not be null");
        }
        File file = new File(fileName);
        if (!file.exists()) {
            throw new PKIException("PFXFile fileName not found: " + file.getAbsolutePath());
        }
        try {
            encoding = FileHelper.read(fileName);
        }
        catch (IOException e) {
            throw new PKIException("PFXFile reading failure", e);
        }
        this.load(encoding);
    }

    public void load(InputStream in) throws PKIException {
        if (in == null) {
            throw new PKIException("Argument not allowed null for InputStream");
        }
        byte[] encoding = null;
        try {
            encoding = new byte[in.available()];
            in.read(encoding);
        }
        catch (IOException e) {
            throw new PKIException("PFXFile reading failure", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.load(encoding);
    }

    public void load(byte[] encoding) throws PKIException {
        if (encoding == null) {
            throw new PKIException("PFXFile encoding should not be null");
        }
        ASN1Sequence seq = null;
        try {
            seq = ASN1Parser.getDERSequenceFrom(encoding);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile encoding decoding failure", e);
        }
        try {
            this.pfx = Pfx.getInstance(seq);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile object decoding failure", e);
        }
    }

    public X509Cert[] getCerts() throws PKIException {
        if (this.certs == null) {
            throw new PKIException("PFXFile hasn't been decrypted yet.");
        }
        return this.certs;
    }

    public PrivateKey getPrivateKey() throws PKIException {
        if (this.privateKey == null) {
            throw new PKIException("PFXFile hasn't been decrypted yet.");
        }
        return this.privateKey;
    }

    public PrivateKey decrypt(char[] _password) throws PKIException {
        int i;
        ContentInfo[] contentInfos;
        if (this.pfx == null) {
            throw new IllegalStateException("PFXFile must loading first!");
        }
        if (_password == null) {
            throw new PKIException("PFXFile password should not be null");
        }
        byte[] passwordBytes = null;
        try {
            passwordBytes = PKCS12ParametersGenerator.PKCS12PasswordToBytes(_password);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile password invalid");
        }
        if (!this.DecryptAndVerifyMac(passwordBytes)) {
            throw new PKIException("PFXFile password invalid");
        }
        try {
            ContentInfo authSafe = this.pfx.getAuthSafe();
            ASN1OctetString context = ASN1OctetString.getInstance(authSafe.getContent());
            AuthenticatedSafe authenticatedSafe = AuthenticatedSafe.getInstance(context.getOctets());
            contentInfos = authenticatedSafe.getContentInfo();
        }
        catch (Exception e) {
            throw new PKIException("PFXFile ContentInfo invalid", e);
        }
        if (contentInfos == null || contentInfos.length == 0) {
            throw new PKIException("PFXFile ContentInfo missing");
        }
        PrivateKey privateKey = null;
        X509Cert cert = null;
        X509Cert[] certs = null;
        ASN1ObjectIdentifier contentType = null;
        ContentInfo contentInfo = null;
        for (i = 0; i < contentInfos.length; ++i) {
            contentInfo = contentInfos[i];
            contentType = contentInfos[i].getContentType();
            if (contentType.equals(PKCSObjectIdentifiers.data)) {
                ASN1OctetString content = ASN1OctetString.getInstance(contentInfo.getContent());
                SafeContents safeContents = SafeContents.getInstance(ASN1Sequence.getInstance(content.getOctets()));
                SafeBag[] safeBag = safeContents.getSafeBag();
                if (safeBag == null || safeBag.length == 0) {
                    throw new PKIException("PFXFile safeBag missing");
                }
                SafeBag keyBag = safeBag[0];
                ASN1ObjectIdentifier bagId = keyBag.getBagId();
                if (bagId.equals(PKCSObjectIdentifiers.keyBag)) {
                    privateKey = this.decodeKeyBag(keyBag, passwordBytes, false);
                    continue;
                }
                if (bagId.equals(PKCSObjectIdentifiers.certBag)) {
                    cert = this.decodeCertBag(keyBag.getBagValue());
                    continue;
                }
                if (bagId.equals(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag)) {
                    privateKey = this.decodeKeyBag(keyBag, passwordBytes, true);
                    continue;
                }
                throw new PKIException("PFXFile handle keyBag error. bagId = " + keyBag.getBagId().getId());
            }
            if (!contentType.equals(PKCSObjectIdentifiers.encryptedData)) continue;
            EncryptedData encryptedData = EncryptedData.getInstance(contentInfo.getContent());
            AlgorithmIdentifier encryptionAlgorithm = encryptedData.getEncryptionAlgorithm();
            PKCS12PBEParams pebParams = PKCS12PBEParams.getInstance(encryptionAlgorithm.getParameters());
            PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            p12gen.init(passwordBytes, pebParams.getIV(), pebParams.getIterations().intValue());
            byte[] encryptData = encryptedData.getContent().getOctets();
            byte[] decryptData = this.PBEDecryptContent(encryptionAlgorithm.getAlgorithm().getId(), p12gen, encryptData);
            SafeContents safeContents = SafeContents.getInstance(ASN1Sequence.getInstance(decryptData));
            SafeBag[] safeBags = safeContents.getSafeBag();
            certs = new X509Cert[safeBags.length];
            int num = 0;
            for (SafeBag afeBag : safeBags) {
                if (!afeBag.getBagId().equals(PKCSObjectIdentifiers.certBag)) continue;
                certs[num++] = this.decodeCertBag(afeBag.getBagValue());
            }
            if (certs.length == num) {
                LoggerManager.systemLogger.warn("PKCS#12 certs ==0 ");
                continue;
            }
            X509Cert[] outResult = new X509Cert[num];
            System.arraycopy(certs, 0, outResult, 0, outResult.length);
            certs = outResult;
        }
        this.certs = certs == null || certs.length == 0 ? new X509Cert[]{cert} : certs;
        this.privateKey = privateKey;
        for (i = 0; i < passwordBytes.length; ++i) {
            passwordBytes[0] = 0;
        }
        passwordBytes = null;
        return privateKey;
    }

    private byte[] PBEDecryptContent(String algName, PKCS12ParametersGenerator p12gen, byte[] en_data) throws PKIException {
        byte[] keyBagBytes;
        block6: {
            try {
                if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC.getId())) {
                    ParametersWithIV param = (ParametersWithIV)p12gen.generateDerivedParameters(192, 64);
                    byte[] keyData = ((KeyParameter)param.getParameters()).getKey();
                    Mechanism mechanism = new Mechanism("DESede/CBC/PKCS7Padding", new CBCParam(param.getIV()));
                    keyBagBytes = SymmetricHelper.dataDecrypt(false, mechanism, keyData, en_data);
                    break block6;
                }
                if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2DESCBC.getId())) {
                    ParametersWithIV param = (ParametersWithIV)p12gen.generateDerivedParameters(128, 64);
                    byte[] keyData = ((KeyParameter)param.getParameters()).getKey();
                    Mechanism mechanism = new Mechanism("DESede/CBC/PKCS7Padding", new CBCParam(param.getIV()));
                    keyBagBytes = SymmetricHelper.dataDecrypt(false, mechanism, keyData, en_data);
                    break block6;
                }
                if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128RC2CBC.getId())) {
                    CipherParameters param = p12gen.generateDerivedParameters(128, 64);
                    keyBagBytes = PKCS12.RC2Encrypt(false, param, en_data);
                    break block6;
                }
                if (algName.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40RC2CBC.getId())) {
                    CipherParameters param = p12gen.generateDerivedParameters(40, 64);
                    keyBagBytes = PKCS12.RC2Encrypt(false, param, en_data);
                    break block6;
                }
                throw new PKIException("PFXFile keyBag pkcs12pbe failure with invalid algorithm: " + algName);
            }
            catch (Exception e) {
                throw new PKIException("PFXFile keyBag pkcs12pbe failure with invalid password", e);
            }
        }
        return keyBagBytes;
    }

    private X509Cert decodeCertBag(ASN1Encodable asn1) throws PKIException {
        X509Cert cert;
        block4: {
            cert = null;
            try {
                CertBag certBag = CertBag.getInstance(asn1);
                ASN1ObjectIdentifier certId = certBag.getCertId();
                if (certId.equals(PKCSObjectIdentifiers.x509certType)) {
                    cert = new X509Cert(ASN1OctetString.getInstance(certBag.getCertValue()).getOctets());
                    break block4;
                }
                if (certId.equals(PKCSObjectIdentifiers.sdsiCertType)) {
                    LoggerManager.systemLogger.warn("PKCS#12 certId ==" + PKCSObjectIdentifiers.sdsiCertType);
                    break block4;
                }
                throw new PKIException("PFXFile certBag with invalid certBagType=" + certId.getId());
            }
            catch (Exception e) {
                throw new PKIException("PFXFile certBag invalid ", e);
            }
        }
        return cert;
    }

    private PrivateKey decodeKeyBag(SafeBag keyBag, byte[] passwordBytes, boolean shrouded) throws PKIException {
        PrivateKey privateKey;
        block11: {
            byte[] encoding;
            if (shrouded) {
                try {
                    EncryptedPrivateKeyInfo epki = EncryptedPrivateKeyInfo.getInstance(keyBag.getBagValue());
                    PBEParameter pbeParamSpec = PBEParameter.getInstance(epki.getEncryptionAlgorithm().getParameters());
                    PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
                    p12gen.init(passwordBytes, pbeParamSpec.getSalt(), pbeParamSpec.getIterationCount().intValue());
                    encoding = this.PBEDecryptContent(epki.getEncryptionAlgorithm().getAlgorithm().getId(), p12gen, epki.getEncryptedData());
                }
                catch (Exception e) {
                    throw new PKIException("PFXFile keyBag decrypt failure", e);
                }
            }
            try {
                encoding = keyBag.getBagValue().toASN1Primitive().getEncoded();
            }
            catch (IOException e) {
                throw new PKIException("PFXFile keyBag encoding invalid", e);
            }
            privateKey = null;
            if (encoding != null) {
                try {
                    PKCS8EncodedKeySpec pkcs8Spec = new PKCS8EncodedKeySpec(encoding);
                    PrivateKeyInfo info = PrivateKeyInfo.getInstance(pkcs8Spec.getEncoded());
                    ASN1ObjectIdentifier algorithm = info.getPrivateKeyAlgorithm().getAlgorithm();
                    if (PKCSObjectIdentifiers.rsaEncryption.equals(algorithm)) {
                        privateKey = new BCRSAPrivateCrtKey(info);
                        break block11;
                    }
                    if (PKCSObjectIdentifiers.ecEncryption.equals(algorithm)) {
                        privateKey = this.decodePrivateKey(info, pkcs8Spec);
                        break block11;
                    }
                    throw new PKIException("PFXFile keyBag PrivateKey invalid encoding");
                }
                catch (PKIException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKIException("PFXFile keyBag PrivateKey build failure", e);
                }
            }
        }
        return privateKey;
    }

    private PrivateKey decodePrivateKey(PrivateKeyInfo info, PKCS8EncodedKeySpec pkcs8Spec) throws PKIException {
        PrivateKey key;
        ASN1Encodable param = info.getPrivateKeyAlgorithm().getParameters();
        if (param == null) {
            throw new PKIException("PFXFile keyBag PrivateKey missing algorithm parameters");
        }
        if (!(param instanceof ASN1ObjectIdentifier)) {
            throw new PKIException("PFXFile keyBag PrivateKey invalid algorithm parameters");
        }
        ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(param);
        if (oid.getId().startsWith("1.2.156.10197") || oid.getId().startsWith("1.2.156.197")) {
            try {
                key = SM2PrivateKey.getInstance(pkcs8Spec.getEncoded());
            }
            catch (Exception e) {
                throw new PKIException("PFXFile keyBag SM2PrivateKey decode failed ", e);
            }
        }
        ECCCurveId curveId = ECCCurveId.findECCCurveId(oid.getId());
        if (curveId == null || !ECCCurveId.isCardSupport(curveId)) {
            throw new PKIException("PFXFile keyBag ECCPrivateKey not support ecc=" + oid);
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("ECDSA", SADKProvider.INSTANCE());
            key = kf.generatePrivate(pkcs8Spec);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile keyBag ECCPrivateKey decode failed ", e);
        }
        return key;
    }

    private boolean DecryptAndVerifyMac(byte[] password) throws PKIException {
        try {
            MacData macData = this.pfx.getMacData();
            DigestInfo digestInfo = macData.getMac();
            ASN1ObjectIdentifier oid = digestInfo.getAlgorithmId().getAlgorithm();
            PKCS12ParametersGenerator p12gen = null;
            int keyLen = 0;
            Memoable digest = null;
            if (oid.equals(PKCSObjectIdentifiers.sha1)) {
                p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
                keyLen = 160;
                digest = new SHA1Digest();
            } else if (oid.equals(PKCSObjectIdentifiers.md2)) {
                p12gen = new PKCS12ParametersGenerator(new MD2Digest());
                keyLen = 128;
                digest = new MD2Digest();
            } else if (oid.equals(PKCSObjectIdentifiers.md5)) {
                p12gen = new PKCS12ParametersGenerator(new MD5Digest());
                keyLen = 128;
                digest = new MD5Digest();
            } else {
                throw new PKIException("not support digest algorithmIdentifier:" + oid);
            }
            byte[] salt = macData.getSalt();
            int iterations = macData.getIterationCount().intValue();
            p12gen.init(password, salt, iterations);
            CipherParameters param = p12gen.generateDerivedMacParameters(keyLen);
            KeyParameter keyParam = (KeyParameter)param;
            ASN1OctetString oct = ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent());
            byte[] content = oct.getOctets();
            HMac hmac = new HMac((Digest)((Object)digest));
            hmac.init(keyParam);
            hmac.update(content, 0, content.length);
            byte[] my_digest = new byte[hmac.getMacSize()];
            hmac.doFinal(my_digest, 0);
            byte[] digest_ori = digestInfo.getDigest();
            return Arrays.areEqual(my_digest, digest_ori);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile MacData checked failure", e);
        }
    }

    private static byte[] RC2Encrypt(boolean isEncrypt, CipherParameters param, byte[] data) throws PKIException {
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new RC2Engine()));
            cipher.init(isEncrypt, param);
            byte[] out = new byte[cipher.getOutputSize(data.length)];
            int returnLength = cipher.processBytes(data, 0, data.length, out, 0);
            int validLength = -1;
            if (returnLength < out.length) {
                validLength = cipher.doFinal(out, returnLength);
            }
            if (isEncrypt) {
                return out;
            }
            byte[] d = new byte[out.length - cipher.getBlockSize() + validLength];
            System.arraycopy(out, 0, d, 0, d.length);
            return d;
        }
        catch (DataLengthException e) {
            throw new PKIException("PFXFile Operations failure with DataLengthException", e);
        }
        catch (IllegalArgumentException e) {
            throw new PKIException("PFXFile Operations failure with IllegalArgumentException", e);
        }
        catch (IllegalStateException e) {
            throw new PKIException("PFXFile Operations failure with IllegalStateException", e);
        }
        catch (InvalidCipherTextException e) {
            throw new PKIException("PFXFile Operations failure with InvalidCipherTextException", e);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile Operations failure with Exception", e);
        }
    }

    private static EncryptedPrivateKeyInfo GenerateEncryptedPrivateKeyInfo(PrivateKey privateKey, byte[] password) throws PKIException {
        try {
            byte[] keyData = privateKey.getEncoded();
            SecureRandom sRandom = new SecureRandom();
            byte[] salt = new byte[8];
            sRandom.nextBytes(salt);
            PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            p12gen.init(password, salt, 2000);
            ParametersWithIV param = (ParametersWithIV)p12gen.generateDerivedParameters(192, 64);
            byte[] keyBytes = ((KeyParameter)param.getParameters()).getKey();
            Mechanism mechanism = new Mechanism("DESede/CBC/PKCS7Padding", new CBCParam(param.getIV()));
            byte[] encryptedKeyBytes = SymmetricHelper.dataEncrypt(false, mechanism, keyBytes, keyData);
            DEROctetString deS = new DEROctetString(encryptedKeyBytes);
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add(new DEROctetString(salt));
            vector.add(new ASN1Integer(2000L));
            DERSequence deSeq = new DERSequence(vector);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd3DESCBC, deSeq);
            vector = new ASN1EncodableVector();
            vector.add(algId);
            vector.add(deS);
            deSeq = new DERSequence(vector);
            return EncryptedPrivateKeyInfo.getInstance(deSeq);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile Encrypted PrivateKeyInfo failure", e);
        }
    }

    private static EncryptedData GenerateSaftContents(ASN1Encodable safeContents, byte[] password) throws PKIException {
        try {
            SecureRandom sRandom = new SecureRandom();
            byte[] salt = new byte[8];
            sRandom.nextBytes(salt);
            PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            p12gen.init(password, salt, 2000);
            CipherParameters param = p12gen.generateDerivedParameters(40, 64);
            byte[] en_data = PKCS12.RC2Encrypt(true, param, ASN1Parser.parseDERObj2Bytes(safeContents));
            DEROctetString octString = new DEROctetString(en_data);
            ASN1EncodableVector vector = new ASN1EncodableVector();
            vector.add(new DEROctetString(salt));
            vector.add(new ASN1Integer(2000L));
            DERSequence deSeq = new DERSequence(vector);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.pbeWithSHAAnd40RC2CBC, deSeq);
            return new EncryptedData(PKCSObjectIdentifiers.data, algId, octString);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile EncryptedSaftContents failure", e);
        }
    }

    private static MacData GenerateMacData(ContentInfo authSafe, byte[] password) throws PKIException {
        try {
            SecureRandom sRandom = new SecureRandom();
            byte[] salt = new byte[8];
            sRandom.nextBytes(salt);
            PKCS12ParametersGenerator p12gen = new PKCS12ParametersGenerator(new SHA1Digest());
            p12gen.init(password, salt, 2000);
            CipherParameters param = p12gen.generateDerivedMacParameters(160);
            ASN1OctetString oct = ASN1OctetString.getInstance(authSafe.getContent());
            byte[] da = oct.getOctets();
            HMac mac = new HMac(new SHA1Digest());
            mac.init(param);
            mac.update(da, 0, da.length);
            byte[] hmac = new byte[mac.getMacSize()];
            mac.doFinal(hmac, 0);
            DigestInfo digestInfo = new DigestInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1), hmac);
            return new MacData(digestInfo, salt, 2000);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile MacData Generated failure", e);
        }
    }

    public static String generatePfxFile(X509Cert x509Cert, PrivateKey privateKey, String password, String fileName) throws PKIException {
        if (fileName == null) {
            throw new PKIException("PFXFile fileName should not be null");
        }
        byte[] data = PKCS12.generatePfxData(x509Cert, privateKey, password);
        try {
            FileHelper.write(fileName, data);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile write failure", e);
        }
        return fileName;
    }

    public static byte[] generatePfxData(X509Cert x509Cert, PrivateKey privateKey, String password) throws PKIException {
        Pfx pfx = PKCS12.generatePfx(x509Cert, privateKey, password);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DEROutputStream out = new DEROutputStream(baos);
            out.writeObject(pfx);
            out.close();
        }
        catch (IOException e) {
            throw new PKIException("PFXData generating failure", e);
        }
        return baos.toByteArray();
    }

    public static Pfx generatePfx(X509Cert x509Cert, PrivateKey privateKey, String password) throws PKIException {
        byte[] passwordBytes;
        if (password == null || password.length() == 0) {
            throw new PKIException("PFXFile password should not be null");
        }
        PKCS12.checkCertWithPrivateKey(x509Cert, privateKey);
        try {
            passwordBytes = PKCS12ParametersGenerator.PKCS12PasswordToBytes(password.toCharArray());
        }
        catch (Exception e) {
            throw new PKIException("PFXFile password encoding invalid", e);
        }
        EncryptedPrivateKeyInfo epki = PKCS12.GenerateEncryptedPrivateKeyInfo(privateKey, passwordBytes);
        try {
            ContentInfo certContent;
            ASN1Integer dint = new ASN1Integer(x509Cert.getSerialNumber());
            byte[] sn = ASN1Parser.parseDERObj2Bytes(dint);
            DEROctetString osn = new DEROctetString(sn);
            ASN1EncodableVector derV = new ASN1EncodableVector();
            derV.add(osn);
            DERSet derSet = new DERSet(derV);
            Attribute attribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_localKeyId, derSet);
            derV = new ASN1EncodableVector();
            derV.add(attribute);
            derSet = new DERSet(derV);
            SafeBag keyBag = new SafeBag(PKCSObjectIdentifiers.pkcs8ShroudedKeyBag, ASN1Parser.parseBytes2DERObj(epki.getEncoded()), derSet);
            SafeBag[] keyBags = new SafeBag[]{keyBag};
            SafeContents safeContents = new SafeContents(keyBags);
            DEROctetString octString = new DEROctetString(ASN1Parser.parseDERObj2Bytes(safeContents));
            ContentInfo keyContent = new ContentInfo(PKCSObjectIdentifiers.data, octString);
            ContentInfo[] contentInfos = new ContentInfo[2];
            contentInfos[0] = keyContent;
            octString = new DEROctetString(x509Cert.getEncoding());
            CertBag certBag = new CertBag(PKCSObjectIdentifiers.x509certType, octString);
            SafeBag sbag = new SafeBag(PKCSObjectIdentifiers.certBag, certBag, derSet);
            SafeBag[] certBags = new SafeBag[]{sbag};
            safeContents = new SafeContents(certBags);
            EncryptedData encryptedData = PKCS12.GenerateSaftContents(safeContents, passwordBytes);
            contentInfos[1] = certContent = new ContentInfo(PKCSObjectIdentifiers.encryptedData, encryptedData);
            AuthenticatedSafe authenticatedSafe = new AuthenticatedSafe(contentInfos);
            octString = new DEROctetString(ASN1Parser.parseDERObj2Bytes(authenticatedSafe));
            ContentInfo authSafe = new ContentInfo(PKCSObjectIdentifiers.data, octString);
            MacData macData = PKCS12.GenerateMacData(authSafe, passwordBytes);
            return new Pfx(authSafe, macData);
        }
        catch (IOException e) {
            throw new PKIException("PFXFile generating failure", e);
        }
    }

    private static Mechanism buildSignAlg(X509Cert x509Cert) throws PKIException {
        Mechanism mechanism;
        if (x509Cert == null) {
            throw new PKIException("PFXFile x509Cert should not be null");
        }
        if (x509Cert.isSM2Cert()) {
            mechanism = new Mechanism("sm3WithSM2Encryption");
        } else if (x509Cert.isRSACert()) {
            mechanism = new Mechanism("sha256WithRSAEncryption");
        } else if (x509Cert.isECCCert()) {
            mechanism = new Mechanism("sha256WithECDSAEncryption");
        } else {
            throw new PKIException("PFXFile x509Cert do not support");
        }
        return mechanism;
    }

    private static boolean checkCertWithPrivateKey(X509Cert x509Cert, PrivateKey privateKey) throws PKIException {
        boolean verifyResult;
        if (privateKey == null) {
            throw new PKIException("PFXFile privateKey should not be null");
        }
        Mechanism mechanism = PKCS12.buildSignAlg(x509Cert);
        Session softLib = BCSoftLib.INSTANCE();
        byte[] sourceData = Strings.toByteArray("TESTING");
        try {
            byte[] signData = softLib.sign(mechanism, privateKey, sourceData);
            verifyResult = softLib.verify(mechanism, x509Cert.getPublicKey(), sourceData, signData);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile x509Cert/privateKey try signing failure", e);
        }
        if (!verifyResult) {
            throw new PKIException("PFXFile x509Cert/privateKey not match");
        }
        return verifyResult;
    }
}

