/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl;

import cfca.sadk.tls.sun.security.ssl.Authenticator;
import cfca.sadk.tls.sun.security.ssl.Debugger;
import cfca.sadk.tls.sun.security.ssl.EngineArgs;
import cfca.sadk.tls.sun.security.ssl.EngineOutputRecord;
import cfca.sadk.tls.sun.security.ssl.sec.CipherBox;
import cfca.sadk.tls.util.Hexifys;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import javax.net.ssl.SSLEngineResult;

final class EngineWriter {
    private LinkedList<Object> outboundList = new LinkedList();
    private boolean outboundClosed = false;

    EngineWriter() {
    }

    private SSLEngineResult.HandshakeStatus getOutboundData(ByteBuffer dstBB) {
        Object msg = this.outboundList.removeFirst();
        assert (msg instanceof ByteBuffer);
        ByteBuffer bbIn = (ByteBuffer)msg;
        assert (dstBB.remaining() >= bbIn.remaining());
        dstBB.put(bbIn);
        if (this.hasOutboundDataInternal()) {
            msg = this.outboundList.getFirst();
            if (msg == SSLEngineResult.HandshakeStatus.FINISHED) {
                this.outboundList.removeFirst();
                return SSLEngineResult.HandshakeStatus.FINISHED;
            }
            return SSLEngineResult.HandshakeStatus.NEED_WRAP;
        }
        return null;
    }

    synchronized void writeRecord(EngineOutputRecord outputRecord, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("writer side was already closed.");
        }
        outputRecord.write(authenticator, writeCipher);
        if (outputRecord.isFinishedMsg()) {
            this.outboundList.addLast((Object)SSLEngineResult.HandshakeStatus.FINISHED);
        }
    }

    private void debuggingDumpPacket(EngineArgs ea, boolean hsData) {
        if (Debugger.packet.isDebugEnabled()) {
            try {
                ByteBuffer data = ea.netData.duplicate();
                int pos = data.position();
                data.position(pos - ea.deltaNet());
                data.limit(pos);
                StringBuilder builder = new StringBuilder();
                builder.append("\n[Raw write" + (hsData ? "" : " (bb)") + "]: length = " + data.remaining());
                builder.append((CharSequence)Hexifys.dump("", data));
                Debugger.packet.debug(builder.toString());
                builder = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    synchronized SSLEngineResult.HandshakeStatus writeRecord(EngineOutputRecord outputRecord, EngineArgs ea, Authenticator authenticator, CipherBox writeCipher) throws IOException {
        if (this.hasOutboundDataInternal()) {
            SSLEngineResult.HandshakeStatus hss = this.getOutboundData(ea.netData);
            this.debuggingDumpPacket(ea, true);
            return hss;
        }
        if (this.outboundClosed) {
            throw new IOException("The write side was already closed");
        }
        outputRecord.write(ea, authenticator, writeCipher);
        this.debuggingDumpPacket(ea, false);
        return null;
    }

    void putOutboundData(ByteBuffer bytes) {
        this.outboundList.addLast(bytes);
    }

    synchronized void putOutboundDataSync(ByteBuffer bytes) throws IOException {
        if (this.outboundClosed) {
            throw new IOException("Write side already closed");
        }
        this.outboundList.addLast(bytes);
    }

    private boolean hasOutboundDataInternal() {
        return this.outboundList.size() != 0;
    }

    synchronized boolean hasOutboundData() {
        return this.hasOutboundDataInternal();
    }

    synchronized boolean isOutboundDone() {
        return this.outboundClosed && !this.hasOutboundDataInternal();
    }

    synchronized void closeOutbound() {
        this.outboundClosed = true;
    }
}

