/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.tls.sun.security.ssl.prf;

import cfca.sadk.tls.i18n.JSSEMessage;
import cfca.sadk.tls.sun.security.ssl.SSLProtocolVersionConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsConstants;
import cfca.sadk.tls.sun.security.ssl.prf.TlsKeyMaterialsTools;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretKey;
import cfca.sadk.tls.sun.security.ssl.prf.TlsMasterSecretParameters;
import cfca.sadk.tls.sun.security.ssl.prf.TlsPrfGenerator;
import cfca.sadk.tls.sun.security.ssl.sec.JSSEJCE;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.util.Arrays;
import javax.crypto.SecretKey;

final class TlsMasterSecretGenerator
implements TlsKeyMaterialsConstants,
SSLProtocolVersionConstants {
    static final int[] versions = new int[]{257, 258, 768, 769, 770, 771};

    TlsMasterSecretGenerator() {
    }

    static final boolean hasVersion(int version) {
        return Arrays.binarySearch(versions, version) >= 0;
    }

    final TlsMasterSecretKey generateMasterKey(TlsMasterSecretParameters params) throws GeneralSecurityException {
        int premasterMinor;
        int premasterMajor;
        int protocolVersion = this.checkParameters(params);
        SecretKey premasterKey = params.getPremasterSecret();
        byte[] premaster = premasterKey.getEncoded();
        if (premasterKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            premasterMajor = premaster[0] & 0xFF;
            premasterMinor = premaster[1] & 0xFF;
        } else {
            premasterMajor = -1;
            premasterMinor = -1;
        }
        int mastkeyLength = 48;
        try {
            byte[] master;
            byte[] clientRandom = params.getClientRandom();
            byte[] serverRandom = params.getServerRandom();
            byte[] seed = TlsKeyMaterialsTools.concat(clientRandom, serverRandom);
            switch (protocolVersion) {
                case 768: {
                    master = TlsMasterSecretGenerator.doSSL30PRF(premaster, clientRandom, serverRandom, 48);
                    break;
                }
                case 257: 
                case 258: {
                    master = TlsPrfGenerator.doTLS12PRF(premaster, LABEL_MASTER_SECRET, seed, 48, params.getPrfHashParameters());
                    break;
                }
                case 771: {
                    master = TlsPrfGenerator.doTLS12PRF(premaster, LABEL_MASTER_SECRET, seed, 48, params.getPrfHashParameters());
                    break;
                }
                case 769: 
                case 770: {
                    master = TlsPrfGenerator.doTLS10PRF(premaster, LABEL_MASTER_SECRET, seed, 48);
                    break;
                }
                default: {
                    throw new InvalidAlgorithmParameterException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
                }
            }
            return new TlsMasterSecretKey(master, premasterMajor, premasterMinor);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
        catch (DigestException e) {
            throw new ProviderException(e);
        }
    }

    private int checkParameters(TlsMasterSecretParameters params) throws InvalidAlgorithmParameterException {
        if (params == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsMasterSecretParameters"));
        }
        if (params.getPremasterSecret() == null) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.notInitialized", "TlsMasterSecretParameters#PremasterSecret"));
        }
        if (!"RAW".equals(params.getPremasterSecret().getFormat())) {
            throw new IllegalArgumentException(JSSEMessage.getMessage("cfca.sadk.tls.parameters.mustBeRAW", "TlsMasterSecretParameters#PremasterSecret"));
        }
        int protocolVersion = params.getMajorVersion() << 8 | params.getMinorVersion();
        if (!TlsMasterSecretGenerator.hasVersion(protocolVersion)) {
            throw new InvalidAlgorithmParameterException(JSSEMessage.getMessage("cfca.sadk.tls.runfailure.sslVersionLimited"));
        }
        return protocolVersion;
    }

    private static byte[] doSSL30PRF(byte[] premaster, byte[] clientRandom, byte[] serverRandom, int mastkeyLength) throws NoSuchAlgorithmException, DigestException {
        byte[] master = new byte[mastkeyLength];
        MessageDigest md5 = JSSEJCE.getMessageDigest("MD5");
        MessageDigest sha = JSSEJCE.getMessageDigest("SHA1");
        byte[] tmp = new byte[20];
        for (int i = 0; i < 3; ++i) {
            sha.update(SSL3_CONST[i]);
            sha.update(premaster);
            sha.update(clientRandom);
            sha.update(serverRandom);
            sha.digest(tmp, 0, 20);
            md5.update(premaster);
            md5.update(tmp);
            md5.digest(master, i << 4, 16);
        }
        return master;
    }
}

