/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.seal.util;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.com.itextpdf.forms.PdfAcroForm;
import cfca.sadk.com.itextpdf.forms.fields.PdfFormField;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfDocument;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfReader;
import cfca.sadk.com.itextpdf.kernel.pdf.PdfWriter;
import cfca.sadk.com.itextpdf.kernel.utils.PdfMerger;
import cfca.sadk.seal.base.exception.SealException;
import cfca.sadk.seal.base.util.MethodCostTimeUtil;
import cfca.sadk.seal.base.util.ParamsCheckUtil;
import cfca.sadk.seal.util.PDFSplitUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class PDFMergeUtil {
    private static Logger businessLog = LoggerFactory.getLogger(PDFSplitUtil.class);
    public static final String START_PAGE_NUM_KEY = "startPageNumKey";
    public static final String END_PAGE_NUM_KEY = "endPageNumKey";
    public static final String SRC_INPUT_FILE_PATH = "srcInputFilePath";

    public static void mergePDF(InputStream inputStream, int startPageNum, int endPageNum, InputStream secondInputStream, int secondStartPageNum, int secondEndPageNum, OutputStream outputStream) throws SealException {
        businessLog.info("mergePDF begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("mergePDF");
        try {
            byte[] inputBytes1 = IOUtils.toByteArray((InputStream)inputStream);
            byte[] inputBytes2 = IOUtils.toByteArray((InputStream)secondInputStream);
            PDFMergeUtil.checkFieldName(inputBytes1);
            PDFMergeUtil.checkFieldName(inputBytes2);
            PdfDocument pdfReaderDoc = new PdfDocument(new PdfReader(inputBytes1), false);
            PdfDocument secondPdfReaderDoc = new PdfDocument(new PdfReader(inputBytes2), false);
            ParamsCheckUtil.checkPageNum(pdfReaderDoc, startPageNum, endPageNum);
            ParamsCheckUtil.checkPageNum(secondPdfReaderDoc, secondStartPageNum, secondEndPageNum);
            PdfDocument pdfWriterDoc = new PdfDocument(new PdfWriter(outputStream));
            PdfMerger merger = new PdfMerger(pdfWriterDoc).setCloseSourceDocuments(true);
            merger.merge(pdfReaderDoc, startPageNum, endPageNum);
            merger.merge(secondPdfReaderDoc, secondStartPageNum, secondEndPageNum);
            pdfWriterDoc.close();
        }
        catch (IOException e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e.getMessage());
        }
        catch (Exception e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
        }
        businessLog.info("mergePDF end...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkFieldName(byte[] pdfData) throws IOException {
        PdfDocument pdfReaderDoc = null;
        try {
            pdfReaderDoc = new PdfDocument(new PdfReader(pdfData), false);
            PdfAcroForm acroForm = PdfAcroForm.getAcroForm(pdfReaderDoc, false);
            if (null != acroForm) {
                Map<String, PdfFormField> fieldMap = acroForm.getFormFields();
                for (String fieldName : fieldMap.keySet()) {
                    String regxStr = "^[a-zA-Z]{1,}[0-9]*$";
                    Pattern pattern = Pattern.compile(regxStr);
                    Matcher matcher = pattern.matcher(fieldName);
                    if (matcher.find()) continue;
                    throw new IOException("only support field name including alphanumeric and starting with a-z or A-Z!");
                }
            }
        }
        catch (Exception e) {
            businessLog.error("checkFieldName failed", (Throwable)e);
        }
        finally {
            if (null != pdfReaderDoc) {
                pdfReaderDoc.close();
            }
        }
    }

    public static void mergePDF(InputStream inputStream, InputStream secondInputStream, OutputStream outputStream) throws SealException {
        businessLog.info("mergePDF begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("mergePDF");
        try {
            byte[] inputBytes1 = IOUtils.toByteArray((InputStream)inputStream);
            byte[] inputBytes2 = IOUtils.toByteArray((InputStream)secondInputStream);
            PDFMergeUtil.checkFieldName(inputBytes1);
            PDFMergeUtil.checkFieldName(inputBytes2);
            PdfDocument pdfReaderDoc = new PdfDocument(new PdfReader(inputBytes1), false);
            PdfDocument secondPdfreaderDoc = new PdfDocument(new PdfReader(inputBytes2), false);
            PdfDocument pdfWriterDoc = new PdfDocument(new PdfWriter(outputStream));
            PdfMerger merger = new PdfMerger(pdfWriterDoc).setCloseSourceDocuments(true);
            merger.merge(pdfReaderDoc, 1, pdfReaderDoc.getNumberOfPages());
            merger.merge(secondPdfreaderDoc, 1, secondPdfreaderDoc.getNumberOfPages());
            pdfWriterDoc.close();
        }
        catch (IOException e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e.getMessage());
        }
        catch (Exception e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
        }
        businessLog.info("mergePDF end...");
    }

    public static byte[] mergePDF(List<byte[]> pdfList) throws SealException {
        businessLog.info("mergePDF begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("mergePDF");
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PdfDocument pdfWriterDoc = new PdfDocument(new PdfWriter(outputStream));
            PdfMerger merger = new PdfMerger(pdfWriterDoc).setCloseSourceDocuments(true);
            for (int i = 0; i < pdfList.size(); ++i) {
                byte[] pdfData = pdfList.get(i);
                PDFMergeUtil.checkFieldName(pdfData);
                PdfDocument pdfReaderDoc = new PdfDocument(new PdfReader(pdfData), false);
                merger.merge(pdfReaderDoc, 1, pdfReaderDoc.getNumberOfPages());
            }
            pdfWriterDoc.close();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e.getMessage());
        }
        catch (Exception e) {
            businessLog.error("mergePDF failed:", (Throwable)e);
            throw new SealException("mergePDF failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
            businessLog.info("mergePDF end...");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void mergeMultiPDF(List<Map<String, Object>> pdfList, OutputStream outputStream) throws SealException {
        businessLog.info("mergeMultiPDF begin...");
        String methodName = MethodCostTimeUtil.recordStartTime("mergeMultiPDF");
        try {
            PdfMerger merger;
            if (pdfList != null && pdfList.size() > 0) {
                PdfWriter pdfWriter = new PdfWriter(outputStream);
                PdfDocument pdfWriterDoc = new PdfDocument(pdfWriter);
                merger = new PdfMerger(pdfWriterDoc).setCloseSourceDocuments(true);
                PdfDocument pdfReaderDoc = null;
                FileInputStream inputStream = null;
                for (int i = 0; i < pdfList.size(); ++i) {
                    try {
                        Map<String, Object> map = pdfList.get(i);
                        String inputFilePath = (String)map.get(SRC_INPUT_FILE_PATH);
                        if (StringUtils.isEmpty((String)inputFilePath)) {
                            throw new SealException("inputFilePath is null!");
                        }
                        inputStream = new FileInputStream(inputFilePath);
                        byte[] inputBytes1 = IOUtils.toByteArray((InputStream)inputStream);
                        PDFMergeUtil.checkFieldName(inputBytes1);
                        pdfReaderDoc = new PdfDocument(new PdfReader(inputBytes1), false);
                        Object startPage = map.get(START_PAGE_NUM_KEY);
                        int startPageNum = 1;
                        if (startPage != null && !startPage.toString().equals("-1")) {
                            startPageNum = Integer.parseInt(startPage.toString());
                        }
                        Object endPage = map.get(END_PAGE_NUM_KEY);
                        int endPageNum = pdfReaderDoc.getNumberOfPages();
                        if (endPage != null && !endPage.toString().equals("-1")) {
                            endPageNum = Integer.parseInt(endPage.toString());
                        }
                        ParamsCheckUtil.checkPageNum(i + 1, pdfReaderDoc, startPageNum, endPageNum);
                        merger.setMergeFields(true);
                        merger.merge(pdfReaderDoc, startPageNum, endPageNum);
                    }
                    catch (IOException e) {
                        try {
                            businessLog.error("mergePDF failed:", (Throwable)e);
                            throw new SealException("mergePDF failed", e.getMessage());
                            catch (Exception e2) {
                                businessLog.error("mergeMultiPDF failed:", (Throwable)e2);
                                throw new SealException("mergeMultiPDF failed", e2);
                            }
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            } else {
                throw new SealException("pdfList is null");
            }
            merger.close();
        }
        catch (SealException e) {
            businessLog.error("mergeMultiPDF failed", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            businessLog.error("mergeMultiPDF failed", (Throwable)e);
            throw new SealException("mergeMultiPDF failed", e);
        }
        finally {
            MethodCostTimeUtil.recordEndTime(methodName);
        }
        businessLog.info("mergeMultiPDF end...");
    }
}

