/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.envelope.FileEncryptedInputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.BERSequence;
import cfca.sadk.org.bouncycastle.asn1.BERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

final class FileEncryptedContentInfo
extends ASN1Object {
    private ASN1ObjectIdentifier contentType;
    private AlgorithmIdentifier contentEncryptionAlgorithm;
    private FileEncryptedInputStream encryptedStream;

    FileEncryptedContentInfo(ASN1ObjectIdentifier contentType, AlgorithmIdentifier contentEncryptionAlgorithm, FileEncryptedInputStream encryptedStream) {
        this.contentType = contentType;
        this.contentEncryptionAlgorithm = contentEncryptionAlgorithm;
        this.encryptedStream = encryptedStream;
    }

    private FileEncryptedContentInfo(ASN1Sequence seq) {
        if (seq.size() < 2) {
            throw new IllegalArgumentException("Truncated Sequence Found");
        }
        this.contentType = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        this.contentEncryptionAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.encryptedStream = FileEncryptedInputStream.getInstance(seq.getObjectAt(2));
        }
    }

    public static FileEncryptedContentInfo getInstance(Object obj) {
        if (obj instanceof FileEncryptedContentInfo) {
            return (FileEncryptedContentInfo)obj;
        }
        if (obj != null) {
            return new FileEncryptedContentInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public AlgorithmIdentifier getContentEncryptionAlgorithm() {
        return this.contentEncryptionAlgorithm;
    }

    public FileEncryptedInputStream getEncryptedContent() {
        return this.encryptedStream;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.contentType);
        v.add(this.contentEncryptionAlgorithm);
        if (this.encryptedStream != null) {
            v.add(new BERTaggedObject(false, 0, this.encryptedStream));
        }
        return new BERSequence(v);
    }
}

