/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.com.itextpdf.kernel.events;

import cfca.sadk.com.itextpdf.kernel.events.Event;
import cfca.sadk.com.itextpdf.kernel.events.IEventDispatcher;
import cfca.sadk.com.itextpdf.kernel.events.IEventHandler;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventDispatcher
implements IEventDispatcher,
Serializable {
    private static final long serialVersionUID = -6701670578690210618L;
    protected Map<String, List<IEventHandler>> eventHandlers = new HashMap<String, List<IEventHandler>>();

    @Override
    public void addEventHandler(String type, IEventHandler handler) {
        this.removeEventHandler(type, handler);
        List<IEventHandler> handlers = this.eventHandlers.get(type);
        if (handlers == null) {
            handlers = new ArrayList<IEventHandler>();
            this.eventHandlers.put(type, handlers);
        }
        handlers.add(handler);
    }

    @Override
    public void dispatchEvent(Event event) {
        this.dispatchEvent(event, false);
    }

    @Override
    public void dispatchEvent(Event event, boolean delayed) {
        List<IEventHandler> handlers = this.eventHandlers.get(event.getType());
        if (handlers != null) {
            for (IEventHandler handler : handlers) {
                handler.handleEvent(event);
            }
        }
    }

    @Override
    public boolean hasEventHandler(String type) {
        return this.eventHandlers.containsKey(type);
    }

    @Override
    public void removeEventHandler(String type, IEventHandler handler) {
        List<IEventHandler> handlers = this.eventHandlers.get(type);
        if (handlers == null) {
            return;
        }
        handlers.remove(handler);
        if (handlers.size() == 0) {
            this.eventHandlers.remove(type);
        }
    }

    @Override
    public void removeAllHandlers() {
        this.eventHandlers.clear();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException(this.getClass().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new NotSerializableException(this.getClass().toString());
    }
}

