/*
 * Decompiled with CFR 0.152.
 */
package cfca.paperless.base.util.validity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParamCheckUtil {
    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isEmpty(byte[] bytes) throws Exception {
        return null == bytes || bytes.length == 0;
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static boolean validate(String string) {
        String regEx = "^[\\!\\w\\.\\?\\+\\-\\=\\/\\:\\,\\s\u4e00-\u9fa5]*$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(string);
        return m.matches();
    }

    public static boolean containChinese(String string) {
        String regEx = "^[\u4e00-\u9fa5]{1}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(string);
        return m.matches();
    }

    public static boolean isChineseOnly(String string) {
        String regEx = "^[\u4e00-\u9fa5]{0,}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(string);
        return m.matches();
    }

    public static boolean isEmail(String string) {
        String regEx = "^[\u4e00-\u9fa5]{1}$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(string);
        return m.matches();
    }

    public static boolean isNumeric(String value) {
        if (null == value || "".equals(value.trim())) {
            return false;
        }
        String regEx = "^(([1-9]\\d{0,9})|0)(\\.\\d{1,2})?$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean isPositiveInteger(String value) {
        if (null == value || "".equals(value.trim())) {
            return false;
        }
        String regEx = "^[1-9]+\\d*$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher m = pattern.matcher(value);
        return m.matches();
    }

    public static boolean checkValueInValid(String value) {
        String regEx = "[`~!@#$%^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(value);
        return m.find();
    }

    public static boolean checkValueInValid2(String value) {
        String regEx = "^[a-zA-Z0-9_]+$";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(value);
        return !m.find();
    }

    public static boolean checkNumber(String num, String type) {
        String eL = "";
        eL = "0+".equals(type) ? "^\\d+$" : ("+".equals(type) ? "^\\d*[1-9]\\d*$" : ("-0".equals(type) ? "^((-\\d+)|(0+))$" : ("-".equals(type) ? "^-\\d*[1-9]\\d*$" : "^-?\\d+$")));
        Pattern p = Pattern.compile(eL);
        Matcher m = p.matcher(num);
        boolean b = m.matches();
        return b;
    }
}

