/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.extend.session.bridge.impl.sm2;

import cfca.sadk.extend.session.CryptoException;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardBigIntegers;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardKey;
import cfca.sadk.extend.session.bridge.impl.sm2.SM2CardPublicKey;
import cfca.sadk.extend.session.util.DataHelper;
import cfca.sadk.extend.session.util.NumberHelper;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPrivateKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.GMTPublicKey;
import java.math.BigInteger;

public final class SM2CardExternalPrivateKey
extends GMTPrivateKey
implements SM2CardKey {
    private static final long serialVersionUID = -1064885852643206703L;
    private static final int STRENGTH = 32;
    private final int bitLength;
    private final byte[] priKeyData = this.buildKeyData();
    private String pubKeyInfo;

    public SM2CardExternalPrivateKey(BigInteger d, BigInteger iPubX, BigInteger iPubY) {
        super(d, iPubX, iPubY);
        this.bitLength = 32;
    }

    public SM2CardExternalPrivateKey(byte[] dBytes, byte[] bPubX, byte[] bPubY) {
        super(dBytes, bPubX, bPubY);
        this.bitLength = 32;
    }

    public SM2CardExternalPrivateKey(byte[] encoding) {
        super(encoding);
        this.bitLength = 32;
    }

    public SM2CardExternalPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters, ECPublicKeyParameters ecPublicKeyParameters) {
        super(ecPrivateKeyParameters, ecPublicKeyParameters);
        this.bitLength = 32;
    }

    public SM2CardExternalPrivateKey(ECPrivateKeyParameters ecPrivateKeyParameters) {
        super(ecPrivateKeyParameters);
        this.bitLength = 32;
    }

    static SM2CardExternalPrivateKey buildExternalSoftKey(byte[] priKeyData) throws CryptoException {
        return new SM2CardExternalPrivateKey(SM2CardExternalPrivateKey.parseDbytes(priKeyData));
    }

    private static byte[] parseDbytes(byte[] priKeyData) throws CryptoException {
        return SM2CardBigIntegers.parseBytes(priKeyData, 4, 32);
    }

    private byte[] buildKeyData() {
        byte[] dBytes = this.getDByBytes();
        if (dBytes == null || dBytes.length != 32) {
            throw new IllegalArgumentException("buildKeyData failure invalid SM2#dBytes");
        }
        byte[] keyData = new byte[36];
        int offset = 0;
        try {
            offset += SM2CardBigIntegers.copyBitLength(this.bitLength, keyData, offset);
            offset += SM2CardBigIntegers.copyBytes("SM2#dBytes", dBytes, keyData, offset);
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("buildKeyData failure", e);
        }
        return keyData;
    }

    public boolean isInternalKey() {
        return false;
    }

    public int getKeyIndex() {
        return 0;
    }

    public int getKeyUsage() {
        return 0;
    }

    public int modulusBitsLength() {
        return this.bitLength;
    }

    public int modulusByteLength() {
        return this.bitLength >> 3;
    }

    public byte[] keyData() throws CryptoException {
        return (byte[])this.priKeyData.clone();
    }

    public String dumpPublicKey() {
        GMTPublicKey pubKey;
        if (this.pubKeyInfo == null && (pubKey = this.getSM2PublicKey()) != null) {
            this.pubKeyInfo = SM2CardPublicKey.buildKeyInfo(pubKey.getPubX(), pubKey.getPubY(), pubKey.getDefaultZ());
        }
        return this.pubKeyInfo;
    }

    public byte[] getPubX() {
        GMTPublicKey pubKey = this.getSM2PublicKey();
        byte[] pubX = null;
        if (pubKey != null) {
            pubX = pubKey.getPubX();
        }
        return pubX;
    }

    public byte[] getPubY() {
        GMTPublicKey pubKey = this.getSM2PublicKey();
        byte[] pubY = null;
        if (pubKey != null) {
            pubY = pubKey.getPubY();
        }
        return pubY;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SM2CardExternalPrivateKey [bitLength=").append(this.bitLength);
        builder.append(",isInternalKey=").append(this.isInternalKey());
        builder.append(",pubX=").append(DataHelper.toHexString(this.getPubX()));
        builder.append(",pubY=").append(DataHelper.toHexString(this.getPubY()));
        builder.append(",defZ=").append(DataHelper.toHexString(this.getDefaultZ()));
        builder.append(",md5D=").append(NumberHelper.md5(this.getDByBytes()));
        builder.append("]");
        return builder.toString();
    }
}

